/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.engin.gui.navi.client.locale.parts;

import de.elpro.ewms.core.client.Transactions;
import de.elpro.ewms.core.client.locale.LocaleDefinitionDAO;
import de.elpro.ewms.core.db.DAOOperationException;
import de.elpro.ewms.core.db.Transaction;
import de.elpro.ewms.core.locale.LocaleDefinition;
import de.elpro.ewms.core.tables.ColumnGroup;
import de.elpro.ewms.engin.gui.services.EnginPartUtils;
import de.elpro.ui.fx.propertysheet.BooleanPropertyItem;
import de.elpro.ui.fx.propertysheet.IconPropertyItem;
import de.elpro.ui.fx.propertysheet.IntegerPropertyItem;
import de.elpro.ui.fx.propertysheet.NumberPropertyItem;
import de.elpro.ui.fx.propertysheet.PropertyItemsHelper;
import de.elpro.ui.fx.propertysheet.StringPropertyItem;
import de.elpro.ui.fx.validator.Validators;
import de.elpro.ui.utils.e4.PartUtils;
import java.util.Collection;
import javafx.beans.property.ReadOnlyProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.value.ObservableValue;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.layout.BorderPane;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import org.controlsfx.control.PropertySheet;
import org.controlsfx.dialog.ExceptionDialog;
import org.eclipse.e4.ui.di.Persist;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.workbench.modeling.EPartService;

public class LocaleDefinitionEditPart {
    public static final String ID = "de.elpro.ewms.engin.gui.partdescriptor.locales.localedefinition";
    @Inject
    private LocaleDefinition localeDefinition;
    @Inject
    private MPart part;
    @Inject
    private EPartService partService;
    private final PropertySheet sheet = new PropertySheet();
    private final SimpleBooleanProperty hasChanges = new SimpleBooleanProperty(false);
    private final SimpleBooleanProperty hasErrors = new SimpleBooleanProperty(false);
    private NumberPropertyItem<Integer> idItem;

    @PostConstruct
    public void postConstruct(BorderPane parent) {
        Transaction trx = Transactions.begin();
        try {
            if (this.localeDefinition.getId() != null) {
                this.localeDefinition = LocaleDefinitionDAO.get((Transaction)trx, (int)this.localeDefinition.getId());
            }
        }
        finally {
            Transactions.close((Transaction)trx);
        }
        this.idItem = new IntegerPropertyItem("Id", (ObservableValue)this.localeDefinition.idProperty());
        this.idItem.setReadOnly(true);
        StringPropertyItem localeKeyItem = new StringPropertyItem("Locale Key", (ObservableValue)this.localeDefinition.localeKeyProperty());
        localeKeyItem.setValidator(Validators.createValidator((o, ov, nv) -> LocaleDefinition.tryGetLocale((String)((String)nv)) != null, (String)"Locale Key is not a Valid"));
        IconPropertyItem logoKeyItem = new IconPropertyItem("Flag", (ObservableValue)this.localeDefinition.logoKeyProperty());
        logoKeyItem.setIconsFolderPrefix("/icons/16x16/flags/");
        logoKeyItem.setNullable(false);
        logoKeyItem.setValidator(Validators.createNotEmptyValidator((String)"Select Flag"));
        StringPropertyItem nameItem = new StringPropertyItem("Name", (ObservableValue)this.localeDefinition.nameProperty());
        nameItem.setValidator(Validators.createNotEmptyValidator((String)"Name must be not empty"));
        BooleanPropertyItem engineeringItem = new BooleanPropertyItem("Engineering Locale", (ReadOnlyProperty)this.localeDefinition.engineeringLocaleProperty());
        BooleanPropertyItem fallbackItem = new BooleanPropertyItem("Fallback Locale", (ReadOnlyProperty)this.localeDefinition.fallbackLocaleProperty());
        this.sheet.getItems().addAll((Object[])new PropertySheet.Item[]{this.idItem, localeKeyItem, logoKeyItem, nameItem, engineeringItem, fallbackItem});
        this.hasChanges.bind((ObservableValue)PropertyItemsHelper.createHasChangesProperty((Collection)this.sheet.getItems()));
        this.hasErrors.bind((ObservableValue)PropertyItemsHelper.createHasErrorsProperty((Collection)this.sheet.getItems()));
        parent.setCenter((Node)this.sheet);
        this.hasChanges.addListener((o, ov, nv) -> this.part.setDirty(nv.booleanValue()));
    }

    @Persist
    public void save() {
        if (!this.hasChanges.get()) {
            return;
        }
        if (this.hasErrors.get()) {
            Alert alert = new Alert(Alert.AlertType.WARNING);
            alert.setContentText(String.format("Cannot save %s. Fix errors first.", this.localeDefinition.toString()));
            alert.showAndWait();
            return;
        }
        Transaction trx = Transactions.begin();
        try {
            try {
                this.idItem.setValue((Object)LocaleDefinitionDAO.saveOrUpdate((Transaction)trx, (LocaleDefinition)this.localeDefinition));
                Transactions.commitSync((Transaction)trx);
                PropertyItemsHelper.resetHasChangesProperties((Collection)this.sheet.getItems());
                this.part.setDirty(false);
                this.part.setLabel(this.localeDefinition.toString());
                EnginPartUtils.refreshItems(this.localeDefinition, this.part);
            }
            catch (DAOOperationException exc) {
                Transactions.rollback((Transaction)trx);
                ExceptionDialog dlg = new ExceptionDialog((Throwable)exc);
                dlg.setContentText("Error saving locale definition");
                dlg.show();
                Transactions.close((Transaction)trx);
                return;
            }
        }
        finally {
            Transactions.close((Transaction)trx);
        }
        PartUtils.refreshParts((EPartService)this.partService, ColumnGroup.class);
    }

    @PreDestroy
    protected void close() {
        this.part.setDirty(false);
    }
}

