/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.engin.gui.navi.client.report.handlers;

import de.elpro.ewms.core.client.Transactions;
import de.elpro.ewms.core.client.report.TableReportConfigDAO;
import de.elpro.ewms.core.db.Transaction;
import de.elpro.ewms.core.report.TableReportConfig;
import de.elpro.ui.model.UIModelElement;
import javafx.scene.control.Alert;
import javafx.scene.control.TreeItem;
import javax.inject.Named;
import org.controlsfx.dialog.ExceptionDialog;
import org.eclipse.e4.core.di.annotations.CanExecute;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.ui.model.application.MApplication;

public class TableReportConfigClearConfigHandler {
    @Execute
    public void execute(MApplication app, @Optional @Named(value="org.eclipse.ui.selection") @Named(value="org.eclipse.ui.selection") TreeItem<UIModelElement> item) {
        Transaction trx = Transactions.begin();
        try {
            try {
                TableReportConfig config = (TableReportConfig)item.getValue();
                config = TableReportConfigDAO.get((Transaction)trx, (int)config.getId());
                config.setConfig(null);
                TableReportConfigDAO.saveOrUpdate((Transaction)trx, (TableReportConfig)config);
                Transactions.commitSync((Transaction)trx);
                Alert alert = new Alert(Alert.AlertType.INFORMATION);
                alert.setContentText("Config cleared successfully");
                alert.showAndWait();
            }
            catch (Exception exc) {
                Transactions.rollback((Transaction)trx);
                ExceptionDialog dlg = new ExceptionDialog((Throwable)exc);
                dlg.setContentText("Error clearing config config");
                dlg.show();
                Transactions.close((Transaction)trx);
            }
        }
        finally {
            Transactions.close((Transaction)trx);
        }
    }

    @CanExecute
    public boolean canExecute(@Optional @Named(value="org.eclipse.ui.selection") @Named(value="org.eclipse.ui.selection") TreeItem<?> item) {
        return item != null && item.getValue() instanceof TableReportConfig;
    }
}

