/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.engin.gui.navi.client.report.parts;

import de.elpro.ewms.core.client.Transactions;
import de.elpro.ewms.core.client.report.ReportProfileDAO;
import de.elpro.ewms.core.client.report.ReportTemplateDAO;
import de.elpro.ewms.core.client.structure.StructureClassDAO;
import de.elpro.ewms.core.client.structure.StructureObjectDAO;
import de.elpro.ewms.core.db.DAOOperationException;
import de.elpro.ewms.core.db.Transaction;
import de.elpro.ewms.core.report.ReportItemGroupType;
import de.elpro.ewms.core.report.ReportProfile;
import de.elpro.ewms.core.report.ReportTemplate;
import de.elpro.ewms.core.structure.StructureClass;
import de.elpro.ewms.engin.gui.services.EnginPartUtils;
import de.elpro.ui.fx.propertysheet.ChoicePropertyItem;
import de.elpro.ui.fx.propertysheet.EnumPropertyItem;
import de.elpro.ui.fx.propertysheet.IntegerPropertyItem;
import de.elpro.ui.fx.propertysheet.NumberPropertyItem;
import de.elpro.ui.fx.propertysheet.PropertyItemsHelper;
import de.elpro.ui.fx.propertysheet.StringPropertyItem;
import de.elpro.ui.fx.validator.Validators;
import de.elpro.ui.utils.e4.PartUtils;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.value.ObservableValue;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.layout.BorderPane;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import org.controlsfx.control.PropertySheet;
import org.controlsfx.dialog.ExceptionDialog;
import org.eclipse.e4.ui.di.Persist;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.workbench.modeling.EPartService;

public class ReportProfileEditPart {
    public static final String ID = "de.elpro.ewms.engin.gui.partdescriptor.report.reportprofile";
    @Inject
    private ReportProfile profile;
    @Inject
    private MPart part;
    @Inject
    private EPartService partService;
    private final PropertySheet sheet = new PropertySheet();
    private final SimpleBooleanProperty hasChanges = new SimpleBooleanProperty(false);
    private final SimpleBooleanProperty hasErrors = new SimpleBooleanProperty(false);
    private NumberPropertyItem<Integer> idItem;

    @PostConstruct
    public void postConstruct(BorderPane parent) {
        Transaction trx = Transactions.begin();
        LinkedList<ReportTemplate> templates = new LinkedList<ReportTemplate>();
        LinkedList<StructureClass> classes = new LinkedList<StructureClass>();
        try {
            if (this.profile.getId() != null) {
                this.profile = ReportProfileDAO.get((Transaction)trx, (int)this.profile.getId());
            }
            if (this.profile.getStructureClass() != null) {
                this.profile.setStructureClass(StructureClassDAO.get((Transaction)trx, (int)this.profile.getStructureClass().getId()));
            }
            if (this.profile.getStructureObject() != null) {
                this.profile.setStructureObject(StructureObjectDAO.get((Transaction)trx, (int)this.profile.getStructureObject().getId()));
            }
            if (this.profile.getTemplate() != null) {
                this.profile.setTemplate(ReportTemplateDAO.get((Transaction)trx, (int)this.profile.getTemplate().getId()));
            }
            templates.addAll(Arrays.asList(ReportTemplateDAO.getAll((Transaction)trx)));
            classes.addAll(Arrays.asList(StructureClassDAO.getAll((Transaction)trx)));
        }
        finally {
            Transactions.close((Transaction)trx);
        }
        this.idItem = new IntegerPropertyItem("Id", (ObservableValue)this.profile.idProperty());
        this.idItem.setReadOnly(true);
        StringPropertyItem nameItem = new StringPropertyItem("Name", (ObservableValue)this.profile.nameProperty());
        nameItem.setValidator(Validators.createNotEmptyValidator((String)"Name cannot be empty"));
        ChoicePropertyItem classItem = new ChoicePropertyItem("Structure Class", (ObservableValue)this.profile.structureClassProperty(), classes);
        classItem.setNullable(false);
        classItem.setValidator(Validators.createNotEmptyValidator((String)"Select Structure Class"));
        ChoicePropertyItem objectItem = new ChoicePropertyItem("Fixed Object", (ObservableValue)this.profile.structureObjectProperty(), StructureClassDAO.getAllObjects((StructureClass)this.profile.getStructureClass()));
        classItem.valueProperty().addListener((o, ov, nv) -> objectItem.setChoices(StructureClassDAO.getAllObjects((StructureClass)nv)));
        ChoicePropertyItem templateItem = new ChoicePropertyItem("Template", (ObservableValue)this.profile.templateProperty(), templates);
        templateItem.setNullable(false);
        templateItem.setValidator(Validators.createNotEmptyValidator((String)"Select Template"));
        EnumPropertyItem groupTypeItem = new EnumPropertyItem("Group By", ReportItemGroupType.class, (ObservableValue)this.profile.groupByProperty());
        StringPropertyItem descriptionItem = new StringPropertyItem("Desciption", (ObservableValue)this.profile.descriptionProperty());
        descriptionItem.useAreaEditor(true);
        this.sheet.getItems().addAll((Object[])new PropertySheet.Item[]{this.idItem, nameItem, classItem, objectItem, templateItem, groupTypeItem, descriptionItem});
        this.hasChanges.bind((ObservableValue)PropertyItemsHelper.createHasChangesProperty((Collection)this.sheet.getItems()));
        this.hasErrors.bind((ObservableValue)PropertyItemsHelper.createHasErrorsProperty((Collection)this.sheet.getItems()));
        this.sheet.setMode(PropertySheet.Mode.CATEGORY);
        parent.setCenter((Node)this.sheet);
        this.hasChanges.addListener((o, ov, nv) -> this.part.setDirty(nv.booleanValue()));
    }

    @Persist
    public void save() {
        if (!this.hasChanges.get()) {
            return;
        }
        if (this.hasErrors.get()) {
            Alert alert = new Alert(Alert.AlertType.WARNING);
            alert.setContentText(String.format("Cannot save %s. Fix errors first.", this.profile.toString()));
            alert.showAndWait();
            return;
        }
        Transaction trx = Transactions.begin();
        try {
            try {
                this.idItem.setValue((Object)ReportProfileDAO.saveOrUpdate((Transaction)trx, (ReportProfile)this.profile));
                Transactions.commitSync((Transaction)trx);
                PropertyItemsHelper.resetHasChangesProperties((Collection)this.sheet.getItems());
                this.part.setDirty(false);
                this.part.setLabel(this.profile.toString());
                EnginPartUtils.refreshItems(this.profile, this.part);
            }
            catch (DAOOperationException exc) {
                Transactions.rollback((Transaction)trx);
                ExceptionDialog dlg = new ExceptionDialog((Throwable)exc);
                dlg.setContentText("Error saving report profile");
                dlg.show();
                Transactions.close((Transaction)trx);
                return;
            }
        }
        finally {
            Transactions.close((Transaction)trx);
        }
        PartUtils.refreshParts((EPartService)this.partService, ReportProfile.class);
    }

    @PreDestroy
    protected void close() {
        this.part.setDirty(false);
    }
}

