/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.engin.gui.navi.client.report.parts;

import de.elpro.ewms.core.client.Transactions;
import de.elpro.ewms.core.client.report.TableReportConfigDAO;
import de.elpro.ewms.core.client.report.TableReportDAO;
import de.elpro.ewms.core.client.structure.StructureObjectDAO;
import de.elpro.ewms.core.client.tables.TableDAO;
import de.elpro.ewms.core.db.Transaction;
import de.elpro.ewms.core.fx.model.IExportable;
import de.elpro.ewms.core.fx.tables.VarTableView;
import de.elpro.ewms.core.report.TableReport;
import de.elpro.ewms.core.report.TableReportConfig;
import de.elpro.ewms.core.tables.Table;
import de.elpro.ewms.core.time.ITimeRangeFilter;
import de.elpro.ui.fx.utils.ColumnsPersistedState;
import java.util.Collections;
import java.util.List;
import javafx.beans.InvalidationListener;
import javafx.beans.property.Property;
import javafx.collections.ObservableList;
import javafx.scene.Node;
import javafx.scene.Scene;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.layout.BorderPane;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import org.controlsfx.dialog.ExceptionDialog;
import org.eclipse.e4.ui.di.Persist;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.fx.core.di.ContextValue;

public class TableReportConfigEditPart {
    public static final String ID = "de.elpro.ewms.engin.gui.partdescriptor.report.tableconfig";
    @Inject
    private TableReportConfig config;
    @Inject
    private MPart part;
    private ITimeRangeFilter timeRangeFilter;
    private VarTableView varTableView;
    @Inject
    @ContextValue(value="exportable-items")
    private Property<List<IExportable>> exportItems;

    @PostConstruct
    public void postConstruct(BorderPane parent, Scene scene) {
        Table table;
        TableReport tableReport;
        Transaction trx = Transactions.begin();
        try {
            this.config = TableReportConfigDAO.get((Transaction)trx, (int)this.config.getId());
            this.config.setStructureObject(StructureObjectDAO.get((Transaction)trx, (int)this.config.getStructureObject().getId()));
            tableReport = TableReportDAO.get((Transaction)trx, (int)this.config.getTableReport().getId());
            table = TableDAO.loadNormalized((Transaction)trx, (int)tableReport.getTable().getId());
        }
        finally {
            Transactions.close((Transaction)trx);
        }
        this.varTableView = new VarTableView(table, this.config.getStructureObject(), scene.getWindow(), this.timeRangeFilter, tableReport.getVirtualRaster());
        parent.setCenter((Node)this.varTableView);
        if (this.config.getConfig() != null) {
            try {
                ColumnsPersistedState state = ColumnsPersistedState.parse((String)this.config.getConfig());
                if (state != null) {
                    TableView reportObject = this.varTableView.getReportObject();
                    state.restoreColumnsState(reportObject.getColumns());
                }
            }
            catch (Exception exc) {
                ExceptionDialog dlg = new ExceptionDialog((Throwable)exc);
                dlg.setContentText("Error restoring column state");
                dlg.show();
            }
        }
        this.exportItems.setValue(Collections.singletonList(this.varTableView));
        TableView tableView = this.varTableView.getReportObject();
        this.addColumnWithListener(o -> this.part.setDirty(true), tableView.getColumns());
    }

    public <T> void addColumnWithListener(InvalidationListener il, ObservableList<TableColumn<T, ?>> columns) {
        for (TableColumn column : columns) {
            column.widthProperty().addListener(il);
            this.addColumnWithListener(il, column.getColumns());
        }
    }

    @Inject
    public void reload(ITimeRangeFilter timeRangeFilter) {
        this.timeRangeFilter = timeRangeFilter;
        if (this.varTableView != null) {
            this.varTableView.loadData(timeRangeFilter);
        }
    }

    @Persist
    protected void save() {
        Transaction trx = Transactions.begin();
        try {
            try {
                ColumnsPersistedState state = new ColumnsPersistedState();
                TableView view = this.varTableView.getReportObject();
                state.persistColumns(view.getColumns());
                this.config.setConfig(state.toString());
                TableReportConfigDAO.saveOrUpdate((Transaction)trx, (TableReportConfig)this.config);
                Transactions.commitSync((Transaction)trx);
                this.part.setDirty(false);
            }
            catch (Exception exc) {
                ExceptionDialog dlg = new ExceptionDialog((Throwable)exc);
                dlg.setContentText("Error persisting table state");
                dlg.show();
                Transactions.rollback((Transaction)trx);
                Transactions.close((Transaction)trx);
            }
        }
        finally {
            Transactions.close((Transaction)trx);
        }
    }
}

