/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.engin.gui.navi.client.report.parts;

import de.elpro.ewms.core.client.Transactions;
import de.elpro.ewms.core.client.report.ReportProfileDAO;
import de.elpro.ewms.core.client.report.TableReportDAO;
import de.elpro.ewms.core.client.tables.TableDAO;
import de.elpro.ewms.core.db.DAOOperationException;
import de.elpro.ewms.core.db.Transaction;
import de.elpro.ewms.core.report.TableReport;
import de.elpro.ewms.core.structure.StructureClass;
import de.elpro.ewms.core.tables.Table;
import de.elpro.ewms.core.virtualtime.VirtualRaster;
import de.elpro.ewms.engin.gui.services.EnginPartUtils;
import de.elpro.ui.fx.propertysheet.ChoicePropertyItem;
import de.elpro.ui.fx.propertysheet.EnumPropertyItem;
import de.elpro.ui.fx.propertysheet.IntegerPropertyItem;
import de.elpro.ui.fx.propertysheet.NumberPropertyItem;
import de.elpro.ui.fx.propertysheet.PropertyItemsHelper;
import de.elpro.ui.fx.propertysheet.StringPropertyItem;
import de.elpro.ui.fx.validator.Validators;
import de.elpro.ui.utils.e4.PartUtils;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.value.ObservableValue;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.layout.BorderPane;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import org.controlsfx.control.PropertySheet;
import org.controlsfx.dialog.ExceptionDialog;
import org.eclipse.e4.ui.di.Persist;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.workbench.modeling.EPartService;

public class TableReportEditPart {
    public static final String ID = "de.elpro.ewms.engin.gui.partdescriptor.report.tablereport";
    @Inject
    private TableReport tableReport;
    @Inject
    private MPart part;
    @Inject
    private EPartService partService;
    private final PropertySheet sheet = new PropertySheet();
    private final SimpleBooleanProperty hasChanges = new SimpleBooleanProperty(false);
    private final SimpleBooleanProperty hasErrors = new SimpleBooleanProperty(false);
    private NumberPropertyItem<Integer> idItem;

    @PostConstruct
    public void postConstruct(BorderPane parent) {
        Transaction trx = Transactions.begin();
        LinkedList<Table> tables = new LinkedList<Table>();
        try {
            if (this.tableReport.getId() != null) {
                this.tableReport = TableReportDAO.get((Transaction)trx, (int)this.tableReport.getId());
            }
            if (this.tableReport.getProfile() != null) {
                this.tableReport.setProfile(ReportProfileDAO.get((Transaction)trx, (int)this.tableReport.getProfile().getId()));
                tables.addAll(Arrays.asList(TableDAO.findByClass((Transaction)trx, (StructureClass)this.tableReport.getProfile().getStructureClass())));
            }
            if (this.tableReport.getTable() != null) {
                this.tableReport.setTable(TableDAO.get((Transaction)trx, (int)this.tableReport.getTable().getId()));
            }
        }
        finally {
            Transactions.close((Transaction)trx);
        }
        this.idItem = new IntegerPropertyItem("Id", (ObservableValue)this.tableReport.idProperty());
        this.idItem.setReadOnly(true);
        ChoicePropertyItem profileItem = new ChoicePropertyItem("Profile", (ObservableValue)this.tableReport.profileProperty());
        profileItem.setReadOnly(true);
        ChoicePropertyItem tableItem = new ChoicePropertyItem("Table", (ObservableValue)this.tableReport.tableProperty(), tables);
        tableItem.setNullable(false);
        tableItem.setValidator(Validators.createNotEmptyValidator((String)"Select Table"));
        EnumPropertyItem virualRasterItem = new EnumPropertyItem("Raster", VirtualRaster.class, (ObservableValue)this.tableReport.virtualRasterProperty());
        IntegerPropertyItem visualOrderPositionItem = new IntegerPropertyItem("Visual Order Position", (ObservableValue)this.tableReport.visualOrderPositionProperty());
        StringPropertyItem descriptionItem = new StringPropertyItem("Desciption", (ObservableValue)this.tableReport.descriptionProperty());
        descriptionItem.useAreaEditor(true);
        this.sheet.getItems().addAll((Object[])new PropertySheet.Item[]{this.idItem, profileItem, tableItem, virualRasterItem, visualOrderPositionItem, descriptionItem});
        this.hasChanges.bind((ObservableValue)PropertyItemsHelper.createHasChangesProperty((Collection)this.sheet.getItems()));
        this.hasErrors.bind((ObservableValue)PropertyItemsHelper.createHasErrorsProperty((Collection)this.sheet.getItems()));
        this.sheet.setMode(PropertySheet.Mode.CATEGORY);
        parent.setCenter((Node)this.sheet);
        this.hasChanges.addListener((o, ov, nv) -> this.part.setDirty(nv.booleanValue()));
    }

    @Persist
    public void save() {
        if (!this.hasChanges.get()) {
            return;
        }
        if (this.hasErrors.get()) {
            Alert alert = new Alert(Alert.AlertType.WARNING);
            alert.setContentText(String.format("Cannot save %s. Fix errors first.", this.tableReport.toString()));
            alert.showAndWait();
            return;
        }
        Transaction trx = Transactions.begin();
        try {
            try {
                this.idItem.setValue((Object)TableReportDAO.saveOrUpdate((Transaction)trx, (TableReport)this.tableReport));
                Transactions.commitSync((Transaction)trx);
                PropertyItemsHelper.resetHasChangesProperties((Collection)this.sheet.getItems());
                this.part.setDirty(false);
                this.part.setLabel(this.tableReport.toString());
                EnginPartUtils.refreshItems(this.tableReport, this.part);
            }
            catch (DAOOperationException exc) {
                Transactions.rollback((Transaction)trx);
                ExceptionDialog dlg = new ExceptionDialog((Throwable)exc);
                dlg.setContentText("Error saving table report");
                dlg.show();
                Transactions.close((Transaction)trx);
                return;
            }
        }
        finally {
            Transactions.close((Transaction)trx);
        }
        PartUtils.refreshParts((EPartService)this.partService, TableReport.class);
    }

    @PreDestroy
    protected void close() {
        this.part.setDirty(false);
    }
}

