/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.engin.gui.navi.client.tables.handlers;

import de.elpro.ewms.core.client.Transactions;
import de.elpro.ewms.core.client.structure.StructureClassDAO;
import de.elpro.ewms.core.client.tables.ColumnDAO;
import de.elpro.ewms.core.client.tables.ColumnGroupDAO;
import de.elpro.ewms.core.client.tables.TableDAO;
import de.elpro.ewms.core.db.Transaction;
import de.elpro.ewms.core.structure.StructureClass;
import de.elpro.ewms.core.tables.Column;
import de.elpro.ewms.core.tables.ColumnGroup;
import de.elpro.ewms.core.tables.Table;
import de.elpro.ewms.engin.gui.navi.client.tables.handlers.TablesEditHandler;
import de.elpro.ewms.engin.gui.navi.model.IDnDNavigationContribution;
import de.elpro.ewms.engin.gui.navi.model.INavigationTreeElement;
import de.elpro.ewms.engin.gui.navi.model.LazyNavigationContribution;
import de.elpro.ewms.gui.utils.e4.EOSPartUtils;
import de.elpro.ui.fx.controls.tree.LazyTreeItem;
import de.elpro.ui.fx.scene.InsertPositionLine;
import de.elpro.ui.fx.utils.FXUtils;
import de.elpro.ui.model.UIModelElement;
import de.elpro.ui.utils.e4.PartUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import javafx.collections.ObservableList;
import javafx.scene.Node;
import javafx.scene.control.TreeItem;
import javafx.scene.control.TreeView;
import javafx.scene.input.ClipboardContent;
import javafx.scene.input.DragEvent;
import javafx.scene.input.Dragboard;
import javafx.scene.input.MouseEvent;
import javafx.scene.input.TransferMode;
import javax.inject.Inject;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.workbench.modeling.EModelService;
import org.eclipse.e4.ui.workbench.modeling.EPartService;

public class CreateTablesNaviHandler
extends LazyNavigationContribution<UIModelElement>
implements IDnDNavigationContribution<UIModelElement> {
    public TreeView<UIModelElement> view;
    private Dragboard db;
    private TreeItem<UIModelElement> dragTreeItem;
    TreeItem<UIModelElement> dragTreeItemParent;
    private int positionMarkerIndex = -1;
    @Inject
    private MApplication app;
    @Inject
    private EModelService modelService;
    @Inject
    private EPartService partService;
    private Function<TreeItem<UIModelElement>, List<TreeItem<UIModelElement>>> LIST_CREATOR = new Function<TreeItem<UIModelElement>, List<TreeItem<UIModelElement>>>(){

        @Override
        public List<TreeItem<UIModelElement>> apply(TreeItem<UIModelElement> item) {
            LinkedList<TreeItem<UIModelElement>> elements = new LinkedList<TreeItem<UIModelElement>>();
            Transaction trx = Transactions.begin();
            try {
                if (item.getValue() == null || item.getValue() instanceof INavigationTreeElement) {
                    HashMap classes = new HashMap();
                    Table[] tableArray = TableDAO.getAll((Transaction)trx);
                    int n = tableArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        List<Table> classTables;
                        Table table = tableArray[n2];
                        if (!classes.containsKey(table.getStructureClass())) {
                            classTables = new ArrayList();
                            classes.put(StructureClassDAO.get((Transaction)trx, (int)table.getStructureClass().getId()), classTables);
                        } else {
                            classTables = (List)classes.get(table.getStructureClass());
                        }
                        classTables.add(table);
                        ++n2;
                    }
                    for (Map.Entry entry : classes.entrySet()) {
                        elements.add((TreeItem<UIModelElement>)new LazyTreeItem((Object)((UIModelElement)entry.getKey()), (Object[])((UIModelElement[])((List)entry.getValue()).toArray(Table[]::new)), CreateTablesNaviHandler.this.LIST_CREATOR));
                    }
                } else if (item.getValue() instanceof StructureClass) {
                    StructureClass clazz = (StructureClass)item.getValue();
                    elements.addAll(CreateTablesNaviHandler.this.createLazyTreeItemCollection((UIModelElement[])TableDAO.getByClass((Transaction)trx, (StructureClass)clazz)));
                } else if (item.getValue() instanceof Table) {
                    Table table = (Table)item.getValue();
                    elements.addAll(CreateTablesNaviHandler.this.createLazyTreeItemCollection((UIModelElement[])TableDAO.getRootColumnGroups((Transaction)trx, (Table)table)));
                    elements.addAll(CreateTablesNaviHandler.this.createTreeItemCollection((UIModelElement[])TableDAO.getRootColumns((Transaction)trx, (Table)table)));
                } else if (item.getValue() instanceof ColumnGroup) {
                    ColumnGroup columnGroup = (ColumnGroup)item.getValue();
                    elements.addAll(CreateTablesNaviHandler.this.createLazyTreeItemCollection((UIModelElement[])ColumnGroupDAO.getChildColumnGroups((Transaction)trx, (ColumnGroup)columnGroup)));
                    elements.addAll(CreateTablesNaviHandler.this.createTreeItemCollection((UIModelElement[])ColumnGroupDAO.getColumns((Transaction)trx, (ColumnGroup)columnGroup)));
                }
                FXUtils.sortTreeItems(elements);
            }
            finally {
                Transactions.close((Transaction)trx);
            }
            return elements;
        }
    };

    @Override
    public Function<TreeItem<UIModelElement>, List<TreeItem<UIModelElement>>> getChildrenCreator() {
        return this.LIST_CREATOR;
    }

    @Execute
    public void execute() {
    }

    @Override
    public String getContextMenuId() {
        return "de.elpro.ewms.engin.gui.menu.navi.tables";
    }

    @Override
    public void onTreeItemClick(Object sender, TreeItem<UIModelElement> treeItem) {
        new TablesEditHandler().execute(this.app, treeItem);
    }

    @Override
    public void onTreeItemDoubleClick(Object sender, TreeItem<UIModelElement> treeItem) {
        EOSPartUtils.pinSelectedMPart((EModelService)this.modelService, (MApplication)this.app, (String)"de.elpro.ewms.engin.gui.partstack.editors");
    }

    @Override
    public void onDragDetected(MouseEvent event) {
        if (event.getSource() instanceof TreeView) {
            TreeView source = (TreeView)event.getSource();
            ObservableList treeItems = source.getSelectionModel().getSelectedItems();
            this.dragTreeItem = (TreeItem)treeItems.get(0);
            if (this.dragTreeItem.getValue() instanceof Column) {
                this.db = source.startDragAndDrop(TransferMode.ANY);
                this.dragTreeItemParent = this.dragTreeItem.getParent();
                ClipboardContent content = new ClipboardContent();
                content.putString("");
                this.db.setContent((Map)content);
            }
            event.consume();
        }
    }

    @Override
    public TransferMode[] onDragOver(UIModelElement target, DragEvent event) {
        TreeItem targetTreeItem = null;
        TreeView treeView = (TreeView)event.getSource();
        if (treeView != null) {
            treeView.getFocusModel().focus(-1);
        }
        if (target instanceof Column) {
            UIModelElement pm = new UIModelElement(){

                public Node getGraphic() {
                    InsertPositionLine marker = new InsertPositionLine();
                    return marker;
                }

                public String toString() {
                    return "";
                }
            };
            TreeItem posMarker = new TreeItem((Object)pm);
            if (this.positionMarkerIndex > -1) {
                this.dragTreeItemParent.getChildren().remove(this.positionMarkerIndex);
                this.positionMarkerIndex = -1;
            }
            for (TreeItem ti : this.dragTreeItemParent.getChildren()) {
                if (!((UIModelElement)ti.getValue()).equals(target)) continue;
                targetTreeItem = ti;
                this.positionMarkerIndex = this.dragTreeItemParent.getChildren().indexOf((Object)ti);
                this.dragTreeItemParent.getChildren().add(this.positionMarkerIndex, (Object)posMarker);
                break;
            }
            event.consume();
            if (targetTreeItem != null && targetTreeItem.getParent() == this.dragTreeItemParent) {
                return new TransferMode[]{TransferMode.MOVE};
            }
            return TransferMode.NONE;
        }
        if (target.getGraphic() instanceof InsertPositionLine) {
            event.consume();
            return new TransferMode[]{TransferMode.MOVE};
        }
        event.consume();
        return TransferMode.NONE;
    }

    @Override
    public void onDragDropped(UIModelElement target, DragEvent event) {
        block7: {
            TreeItem parent = this.dragTreeItem.getParent();
            if (this.positionMarkerIndex >= 0 && this.positionMarkerIndex < parent.getChildren().size()) {
                parent.getChildren().set(this.positionMarkerIndex, (Object)new TreeItem((Object)((UIModelElement)this.dragTreeItem.getValue())));
                this.positionMarkerIndex = -1;
                parent.getChildren().remove(this.dragTreeItem);
            }
            Transaction trx = Transactions.begin();
            try {
                try {
                    int i = 0;
                    while (i < parent.getChildren().size()) {
                        Column column = (Column)((TreeItem)parent.getChildren().get(i)).getValue();
                        column = ColumnDAO.get((Transaction)trx, (int)column.getId());
                        column.setVisualOrderPosition(Integer.valueOf((i + 1) * 10));
                        ColumnDAO.saveOrUpdate((Transaction)trx, (Column)column);
                        ++i;
                    }
                    Transactions.commitSync((Transaction)trx);
                    PartUtils.refreshPart((EPartService)this.partService, (String)"de.elpro.ewms.engin.gui.bottom.preview");
                }
                catch (Exception e) {
                    e.printStackTrace();
                    Transactions.rollback((Transaction)trx);
                    Transactions.close((Transaction)trx);
                    break block7;
                }
            }
            catch (Throwable throwable) {
                Transactions.close((Transaction)trx);
                throw throwable;
            }
            Transactions.close((Transaction)trx);
        }
        event.consume();
    }

    private Table searchTable(TreeItem<UIModelElement> element) {
        if (element.getParent().getValue() instanceof Table) {
            return (Table)element.getParent().getValue();
        }
        return this.searchTable((TreeItem<UIModelElement>)element.getParent());
    }
}

