/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.engin.gui.navi.client.tables.parts;

import de.elpro.ewms.core.client.Transactions;
import de.elpro.ewms.core.client.tables.ColumnDAO;
import de.elpro.ewms.core.client.tables.ColumnGroupDAO;
import de.elpro.ewms.core.client.tables.TableDAO;
import de.elpro.ewms.core.client.variable.VariableDAO;
import de.elpro.ewms.core.client.variable.VariableInstanceDAO;
import de.elpro.ewms.core.client.variable.VariableRoleDAO;
import de.elpro.ewms.core.db.DAOOperationException;
import de.elpro.ewms.core.db.Transaction;
import de.elpro.ewms.core.lang.ScriptParser;
import de.elpro.ewms.core.tables.Column;
import de.elpro.ewms.core.tables.ColumnGroup;
import de.elpro.ewms.core.tables.ColumnStyleScope;
import de.elpro.ewms.core.tables.ColumnType;
import de.elpro.ewms.core.tables.ColumnValueRenderingType;
import de.elpro.ewms.core.tables.TableStyle;
import de.elpro.ewms.core.time.Raster;
import de.elpro.ewms.core.units.Aggregation;
import de.elpro.ewms.core.units.MeasuringUnit;
import de.elpro.ewms.core.units.MeasuringUnitFormats;
import de.elpro.ewms.core.units.PhysicalUnit;
import de.elpro.ewms.core.units.PhysicalUnitRegistry;
import de.elpro.ewms.core.units.PhysicalUnits;
import de.elpro.ewms.core.variable.IVariableRole;
import de.elpro.ewms.core.variable.Variable;
import de.elpro.ewms.core.variable.VariableInstance;
import de.elpro.ewms.engin.gui.services.EnginPartUtils;
import de.elpro.ui.controlsfx.propertysheet.SeparatorItem;
import de.elpro.ui.formats.TimeFormatType;
import de.elpro.ui.fx.propertysheet.BooleanPropertyItem;
import de.elpro.ui.fx.propertysheet.ChoicePropertyItem;
import de.elpro.ui.fx.propertysheet.EnumPropertyItem;
import de.elpro.ui.fx.propertysheet.IntegerPropertyItem;
import de.elpro.ui.fx.propertysheet.LocaleStringPropertyItem;
import de.elpro.ui.fx.propertysheet.NumberPropertyItem;
import de.elpro.ui.fx.propertysheet.PropertyItemsHelper;
import de.elpro.ui.fx.propertysheet.StringOptionPropertyItem;
import de.elpro.ui.fx.propertysheet.StringPropertyItem;
import de.elpro.ui.fx.validator.Validators;
import de.elpro.ui.utils.TextUtils;
import de.elpro.ui.utils.e4.PartUtils;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.stream.Collectors;
import javafx.beans.property.ReadOnlyProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableValue;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.layout.BorderPane;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import jidefx.scene.control.validation.Validator;
import org.controlsfx.control.PropertySheet;
import org.controlsfx.dialog.ExceptionDialog;
import org.eclipse.e4.ui.di.Focus;
import org.eclipse.e4.ui.di.Persist;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.workbench.modeling.EPartService;

public class ColumnEditPart {
    public static final String ID = "de.elpro.ewms.engin.gui.partdescriptor.tables.column";
    @Inject
    private Column column;
    @Inject
    private MPart part;
    @Inject
    private EPartService partService;
    private final PropertySheet sheet = new PropertySheet();
    private final SimpleBooleanProperty hasChanges = new SimpleBooleanProperty(false);
    private final SimpleBooleanProperty hasErrors = new SimpleBooleanProperty(false);
    private NumberPropertyItem<Integer> idItem;
    private ChoicePropertyItem<PhysicalUnit> varPhysicalUnitItem;
    private SimpleObjectProperty<IVariableRole> roleProperty;
    private final Map<String, IVariableRole> variableRoles = new HashMap<String, IVariableRole>();

    @PostConstruct
    public void postConstruct(BorderPane parent) {
        Transaction trx = Transactions.begin();
        LinkedList<ColumnGroup> availableColumnGroups = new LinkedList<ColumnGroup>();
        try {
            if (this.column.getId() != null) {
                this.column = ColumnDAO.get((Transaction)trx, (int)this.column.getId());
            }
            this.column.setTable(TableDAO.get((Transaction)trx, (int)this.column.getTable().getId()));
            if (this.column.getColumnGroup() != null) {
                this.column.setColumnGroup(ColumnGroupDAO.get((Transaction)trx, (int)this.column.getColumnGroup().getId()));
            }
            if (this.column.getVariable() != null) {
                this.column.setVariable(VariableDAO.get((Transaction)trx, (int)this.column.getVariable().getId()));
            }
            for (ColumnGroup cg : this.column.getTable().getColumnGroups()) {
                availableColumnGroups.add(ColumnGroupDAO.get((Transaction)trx, (int)cg.getId()));
            }
            Arrays.stream(VariableRoleDAO.getAll((Transaction)trx)).forEach(vr -> {
                IVariableRole iVariableRole = this.variableRoles.put(vr.getId(), (IVariableRole)vr);
            });
        }
        finally {
            Transactions.close((Transaction)trx);
        }
        this.idItem = new IntegerPropertyItem("Id", (ObservableValue)this.column.idProperty());
        this.idItem.setReadOnly(true);
        ChoicePropertyItem tableItem = new ChoicePropertyItem("Table", (ObservableValue)this.column.tableProperty());
        tableItem.setReadOnly(true);
        ChoicePropertyItem columnGroupItem = new ChoicePropertyItem("Group", (ObservableValue)this.column.columnGroupProperty(), availableColumnGroups);
        BooleanPropertyItem visibleItem = new BooleanPropertyItem("Visible", (ReadOnlyProperty)this.column.visibleProperty());
        LocaleStringPropertyItem nameItem = new LocaleStringPropertyItem("Name", (ObservableValue)this.column.nameProperty());
        nameItem.setValidator(Validators.createNotEmptyValidator((String)"Name cannot be empty"));
        StringPropertyItem keyItem = new StringPropertyItem("Key", (ObservableValue)this.column.keyProperty());
        EnumPropertyItem typeItem = new EnumPropertyItem("Column Type", ColumnType.class, (ObservableValue)this.column.typeProperty());
        typeItem.setNullable(false);
        EnumPropertyItem renderingType = new EnumPropertyItem("Value Renderer", ColumnValueRenderingType.class, (ObservableValue)this.column.renderingTypeProperty());
        renderingType.setNullable(false);
        StringPropertyItem rendererProperties = new StringPropertyItem("Renderer Properties", (ObservableValue)this.column.rendererPropertiesProperty());
        rendererProperties.setPromptText("{valuesMap: [{val: 1, text: \"H-Gas\"}, {val: 2, text: \"L-Gas\"}], defalutText: \"?\"}");
        rendererProperties.setHidden(this.column.getRenderingType() == ColumnValueRenderingType.Auto);
        renderingType.valueProperty().addListener(il -> rendererProperties.setHidden(this.column.getRenderingType() == ColumnValueRenderingType.Auto));
        this.varPhysicalUnitItem = new ChoicePropertyItem("Physical Unit", (ObservableValue)new SimpleObjectProperty(this.column.getVariable() != null ? this.column.getVariable().getPhysicalUnit() : null), PhysicalUnitRegistry.getPhysicalUnits());
        ChoicePropertyItem variableItem = new ChoicePropertyItem("Variable", (ObservableValue)this.column.variableProperty(), this.getAvailableVariables(this.column.getVariable() != null ? this.column.getVariable().getPhysicalUnit() : null));
        variableItem.setTextCallback(var -> {
            if (var.getDescription() == null || var.getDescription().isEmpty()) {
                return var.toString();
            }
            return String.format("%s (%s)", var, TextUtils.getFirstLine((String)var.getDescription(), (int)150));
        });
        variableItem.setValidator(Validators.createValidator((o, ov, nv) -> {
            if (this.column.getType() != ColumnType.Variable && this.column.getType() != ColumnType.AssignedText) {
                return true;
            }
            return nv != null;
        }, (String)"Variable must be not empty"));
        ChoicePropertyItem variableInstanceItem = new ChoicePropertyItem("Fixed Instance", (ObservableValue)this.column.variableInstanceProperty(), this.getAvailableVariableInstances());
        this.roleProperty = new SimpleObjectProperty((Object)this.variableRoles.get(this.column.getVariableRoleId()));
        ChoicePropertyItem roleItem = new ChoicePropertyItem("Role", this.roleProperty, this.getFilteredRoles());
        this.roleProperty.addListener((o, ov, nv) -> this.column.setVariableRoleId(nv != null ? nv.getId() : null));
        roleItem.setNullable(false);
        roleItem.setValidator(Validators.createValidator((o, ov, nv) -> {
            if (this.column.getType() != ColumnType.VariableRole) {
                return true;
            }
            return nv != null;
        }, (String)"Variable Role must be not empty"));
        this.varPhysicalUnitItem.valueProperty().addListener(il -> roleItem.setChoices(this.getFilteredRoles()));
        StringPropertyItem calculationFormulaItem = new StringPropertyItem("Formula", (ObservableValue)this.column.calculationFormula());
        calculationFormulaItem.setValidator(Validators.combine((Validator[])new Validator[]{Validators.createValidator((o, ov, nv) -> this.column.getType() != ColumnType.Calculated || nv != null && !nv.toString().isEmpty(), (String)"Calculation Formula must be not empty"), Validators.createValidator((o, ov, nv) -> this.column.getType() != ColumnType.Calculated || ScriptParser.parseFormula((String)nv.toString()) != null, (String)"Calculation Formula contain errors")}));
        ChoicePropertyItem calculationPhysicalUnitItem = new ChoicePropertyItem("Calculation Result Physical Unit", (ObservableValue)this.column.calculationPhysicalUnitProperty(), PhysicalUnitRegistry.getPhysicalUnits());
        calculationPhysicalUnitItem.setValidator(Validators.createValidator((o, ov, nv) -> this.column.getType() != ColumnType.Calculated || nv != null, (String)"Physical Unit of Calculation Result must be specified!"));
        ChoicePropertyItem calculationMeasuringUnitItem = new ChoicePropertyItem("Calculation Result Measuring Unit", (ObservableValue)this.column.calculationMeasuringUnitProperty(), this.getAvailableMeasuringUnits());
        calculationMeasuringUnitItem.setValidator(Validators.createValidator((o, ov, nv) -> this.column.getType() != ColumnType.Calculated || nv != null, (String)"Measuring Unit of Calculation Result must be specified!"));
        ChoicePropertyItem measuringUnitItem = new ChoicePropertyItem("Measuring Unit", (ObservableValue)this.column.measuringUnitProperty(), this.getAvailableMeasuringUnits());
        ChoicePropertyItem measuringUnitFormatItem = new ChoicePropertyItem("Format", (ObservableValue)this.column.measuringUnitFormatProperty(), MeasuringUnitFormats.getFormats());
        EnumPropertyItem customAggregationItem = new EnumPropertyItem("Custom Aggregation", Aggregation.class, (ObservableValue)this.column.customAggregationProperty());
        EnumPropertyItem raster2Item = new EnumPropertyItem("Raster2", Raster.class, (ObservableValue)this.column.raster2Property());
        EnumPropertyItem customAggregationFromRaster2Item = new EnumPropertyItem("Custom Aggregation from Raster2", Aggregation.class, (ObservableValue)this.column.customAggregationFromRaster2Property());
        raster2Item.setValidator(Validators.createValidator((o, ov, nv) -> this.column.getCustomAggregationFromRaster2() == null || this.column.getRaster2() != null, (String)"Set raster2"));
        customAggregationFromRaster2Item.setValidator(Validators.createValidator((o, ov, nv) -> this.column.getRaster2() == null || this.column.getCustomAggregationFromRaster2() != null, (String)"Set custom aggregation from raster2"));
        raster2Item.valueProperty().addListener(il -> customAggregationFromRaster2Item.forceValidate());
        customAggregationFromRaster2Item.valueProperty().addListener(il -> raster2Item.forceValidate());
        TableStyle tableStyle = this.column.getTable().getTableStyle();
        StringOptionPropertyItem columnHeaderStyleClassItem = new StringOptionPropertyItem("Header cell style", (ObservableValue)this.column.columnStyleClassProperty(), tableStyle != null ? tableStyle.getStyleClassNames(new ColumnStyleScope[]{ColumnStyleScope.ColumnHeader}) : null);
        columnHeaderStyleClassItem.setPromptText("Example: column-header-cell-style1");
        StringOptionPropertyItem cellStyleClassExprItem = new StringOptionPropertyItem("Row cell style expr.", (ObservableValue)this.column.cellStyleClassExpressionProperty(), tableStyle != null ? (Collection)tableStyle.getStyleClassNames(new ColumnStyleScope[]{ColumnStyleScope.ColumnCell, ColumnStyleScope.ColumnSummaryCell}).stream().map(s -> String.format("\"%s\"", s)).collect(Collectors.toList()) : null);
        cellStyleClassExprItem.setPromptText("Expr. example: if (column_key > 0) { \"column-row-cell-style1\" else \"column-row-cell-style2\" }");
        EnumPropertyItem timeFormatTypeItem = new EnumPropertyItem("Time Format", TimeFormatType.class, (ObservableValue)this.column.timeColumnFormatProperty());
        timeFormatTypeItem.setPromptText("Auto-Format");
        IntegerPropertyItem supplementSelectorItem = new IntegerPropertyItem("Supplement Selector", (ObservableValue)this.column.supplementValuesSelectorProperty());
        this.varPhysicalUnitItem.valueProperty().addListener((o, ov, nv) -> variableItem.setChoices(this.getAvailableVariables((PhysicalUnit)nv)));
        BooleanPropertyItem hideNameItem = new BooleanPropertyItem("Hide Name", (ReadOnlyProperty)this.column.hideNameProperty());
        BooleanPropertyItem hideMUItem = new BooleanPropertyItem("Hide Measuring Unit", (ReadOnlyProperty)this.column.hideMUProperty());
        BooleanPropertyItem showAggrValueItem = new BooleanPropertyItem("Show Aggr. Value", (ReadOnlyProperty)this.column.showAggrValueProperty());
        EnumPropertyItem customAggrRowAggregationItem = new EnumPropertyItem("Custom Aggr.Row Aggregation", Aggregation.class, (ObservableValue)this.column.customAggrRowAggregationProperty());
        BooleanPropertyItem editableValuesItem = new BooleanPropertyItem("Editable Values", (ReadOnlyProperty)this.column.editableProperty());
        IntegerPropertyItem prefWidthItem = new IntegerPropertyItem("Prefered Width", (ObservableValue)this.column.prefWidthProperty());
        IntegerPropertyItem visualOrderPositionItem = new IntegerPropertyItem("Visual Order Position", (ObservableValue)this.column.visualOrderPositionProperty());
        Runnable showHideItems = () -> {
            ColumnType type = this.column.getType();
            boolean varPropsHidden = type != ColumnType.Variable && this.column.getType() != ColumnType.VariableRole && this.column.getType() != ColumnType.AssignedText;
            this.varPhysicalUnitItem.setHidden(varPropsHidden && type != ColumnType.Calculated);
            variableItem.setHidden(varPropsHidden && type != ColumnType.Calculated || type == ColumnType.VariableRole);
            variableInstanceItem.setHidden(varPropsHidden && type != ColumnType.Calculated || type == ColumnType.VariableRole);
            roleItem.setHidden(type != ColumnType.VariableRole);
            supplementSelectorItem.setHidden(varPropsHidden);
            showAggrValueItem.setHidden(varPropsHidden && type != ColumnType.Calculated);
            editableValuesItem.setHidden(varPropsHidden);
            variableItem.forceValidate();
            calculationFormulaItem.setHidden(type != ColumnType.Calculated);
            calculationPhysicalUnitItem.setHidden(type != ColumnType.Calculated);
            calculationMeasuringUnitItem.setHidden(type != ColumnType.Calculated);
            measuringUnitItem.setHidden(type != ColumnType.Variable && type != ColumnType.VariableRole && type != ColumnType.TimeInterval && type != ColumnType.Calculated);
            timeFormatTypeItem.setHidden(this.column.getType() != ColumnType.TimeBegin && this.column.getType() != ColumnType.TimeEnd);
            customAggregationItem.setHidden(ColumnEditPart.isCustomAggregationHidden(this.column));
            raster2Item.setHidden(ColumnEditPart.isCustomAggregationHidden(this.column));
            customAggregationFromRaster2Item.setHidden(ColumnEditPart.isCustomAggregationHidden(this.column));
            customAggrRowAggregationItem.setHidden(ColumnEditPart.isCustomAggrRowAggregationHidden(this.column));
        };
        showHideItems.run();
        typeItem.valueProperty().addListener(il -> {
            showHideItems.run();
            measuringUnitItem.setChoices(this.getAvailableMeasuringUnits());
            variableItem.forceValidate();
            roleItem.forceValidate();
            calculationFormulaItem.forceValidate();
            calculationPhysicalUnitItem.forceValidate();
            calculationMeasuringUnitItem.forceValidate();
        });
        variableItem.valueProperty().addListener(il -> {
            measuringUnitItem.setChoices(this.getAvailableMeasuringUnits());
            variableInstanceItem.setChoices(this.getAvailableVariableInstances());
            variableItem.forceValidate();
        });
        roleItem.valueProperty().addListener(il -> {
            measuringUnitItem.setChoices(this.getAvailableMeasuringUnits());
            roleItem.forceValidate();
        });
        calculationPhysicalUnitItem.valueProperty().addListener(il -> calculationMeasuringUnitItem.setChoices(this.getAvailableMeasuringUnits()));
        calculationMeasuringUnitItem.valueProperty().addListener(il -> measuringUnitItem.setChoices(this.getAvailableMeasuringUnits()));
        showAggrValueItem.valueProperty().addListener(il -> customAggrRowAggregationItem.setHidden(ColumnEditPart.isCustomAggrRowAggregationHidden(this.column)));
        this.sheet.getItems().addAll((Object[])new PropertySheet.Item[]{this.idItem, tableItem, columnGroupItem, visibleItem, nameItem, keyItem, new SeparatorItem(), typeItem, renderingType, rendererProperties, this.varPhysicalUnitItem, variableItem, variableInstanceItem, roleItem, calculationFormulaItem, calculationPhysicalUnitItem, calculationMeasuringUnitItem, measuringUnitItem, measuringUnitFormatItem, new SeparatorItem(), customAggregationItem, raster2Item, customAggregationFromRaster2Item, new SeparatorItem(), columnHeaderStyleClassItem, cellStyleClassExprItem, new SeparatorItem(), timeFormatTypeItem, supplementSelectorItem, hideNameItem, hideMUItem, showAggrValueItem, customAggrRowAggregationItem, editableValuesItem, prefWidthItem, visualOrderPositionItem});
        this.hasChanges.bind((ObservableValue)PropertyItemsHelper.createHasChangesProperty((Collection)this.sheet.getItems()));
        this.hasErrors.bind((ObservableValue)PropertyItemsHelper.createHasErrorsProperty((Collection)this.sheet.getItems()));
        parent.setCenter((Node)this.sheet);
        this.hasChanges.addListener((o, ov, nv) -> this.part.setDirty(nv != false || this.column.getId() == null));
        this.focus();
    }

    private static boolean isCustomAggregationHidden(Column column) {
        return column.getType() != ColumnType.Variable && column.getType() != ColumnType.VariableRole;
    }

    private static boolean isCustomAggrRowAggregationHidden(Column column) {
        return !column.getShowAggrValue() || column.getType() != ColumnType.Variable && column.getType() != ColumnType.VariableRole && column.getType() != ColumnType.Calculated;
    }

    private Collection<MeasuringUnit> getAvailableMeasuringUnits() {
        LinkedList<MeasuringUnit> aMUs = new LinkedList<MeasuringUnit>();
        if (this.column.getType() == ColumnType.Variable) {
            if (this.column.getVariable() != null) {
                aMUs.addAll(this.column.getVariable().getPhysicalUnit().getMeasuringUnits());
            }
        } else if (this.column.getType() == ColumnType.VariableRole) {
            if (this.roleProperty.getValue() != null) {
                aMUs.addAll(((IVariableRole)this.roleProperty.getValue()).getPhysicalUnit().getMeasuringUnits());
            }
        } else if (this.column.getType() == ColumnType.Calculated) {
            if (this.column.calculationPhysicalUnitProperty().get() != null) {
                aMUs.addAll(((PhysicalUnit)this.column.calculationPhysicalUnitProperty().get()).getMeasuringUnits());
            }
        } else {
            aMUs.addAll(PhysicalUnits.TIME.getMeasuringUnits());
        }
        return aMUs;
    }

    private Collection<Variable> getAvailableVariables(PhysicalUnit filterUnit) {
        LinkedList<Variable> vars = new LinkedList<Variable>();
        Transaction trx = Transactions.begin();
        try {
            if (filterUnit == null) {
                Variable[] variableArray = VariableDAO.getAll((Transaction)trx);
                int n = variableArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Variable var = variableArray[n2];
                    vars.add(var);
                    ++n2;
                }
            } else {
                Variable[] variableArray = VariableDAO.getAll((Transaction)trx, (PhysicalUnit)filterUnit);
                int n = variableArray.length;
                int n3 = 0;
                while (n3 < n) {
                    Variable var = variableArray[n3];
                    vars.add(var);
                    ++n3;
                }
            }
            LinkedList<Variable> linkedList = vars;
            return linkedList;
        }
        finally {
            Transactions.close((Transaction)trx);
        }
    }

    private Collection<VariableInstance> getAvailableVariableInstances() {
        LinkedList<VariableInstance> instances = new LinkedList<VariableInstance>();
        if (this.column.getVariable() != null) {
            Transaction trx = Transactions.begin();
            try {
                VariableInstance[] variableInstanceArray = VariableInstanceDAO.getAll((Transaction)trx, (Variable)this.column.getVariable(), (boolean)true);
                int n = variableInstanceArray.length;
                int n2 = 0;
                while (n2 < n) {
                    VariableInstance instance = variableInstanceArray[n2];
                    instances.add(instance);
                    ++n2;
                }
            }
            finally {
                Transactions.close((Transaction)trx);
            }
        }
        return instances;
    }

    private Collection<IVariableRole> getFilteredRoles() {
        LinkedList<IVariableRole> visibleRoles = new LinkedList<IVariableRole>();
        for (IVariableRole candidate : this.variableRoles.values()) {
            if (this.varPhysicalUnitItem.getValue() != null && !candidate.getPhysicalUnit().equals(this.varPhysicalUnitItem.getValue())) continue;
            visibleRoles.add(candidate);
        }
        return visibleRoles;
    }

    @Persist
    public void save() {
        if (!this.hasChanges.get() && this.idItem.getValue() != null) {
            return;
        }
        if (this.hasErrors.get()) {
            Alert alert = new Alert(Alert.AlertType.WARNING);
            alert.setContentText(String.format("Cannot save %s. Fix errors first.", this.column.toString()));
            alert.showAndWait();
            return;
        }
        Transaction trx = Transactions.begin();
        try {
            try {
                this.idItem.setValue((Object)ColumnDAO.saveOrUpdate((Transaction)trx, (Column)this.column));
                Transactions.commitSync((Transaction)trx);
                PropertyItemsHelper.resetHasChangesProperties((Collection)this.sheet.getItems());
                this.part.setDirty(false);
                this.part.setLabel(this.column.toString());
                EnginPartUtils.refreshItems(this.column, this.part);
            }
            catch (DAOOperationException exc) {
                Transactions.rollback((Transaction)trx);
                ExceptionDialog dlg = new ExceptionDialog((Throwable)exc);
                dlg.setContentText("Error saving table column");
                dlg.show();
                Transactions.close((Transaction)trx);
                return;
            }
        }
        finally {
            Transactions.close((Transaction)trx);
        }
        PartUtils.refreshParts((EPartService)this.partService, Column.class);
    }

    @PreDestroy
    protected void close() {
        this.part.setDirty(false);
    }

    @Focus
    public void focus() {
        MPart part = this.partService.findPart("de.elpro.ewms.engin.gui.bottom.preview");
        if (!part.getParent().equals(this.part.getParent())) {
            this.partService.showPart(part, EPartService.PartState.VISIBLE);
        }
        part.getContext().set("preview-object", (Object)this.column.getTable());
    }
}

