/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.engin.gui.navi.client.tables.parts;

import de.elpro.ewms.core.client.Transactions;
import de.elpro.ewms.core.client.structure.StructureClassDAO;
import de.elpro.ewms.core.client.tables.ColumnGroupDAO;
import de.elpro.ewms.core.client.tables.TableDAO;
import de.elpro.ewms.core.db.DAOOperationException;
import de.elpro.ewms.core.db.Transaction;
import de.elpro.ewms.core.structure.SearchPolicy;
import de.elpro.ewms.core.structure.StructureClass;
import de.elpro.ewms.core.tables.ColumnGroup;
import de.elpro.ewms.core.tables.ColumnStyleScope;
import de.elpro.ewms.core.tables.TableStyle;
import de.elpro.ewms.engin.gui.services.EnginPartUtils;
import de.elpro.ui.controlsfx.propertysheet.SeparatorItem;
import de.elpro.ui.fx.propertysheet.ChoicePropertyItem;
import de.elpro.ui.fx.propertysheet.EnumPropertyItem;
import de.elpro.ui.fx.propertysheet.IntegerPropertyItem;
import de.elpro.ui.fx.propertysheet.LocaleStringPropertyItem;
import de.elpro.ui.fx.propertysheet.NumberPropertyItem;
import de.elpro.ui.fx.propertysheet.PropertyItemsHelper;
import de.elpro.ui.fx.propertysheet.StringOptionPropertyItem;
import de.elpro.ui.utils.e4.PartUtils;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.value.ObservableValue;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.layout.BorderPane;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import org.controlsfx.control.PropertySheet;
import org.controlsfx.dialog.ExceptionDialog;
import org.eclipse.e4.ui.di.Focus;
import org.eclipse.e4.ui.di.Persist;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.workbench.modeling.EPartService;

public class ColumnGroupEditPart {
    public static final String ID = "de.elpro.ewms.engin.gui.partdescriptor.tables.columngroup";
    @Inject
    private ColumnGroup columnGroup;
    @Inject
    private MPart part;
    @Inject
    private EPartService partService;
    private final PropertySheet sheet = new PropertySheet();
    private final SimpleBooleanProperty hasChanges = new SimpleBooleanProperty(false);
    private final SimpleBooleanProperty hasErrors = new SimpleBooleanProperty(false);
    private NumberPropertyItem<Integer> idItem;

    @PostConstruct
    public void postConstruct(BorderPane parent) {
        Transaction trx = Transactions.begin();
        LinkedList<StructureClass> classes = new LinkedList<StructureClass>();
        try {
            if (this.columnGroup.getId() != null) {
                this.columnGroup = ColumnGroupDAO.get((Transaction)trx, (int)this.columnGroup.getId());
            }
            classes.addAll(Arrays.asList(StructureClassDAO.getAll((Transaction)trx)));
            this.columnGroup.setTable(TableDAO.get((Transaction)trx, (int)this.columnGroup.getTable().getId()));
            if (this.columnGroup.getParentGroup() != null) {
                this.columnGroup.setParentGroup(ColumnGroupDAO.get((Transaction)trx, (int)this.columnGroup.getParentGroup().getId()));
            }
        }
        finally {
            Transactions.close((Transaction)trx);
        }
        this.idItem = new IntegerPropertyItem("Id", (ObservableValue)this.columnGroup.idProperty());
        this.idItem.setReadOnly(true);
        ChoicePropertyItem tableItem = new ChoicePropertyItem("Table", (ObservableValue)this.columnGroup.tableProperty());
        tableItem.setReadOnly(true);
        ChoicePropertyItem parentGroupItem = new ChoicePropertyItem("Parent Group", (ObservableValue)this.columnGroup.parentGroupProperty());
        parentGroupItem.setReadOnly(true);
        ChoicePropertyItem objectClassItem = new ChoicePropertyItem("Object Class", (ObservableValue)this.columnGroup.objectClassProperty(), classes);
        EnumPropertyItem objectSearchPolicy = new EnumPropertyItem("Object Search Policy", SearchPolicy.class, (ObservableValue)this.columnGroup.objectSearchPolicyProperty());
        LocaleStringPropertyItem nameItem = new LocaleStringPropertyItem("Name", (ObservableValue)this.columnGroup.nameProperty());
        TableStyle tableStyle = this.columnGroup.getTable().getTableStyle();
        StringOptionPropertyItem columnHeaderStyleClassItem = new StringOptionPropertyItem("Header cell style", (ObservableValue)this.columnGroup.columnStyleClassProperty(), tableStyle != null ? tableStyle.getStyleClassNames(new ColumnStyleScope[]{ColumnStyleScope.ColumnHeader}) : null);
        columnHeaderStyleClassItem.setPromptText("Example: column-header-cell-style1");
        IntegerPropertyItem prefWidthItem = new IntegerPropertyItem("Prefered Width", (ObservableValue)this.columnGroup.prefWidthProperty());
        IntegerPropertyItem visualOrderPositionItem = new IntegerPropertyItem("Visual Order Position", (ObservableValue)this.columnGroup.visualOrderPositionProperty());
        objectSearchPolicy.setHidden(this.columnGroup.getObjectClass() == null);
        objectClassItem.valueProperty().addListener(o -> objectSearchPolicy.setHidden(this.columnGroup.getObjectClass() == null));
        this.sheet.getItems().addAll((Object[])new PropertySheet.Item[]{this.idItem, tableItem, parentGroupItem, objectClassItem, objectSearchPolicy, nameItem, new SeparatorItem(), columnHeaderStyleClassItem, new SeparatorItem(), prefWidthItem, visualOrderPositionItem});
        this.hasChanges.bind((ObservableValue)PropertyItemsHelper.createHasChangesProperty((Collection)this.sheet.getItems()));
        this.hasErrors.bind((ObservableValue)PropertyItemsHelper.createHasErrorsProperty((Collection)this.sheet.getItems()));
        parent.setCenter((Node)this.sheet);
        this.hasChanges.addListener((o, ov, nv) -> this.part.setDirty(nv.booleanValue()));
        this.focus();
    }

    @Persist
    public void save() {
        if (!this.hasChanges.get()) {
            return;
        }
        if (this.hasErrors.get()) {
            Alert alert = new Alert(Alert.AlertType.WARNING);
            alert.setContentText(String.format("Cannot save %s. Fix errors first.", this.columnGroup.toString()));
            alert.showAndWait();
            return;
        }
        Transaction trx = Transactions.begin();
        try {
            try {
                this.idItem.setValue((Object)ColumnGroupDAO.saveOrUpdate((Transaction)trx, (ColumnGroup)this.columnGroup));
                Transactions.commitSync((Transaction)trx);
                PropertyItemsHelper.resetHasChangesProperties((Collection)this.sheet.getItems());
                this.part.setDirty(false);
                this.part.setLabel(this.columnGroup.toString());
                EnginPartUtils.refreshItems(this.columnGroup, this.part);
            }
            catch (DAOOperationException exc) {
                Transactions.rollback((Transaction)trx);
                ExceptionDialog dlg = new ExceptionDialog((Throwable)exc);
                dlg.setContentText("Error saving column group");
                dlg.show();
                Transactions.close((Transaction)trx);
                return;
            }
        }
        finally {
            Transactions.close((Transaction)trx);
        }
        PartUtils.refreshParts((EPartService)this.partService, ColumnGroup.class);
    }

    @PreDestroy
    protected void close() {
        this.part.setDirty(false);
    }

    @Focus
    public void focus() {
        MPart part = this.partService.findPart("de.elpro.ewms.engin.gui.bottom.preview");
        if (!part.getParent().equals(this.part.getParent())) {
            this.partService.showPart(part, EPartService.PartState.VISIBLE);
        }
        part.getContext().set("preview-object", (Object)this.columnGroup.getTable());
    }
}

