/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.engin.gui.navi.client.tables.parts;

import de.elpro.ewms.core.client.Transactions;
import de.elpro.ewms.core.client.structure.StructureClassDAO;
import de.elpro.ewms.core.client.tables.ColumnDAO;
import de.elpro.ewms.core.client.tables.TableDAO;
import de.elpro.ewms.core.client.variable.VariableDAO;
import de.elpro.ewms.core.db.DAOOperationException;
import de.elpro.ewms.core.db.Transaction;
import de.elpro.ewms.core.structure.SearchPolicy;
import de.elpro.ewms.core.structure.StructureClass;
import de.elpro.ewms.core.tables.Column;
import de.elpro.ewms.core.tables.ITableRole;
import de.elpro.ewms.core.tables.Table;
import de.elpro.ewms.core.tables.TableType;
import de.elpro.ewms.core.variable.Variable;
import de.elpro.ewms.core.virtualtime.VirtualRaster;
import de.elpro.ewms.engin.gui.navi.client.tables.parts.TableStylePropertyEditor;
import de.elpro.ewms.engin.gui.services.EnginPartUtils;
import de.elpro.ewms.gui.roles.Roles;
import de.elpro.ui.fx.propertysheet.ChoicePropertyItem;
import de.elpro.ui.fx.propertysheet.CustomEditorPropertyItem;
import de.elpro.ui.fx.propertysheet.DoublePropertyItem;
import de.elpro.ui.fx.propertysheet.EnumPropertyItem;
import de.elpro.ui.fx.propertysheet.IntegerPropertyItem;
import de.elpro.ui.fx.propertysheet.LocaleStringPropertyItem;
import de.elpro.ui.fx.propertysheet.NumberPropertyItem;
import de.elpro.ui.fx.propertysheet.PropertyItemsHelper;
import de.elpro.ui.fx.propertysheet.StringPropertyItem;
import de.elpro.ui.fx.validator.Validators;
import de.elpro.ui.utils.e4.PartUtils;
import java.util.Collection;
import java.util.LinkedList;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableValue;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.layout.BorderPane;
import javafx.util.Callback;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import org.controlsfx.control.PropertySheet;
import org.controlsfx.dialog.ExceptionDialog;
import org.controlsfx.property.editor.PropertyEditor;
import org.eclipse.e4.ui.di.Focus;
import org.eclipse.e4.ui.di.Persist;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.workbench.modeling.EPartService;

public class TableEditPart {
    public static final String ID = "de.elpro.ewms.engin.gui.partdescriptor.tables.table";
    private static final String STYLE_CATEGORXY = "Styles";
    @Inject
    private Table table;
    @Inject
    private MPart part;
    @Inject
    private EPartService partService;
    private final PropertySheet sheet = new PropertySheet();
    private final SimpleBooleanProperty hasChanges = new SimpleBooleanProperty(false);
    private final SimpleBooleanProperty hasErrors = new SimpleBooleanProperty(false);
    private NumberPropertyItem<Integer> idItem;

    @PostConstruct
    public void postConstruct(BorderPane parent) {
        Transaction trx = Transactions.begin();
        LinkedList<StructureClass> classes = new LinkedList<StructureClass>();
        LinkedList<Column> allColumns = new LinkedList<Column>();
        try {
            StructureClass[] structureClassArray = StructureClassDAO.getAll((Transaction)trx);
            int n = structureClassArray.length;
            int n2 = 0;
            while (n2 < n) {
                StructureClass structureClass = structureClassArray[n2];
                classes.add(structureClass);
                ++n2;
            }
            if (this.table.getId() != null) {
                this.table = TableDAO.get((Transaction)trx, (int)this.table.getId());
                for (Column column : this.table.getColumns()) {
                    allColumns.add(ColumnDAO.get((Transaction)trx, (int)column.getId()));
                }
            }
            if (this.table.getStructureClass() != null) {
                this.table.setStructureClass(StructureClassDAO.get((Transaction)trx, (int)this.table.getStructureClass().getId()));
            }
        }
        finally {
            Transactions.close((Transaction)trx);
        }
        this.idItem = new IntegerPropertyItem("Id", (ObservableValue)this.table.idProperty());
        this.idItem.setReadOnly(true);
        ChoicePropertyItem classItem = new ChoicePropertyItem("At Class", (ObservableValue)this.table.structureClassProperty(), classes);
        classItem.setValidator(Validators.createNotEmptyValidator((String)"Class cannot be empty"));
        EnumPropertyItem typeItem = new EnumPropertyItem("Type", TableType.class, (ObservableValue)this.table.typeProperty());
        typeItem.setNullable(false);
        EnumPropertyItem objectSearchPolicyItem = new EnumPropertyItem("Object Search Policy", SearchPolicy.class, (ObservableValue)this.table.objectSearchPolicyProperty());
        objectSearchPolicyItem.setNullable(false);
        SimpleObjectProperty tableRole = new SimpleObjectProperty((Object)Roles.getTableRole((String)this.table.getRoleKey()));
        ChoicePropertyItem tableRoleItem = new ChoicePropertyItem("Role", (ObservableValue)tableRole, Roles.getTableRoles());
        tableRoleItem.setTextCallback(tr -> tr.getName());
        ChoicePropertyItem phasingVariableItem = new ChoicePropertyItem("Phasing Variable", (ObservableValue)this.table.phasingVariableProperty(), this.getAvailablePhasingVariables());
        DoublePropertyItem phasingDeltaItem = new DoublePropertyItem("Phasing \u0394", (ObservableValue)this.table.phasingDeltaProperty());
        LocaleStringPropertyItem nameItem = new LocaleStringPropertyItem("Name", (ObservableValue)this.table.nameProperty());
        nameItem.setValidator(Validators.createNotEmptyValidator((String)"Name cannot be empty"));
        LocaleStringPropertyItem titleItem = new LocaleStringPropertyItem("Title", (ObservableValue)this.table.titleProperty());
        EnumPropertyItem defaultRaster = new EnumPropertyItem("Default Raster", VirtualRaster.class, (ObservableValue)this.table.defaultRasterProperty());
        IntegerPropertyItem visualOrderPositionItem = new IntegerPropertyItem("Visual Order Position", (ObservableValue)this.table.visualOrderPositionProperty());
        ChoicePropertyItem aggrLabelColumnItem = new ChoicePropertyItem("Aggr. label column", (ObservableValue)this.table.aggrLabelColumnProperty(), allColumns);
        CustomEditorPropertyItem styleItem = new CustomEditorPropertyItem(STYLE_CATEGORXY, "Table Styles", TableStylePropertyEditor.class, (ObservableValue)this.table.styleProperty());
        StringPropertyItem customFxStylesheetItem = new StringPropertyItem(STYLE_CATEGORXY, "CSS Style ext.", (ObservableValue)this.table.fxStylesheetProperty());
        customFxStylesheetItem.useAreaEditor(true);
        Callback defaultFactory = this.sheet.getPropertyEditorFactory();
        this.sheet.setPropertyEditorFactory(item -> {
            if (item == styleItem) {
                return new TableStylePropertyEditor((PropertySheet.Item)item, this.table);
            }
            return (PropertyEditor)defaultFactory.call(item);
        });
        typeItem.valueProperty().addListener(il -> {
            phasingVariableItem.setHidden(this.table.getType() != TableType.Time);
            phasingDeltaItem.setHidden(this.table.getType() != TableType.Time);
            phasingVariableItem.setChoices(this.getAvailablePhasingVariables());
        });
        tableRoleItem.valueProperty().addListener(il -> this.table.setRoleKey(tableRole.get() != null ? ((ITableRole)tableRole.get()).getId() : null));
        this.sheet.getItems().addAll((Object[])new PropertySheet.Item[]{this.idItem, classItem, typeItem, objectSearchPolicyItem, tableRoleItem, phasingVariableItem, phasingDeltaItem, nameItem, titleItem, defaultRaster, visualOrderPositionItem, aggrLabelColumnItem, styleItem, customFxStylesheetItem});
        this.sheet.setMode(PropertySheet.Mode.CATEGORY);
        this.hasChanges.bind((ObservableValue)PropertyItemsHelper.createHasChangesProperty((Collection)this.sheet.getItems()));
        this.hasErrors.bind((ObservableValue)PropertyItemsHelper.createHasErrorsProperty((Collection)this.sheet.getItems()));
        parent.setCenter((Node)this.sheet);
        this.hasChanges.addListener((o, ov, nv) -> this.part.setDirty(nv.booleanValue()));
        this.focus();
    }

    public Collection<Variable> getAvailablePhasingVariables() {
        LinkedList<Variable> variables = new LinkedList<Variable>();
        if (this.table.getType() != TableType.Time) {
            return variables;
        }
        Transaction trx = Transactions.begin();
        try {
            Variable[] variableArray = VariableDAO.getAll((Transaction)trx);
            int n = variableArray.length;
            int n2 = 0;
            while (n2 < n) {
                Variable var = variableArray[n2];
                variables.add(var);
                ++n2;
            }
            LinkedList<Variable> linkedList = variables;
            return linkedList;
        }
        finally {
            Transactions.close((Transaction)trx);
        }
    }

    @Persist
    public void save() {
        if (!this.hasChanges.get()) {
            return;
        }
        if (this.hasErrors.get()) {
            Alert alert = new Alert(Alert.AlertType.WARNING);
            alert.setContentText(String.format("Cannot save %s. Fix errors first.", this.table.toString()));
            alert.showAndWait();
            return;
        }
        Transaction trx = Transactions.begin();
        try {
            try {
                this.idItem.setValue((Object)TableDAO.saveOrUpdate((Transaction)trx, (Table)this.table));
                Transactions.commitSync((Transaction)trx);
                PropertyItemsHelper.resetHasChangesProperties((Collection)this.sheet.getItems());
                this.part.setDirty(false);
                this.part.setLabel(this.table.toString());
                EnginPartUtils.refreshItems(this.table, this.part);
            }
            catch (DAOOperationException exc) {
                Transactions.rollback((Transaction)trx);
                ExceptionDialog dlg = new ExceptionDialog((Throwable)exc);
                dlg.setContentText("Error saving table");
                dlg.show();
                Transactions.close((Transaction)trx);
                return;
            }
        }
        finally {
            Transactions.close((Transaction)trx);
        }
        PartUtils.refreshParts((EPartService)this.partService, Table.class);
    }

    @PreDestroy
    protected void close() {
        this.part.setDirty(false);
    }

    @Focus
    public void focus() {
        MPart part = this.partService.findPart("de.elpro.ewms.engin.gui.bottom.preview");
        if (!part.getParent().equals(this.part.getParent())) {
            this.partService.showPart(part, EPartService.PartState.VISIBLE);
        }
        part.getContext().set("preview-object", (Object)this.table);
    }
}

