/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.engin.gui.navi.client.tables.parts;

import de.elpro.ewms.core.fx.tables.VarTableView;
import de.elpro.ewms.core.structure.StructureObject;
import de.elpro.ewms.core.tables.Column;
import de.elpro.ewms.core.tables.ColumnStyle;
import de.elpro.ewms.core.tables.ColumnStyleScope;
import de.elpro.ewms.core.tables.ColumnType;
import de.elpro.ewms.core.tables.Table;
import de.elpro.ewms.core.tables.TableStyle;
import de.elpro.ewms.core.tables.TableType;
import de.elpro.ewms.core.time.GlobalViewDateTimeRangeFilter;
import de.elpro.ewms.core.time.ITimeRangeFilter;
import de.elpro.ewms.core.time.Raster;
import de.elpro.ewms.core.units.MeasuringUnit;
import de.elpro.ewms.core.units.pressure.Pressure;
import de.elpro.ewms.core.variable.value.ValueSource;
import de.elpro.ewms.core.variable.value.VarValue;
import de.elpro.ewms.core.virtualtime.VirtualRaster;
import de.elpro.ui.controlsfx.propertysheet.PropertyItem;
import de.elpro.ui.fx.cells.uimodel.UIModelListCell;
import de.elpro.ui.fx.propertysheet.BooleanPropertyItem;
import de.elpro.ui.fx.propertysheet.EnumPropertyItem;
import de.elpro.ui.fx.propertysheet.PaintPropertyItem;
import de.elpro.ui.fx.propertysheet.StringPropertyItem;
import de.elpro.ui.fx.propertysheet.editors.PropertyItemEditor;
import de.elpro.ui.fx.validator.Validators;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Set;
import java.util.TreeMap;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javafx.beans.InvalidationListener;
import javafx.beans.binding.Bindings;
import javafx.beans.property.ReadOnlyProperty;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ListView;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.VBox;
import jidefx.scene.control.validation.Validator;
import org.controlsfx.control.PropertySheet;
import org.kordamp.ikonli.Ikon;
import org.kordamp.ikonli.dashicons.Dashicons;
import org.kordamp.ikonli.javafx.FontIcon;

public class TableStylePropertyEditor
extends PropertyItemEditor<TableStyle> {
    private int styleIndex = 1;
    private final ObservableList<ColumnStyle> columnStyles = FXCollections.observableArrayList();
    private final Node editor;
    private final Table table;

    public TableStylePropertyEditor(PropertySheet.Item item, Table table) {
        super(item);
        this.table = table;
        if (this.getValue() != null) {
            this.columnStyles.addAll(((TableStyle)this.getValue()).getColumnStyles());
        }
        this.editor = this.createEditor();
    }

    public Node getEditor() {
        return this.editor;
    }

    public Node createEditor() {
        ListView styles = new ListView(this.columnStyles);
        styles.setCellFactory(cf -> new UIModelListCell());
        Button addBtn = new Button("Add style");
        addBtn.setPrefWidth(200.0);
        addBtn.setOnAction(e -> {
            String newStyleName = String.format("column-style-%d", this.styleIndex++);
            Set names = this.columnStyles.stream().map(cs -> cs.getStyleClassName()).collect(Collectors.toSet());
            while (names.contains(newStyleName)) {
                newStyleName = String.format("column-style-%d", this.styleIndex++);
            }
            ColumnStyle columnStyle = new ColumnStyle();
            columnStyle.setStyleClassName(newStyleName);
            columnStyle.setScope(ColumnStyleScope.ColumnHeader);
            this.columnStyles.add((Object)columnStyle);
            styles.getSelectionModel().select((Object)columnStyle);
            this.setValue(new TableStyle(this.columnStyles));
        });
        Button removeBtn = new Button("Remove");
        removeBtn.setPrefWidth(200.0);
        removeBtn.disableProperty().bind((ObservableValue)Bindings.isEmpty((ObservableList)styles.getSelectionModel().getSelectedItems()));
        removeBtn.setOnAction(e -> {
            ArrayList selected = new ArrayList(styles.getSelectionModel().getSelectedItems());
            TableStyle style = (TableStyle)this.getValue();
            selected.forEach(s -> style.removeColumnStyle(s));
            styles.getSelectionModel().clearSelection();
            this.columnStyles.removeAll(selected);
            this.setValue(new TableStyle(this.columnStyles));
        });
        Button extractCSSStyle = new Button("Exctract CSS Style", (Node)FontIcon.of((Ikon)Dashicons.DOWNLOAD));
        extractCSSStyle.setPrefWidth(200.0);
        extractCSSStyle.disableProperty().bind((ObservableValue)Bindings.isEmpty((ObservableList)styles.getSelectionModel().getSelectedItems()));
        extractCSSStyle.setOnAction(e -> {
            ColumnStyle selected = (ColumnStyle)styles.getSelectionModel().getSelectedItem();
            if (selected == null) {
                return;
            }
            if (this.table.getFXStylesheet() == null) {
                this.table.setFXStylesheet(selected.toStylesheet());
            } else {
                this.table.setFXStylesheet(String.valueOf(this.table.getFXStylesheet()) + "\r\n" + selected.toStylesheet());
            }
        });
        BorderPane buttonsBox = new BorderPane((Node)new VBox(10.0, new Node[]{addBtn, removeBtn}), null, null, (Node)extractCSSStyle, null);
        buttonsBox.setPadding(new Insets(0.0, 10.0, 10.0, 10.0));
        BorderPane propsEditorContainer = new BorderPane((Node)this.createPropertySheet(null));
        BorderPane previewContainer = new BorderPane();
        styles.getSelectionModel().selectedItemProperty().addListener((o, ov, nv) -> {
            PropertySheet sheet = this.createPropertySheet((ColumnStyle)nv);
            propsEditorContainer.setCenter((Node)sheet);
            previewContainer.setCenter((Node)this.createPreview((ColumnStyle)nv));
            InvalidationListener onChange = il -> {
                previewContainer.setCenter((Node)this.createPreview((ColumnStyle)nv));
                this.setValue(new TableStyle(this.columnStyles));
            };
            sheet.getItems().forEach(item -> ((PropertyItem)item).valueProperty().addListener(onChange));
        });
        HBox.setHgrow((Node)previewContainer, (Priority)Priority.ALWAYS);
        HBox content = new HBox(10.0, new Node[]{buttonsBox, styles, propsEditorContainer, previewContainer});
        content.setPrefHeight(250.0);
        return content;
    }

    private PropertySheet createPropertySheet(ColumnStyle editStyle) {
        ColumnStyle style = editStyle != null ? editStyle : new ColumnStyle();
        PropertySheet sheet = new PropertySheet();
        EnumPropertyItem scopeItem = new EnumPropertyItem("Scope", ColumnStyleScope.class, (ObservableValue)style.scopeProperty());
        scopeItem.setNullable(false);
        StringPropertyItem styleClassName = new StringPropertyItem("Style Class Name", (ObservableValue)style.styleClassNameProperty());
        styleClassName.setPromptText("example-column-class-name");
        Validator nameV1 = Validators.createValidator((o, ov, nv) -> nv != null && !nv.isBlank(), (String)"Style class name must be not empty");
        Validator nameV2 = Validators.createValidator((o, ov, nv) -> Pattern.matches("\\w(\\w|\\-)*\\w", nv), (String)"Style class should not contain spezial caraters or whitespaces");
        styleClassName.setValidator(Validators.combine((Validator[])new Validator[]{nameV1, nameV2}));
        PaintPropertyItem baseBackgroundColorItem = new PaintPropertyItem("Background Color", (ObservableValue)style.baseBackgroundColorProperty());
        BooleanPropertyItem gradientBackgroundColorItem = new BooleanPropertyItem("Gradien Background", (ReadOnlyProperty)style.gradientBackgroundProperty());
        PaintPropertyItem textColorItem = new PaintPropertyItem("Text Color", (ObservableValue)style.textColorProperty());
        BooleanPropertyItem textBoldItem = new BooleanPropertyItem("Bold Text", (ReadOnlyProperty)style.textBoldProperty());
        BooleanPropertyItem textItalicItem = new BooleanPropertyItem("Italic Text", (ReadOnlyProperty)style.textItalicProperty());
        sheet.getItems().addAll((Object[])new PropertySheet.Item[]{scopeItem, styleClassName, baseBackgroundColorItem, gradientBackgroundColorItem, textColorItem, textBoldItem, textItalicItem});
        if (editStyle == null) {
            sheet.setDisable(true);
        }
        return sheet;
    }

    private VarTableView createPreview(ColumnStyle editStyle) {
        Table tableConfig = new Table();
        tableConfig.setType(TableType.Time);
        tableConfig.setDefaultRaster(VirtualRaster.Hour);
        TableStyle style = new TableStyle();
        style.addColumnStyle(editStyle);
        tableConfig.setTableStyle(style);
        Column timeColumn = new Column();
        timeColumn.setName("Time");
        timeColumn.setHideMU(true);
        timeColumn.setType(ColumnType.VirtualZoneTimeID);
        tableConfig.getRootColumns().add(timeColumn);
        Column v1Column = new Column();
        v1Column.setName("Value 1");
        v1Column.setType(ColumnType.CustomData);
        v1Column.setMeasuringUnit((MeasuringUnit)Pressure.BAR);
        v1Column.setPrefWidth(Integer.valueOf(100));
        if (editStyle != null) {
            if (editStyle.getScope() != ColumnStyleScope.ColumnHeader) {
                v1Column.setCellStyleClassExpression(String.format("\"%s\"", editStyle.getStyleClassName()));
            } else {
                v1Column.setColumnStyleClass(editStyle.getStyleClassName());
            }
        }
        tableConfig.getRootColumns().add(v1Column);
        VarTableView view = new VarTableView(tableConfig, new StructureObject(), this.getEditor().getScene().getWindow(), null);
        view.addOnLoadCustomColumnData(v1Column, (a, b, c, d, e, f) -> {
            TreeMap<Instant, VarValue> values = new TreeMap<Instant, VarValue>();
            values.put(Instant.ofEpochMilli(0L), new VarValue(0L, 1.43, 1.0, ValueSource.Archive));
            values.put(Instant.ofEpochMilli(Raster.Hour.toMilli()), new VarValue(Raster.Hour.toMilli(), 1.43, 1.0, ValueSource.Archive));
            values.put(Instant.ofEpochMilli(Raster.Hour.toMilli() * 2L), new VarValue(Raster.Hour.toMilli() * 2L, 3.14, 1.0, ValueSource.Archive));
            values.put(Instant.ofEpochMilli(Raster.Hour.toMilli() * 3L), new VarValue(Raster.Hour.toMilli() * 3L, 2.7, 1.0, ValueSource.Archive));
            return values;
        });
        view.loadData((ITimeRangeFilter)new GlobalViewDateTimeRangeFilter(null, null));
        return view;
    }
}

