/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.engin.gui.navi.parts;

import de.elpro.ewms.engin.gui.Messages;
import de.elpro.ewms.engin.gui.navi.model.IDnDNavigationContribution;
import de.elpro.ewms.engin.gui.navi.model.INavigationContribution;
import de.elpro.ewms.engin.gui.navi.model.INavigationTreeElement;
import de.elpro.resources.Icons;
import de.elpro.ui.concurrent.CallableTask;
import de.elpro.ui.di.Refresh;
import de.elpro.ui.fx.cells.uimodel.UIModelTreeCell;
import de.elpro.ui.fx.controls.tree.LazyTreeItem;
import de.elpro.ui.fx.controls.tree.LazyTreeView;
import de.elpro.ui.fx.layout.ProgressIndicatorPane;
import de.elpro.ui.fx.utils.FXUtils;
import de.elpro.ui.fx.utils.TaskUtils;
import de.elpro.ui.model.IdObject;
import de.elpro.ui.model.UIModelElement;
import de.elpro.ui.utils.e4.PartUtils;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javafx.application.Platform;
import javafx.collections.ObservableList;
import javafx.collections.transformation.FilteredList;
import javafx.concurrent.Worker;
import javafx.event.Event;
import javafx.scene.Node;
import javafx.scene.control.Cell;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.MenuItem;
import javafx.scene.control.SelectionMode;
import javafx.scene.control.SeparatorMenuItem;
import javafx.scene.control.TreeItem;
import javafx.scene.control.TreeView;
import javafx.scene.image.ImageView;
import javafx.scene.input.ClipboardContent;
import javafx.scene.input.DragEvent;
import javafx.scene.input.Dragboard;
import javafx.scene.input.MouseButton;
import javafx.scene.input.PickResult;
import javafx.scene.input.TransferMode;
import javafx.scene.layout.BorderPane;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.inject.Named;
import org.eclipse.e4.core.contexts.ContextInjectionFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.ui.model.application.MContribution;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.model.application.ui.menu.MDirectMenuItem;
import org.eclipse.e4.ui.model.application.ui.menu.MMenu;
import org.eclipse.e4.ui.model.application.ui.menu.MMenuElement;
import org.eclipse.e4.ui.services.EMenuService;
import org.eclipse.e4.ui.workbench.modeling.ESelectionService;
import org.eclipse.fx.core.log.Log;
import org.eclipse.fx.core.log.Logger;

public class GenericNavigationPart {
    public static final String ID = "de.elpro.ewms.engin.gui.part.navigation";
    public static final String MENU_TREE_ID = "de.elpro.ewms.engin.gui.menu.navi.tree";
    @Log
    @Inject
    private Logger logger;
    @Inject
    private MPart part;
    @Inject
    private EMenuService menuService;
    @Inject
    private ESelectionService selectionService;
    private final TreeItem<UIModelElement> rootItem = new TreeItem();
    private final TreeView<UIModelElement> view = new LazyTreeView(this.rootItem);
    private final ProgressIndicatorPane progressPane = new ProgressIndicatorPane(this.view);
    private MenuItem refreshItem = new MenuItem(Messages.Navi_Parts_GenericNavigationPart_Refresh, (Node)new ImageView(Icons.REFRESH_ITEM_URL.toExternalForm()));
    private SeparatorMenuItem separator = new SeparatorMenuItem();
    private INavigationContribution<UIModelElement> naviContrib;

    @PostConstruct
    public void postConstruct(BorderPane parent) {
        this.view.setCellFactory(cf -> new UIModelTreeCell(this::onDoubleClick));
        this.view.setShowRoot(false);
        this.view.getSelectionModel().setSelectionMode(SelectionMode.MULTIPLE);
        parent.setCenter((Node)this.progressPane);
        this.view.getSelectionModel().selectedItemProperty().addListener((o, ov, nv) -> {
            this.refreshItem.setDisable(!this.view.getSelectionModel().getSelectedItems().stream().filter(i -> i instanceof LazyTreeItem).findAny().isPresent());
            if (nv != null && nv.getValue() instanceof MenuME) {
                MenuME m = (MenuME)nv.getValue();
                if (m.onselect != null) {
                    m.onselect.run();
                }
            }
        });
        this.view.setOnMouseClicked(me -> {
            if (me.getClickCount() == 1 && !me.isControlDown() && !me.isShiftDown()) {
                PickResult pr = me.getPickResult();
                if (pr.getIntersectedNode().getStyleClass().contains((Object)"arrow") || pr.getIntersectedNode().getStyleClass().contains((Object)"tree-disclosure-node")) {
                    return;
                }
                Cell cell = (Cell)FXUtils.findParent((Node)pr.getIntersectedNode(), Cell.class);
                if (cell == null || !(cell.getItem() instanceof UIModelElement)) {
                    return;
                }
                TreeItem lastSelectedItem = (TreeItem)this.view.getSelectionModel().getSelectedItem();
                if (this.view.getSelectionModel().getSelectedItems().size() <= 1) {
                    if (lastSelectedItem != null && lastSelectedItem.getValue() != cell.getItem()) {
                        return;
                    }
                    this.selectionService.setSelection((Object)lastSelectedItem);
                } else {
                    this.selectionService.setSelection(new LinkedList(this.view.getSelectionModel().getSelectedItems()));
                }
                MenuME menuME = GenericNavigationPart.findMenuME((TreeItem<UIModelElement>)lastSelectedItem);
                if (menuME != null && menuME.naviContrib != null) {
                    if (this.naviContrib != menuME.naviContrib) {
                        this.naviContrib = menuME.naviContrib;
                        this.view.setContextMenu(null);
                        if (this.naviContrib.getContextMenuId() != null && this.menuService.registerContextMenu(this.view, this.naviContrib.getContextMenuId())) {
                            ContextMenu cm = this.view.getContextMenu();
                            if (!cm.getItems().contains((Object)this.refreshItem)) {
                                cm.getItems().add(0, (Object)this.refreshItem);
                            }
                            if (cm.getItems().size() > 1 && !cm.getItems().contains((Object)this.separator)) {
                                cm.getItems().add(1, (Object)this.separator);
                            }
                        }
                    }
                } else {
                    this.view.setContextMenu(null);
                    this.naviContrib = null;
                }
                if (this.naviContrib != null && me.getButton() == MouseButton.PRIMARY) {
                    this.naviContrib.onTreeItemClick(this, (TreeItem<UIModelElement>)lastSelectedItem);
                }
            }
        });
        this.view.setOnDragDetected(event -> {
            ObservableList treeItems = this.view.getSelectionModel().getSelectedItems();
            if (treeItems.isEmpty()) {
                return;
            }
            Dragboard db = this.view.startDragAndDrop(TransferMode.ANY);
            String clipboardContent = null;
            for (TreeItem treeItem : treeItems) {
                MenuME me = GenericNavigationPart.findMenuME((TreeItem<UIModelElement>)treeItem);
                if (me == null) {
                    return;
                }
                INavigationContribution<UIModelElement> naviContrib = me.naviContrib;
                if (naviContrib == null) {
                    return;
                }
                if (!naviContrib.canDragItem((UIModelElement)treeItem.getValue())) {
                    return;
                }
                clipboardContent = clipboardContent == null ? "" : String.valueOf(clipboardContent) + ";";
                clipboardContent = treeItem.getValue() instanceof IdObject ? String.valueOf(clipboardContent) + ((IdObject)treeItem.getValue()).getFullId() : String.valueOf(clipboardContent) + ((UIModelElement)treeItem.getValue()).toString();
            }
            if (clipboardContent == null) {
                return;
            }
            ClipboardContent content = new ClipboardContent();
            content.putString(clipboardContent);
            db.setContent((Map)content);
            event.consume();
        });
        this.view.setOnDragOver(event -> {
            if (this.naviContrib != null) {
                Cell cell = (Cell)FXUtils.findParent((Node)event.getPickResult().getIntersectedNode(), Cell.class);
                if (cell == null || !(cell.getItem() instanceof UIModelElement)) {
                    return;
                }
                if (this.naviContrib instanceof IDnDNavigationContribution) {
                    event.acceptTransferModes(((IDnDNavigationContribution)this.naviContrib).onDragOver((UIModelElement)cell.getItem(), (DragEvent)event));
                    return;
                }
                String clipboardContent = event.getDragboard().getString();
                if (clipboardContent != null) {
                    event.acceptTransferModes(this.naviContrib.getDropModes((UIModelElement)cell.getItem(), clipboardContent));
                }
            }
            event.consume();
        });
        this.view.setOnDragEntered(event -> {
            if (this.naviContrib != null) {
                Cell cell = (Cell)FXUtils.findParent((Node)event.getPickResult().getIntersectedNode(), Cell.class);
                if (cell == null || !(cell.getItem() instanceof UIModelElement)) {
                    return;
                }
                if (this.naviContrib instanceof IDnDNavigationContribution) {
                    ((IDnDNavigationContribution)this.naviContrib).onDragEntered((UIModelElement)cell.getItem(), (DragEvent)event);
                }
            }
        });
        this.view.setOnDragExited(event -> {
            if (this.naviContrib != null) {
                Cell cell = (Cell)FXUtils.findParent((Node)event.getPickResult().getIntersectedNode(), Cell.class);
                if (cell == null || !(cell.getItem() instanceof UIModelElement)) {
                    return;
                }
                if (this.naviContrib instanceof IDnDNavigationContribution) {
                    ((IDnDNavigationContribution)this.naviContrib).onDragExited((UIModelElement)cell.getItem(), (DragEvent)event);
                }
            }
        });
        this.view.setOnDragDropped(event -> {
            if (this.naviContrib != null) {
                Cell cell = (Cell)FXUtils.findParent((Node)event.getPickResult().getIntersectedNode(), Cell.class);
                if (cell == null || !(cell.getItem() instanceof UIModelElement)) {
                    return;
                }
                if (this.naviContrib instanceof IDnDNavigationContribution) {
                    ((IDnDNavigationContribution)this.naviContrib).onDragDropped((UIModelElement)cell.getItem(), (DragEvent)event);
                    return;
                }
                String clipboardContent = event.getDragboard().getString();
                if (clipboardContent != null && this.naviContrib != null) {
                    this.naviContrib.onDropItem((UIModelElement)cell.getItem(), clipboardContent);
                }
                event.consume();
            }
        });
        this.view.setOnDragDone(event -> {
            if (this.naviContrib != null && this.naviContrib instanceof IDnDNavigationContribution) {
                ((IDnDNavigationContribution)this.naviContrib).onDragDone((DragEvent)event);
            }
        });
        this.refreshItem.setOnAction(a -> {
            FilteredList selected = this.view.getSelectionModel().getSelectedItems().filtered(e -> e instanceof LazyTreeItem);
            selected.forEach(t -> {
                if (t.isExpanded()) {
                    ((LazyTreeItem)t).refreshChildren();
                }
            });
        });
        this.refresh();
    }

    @Inject
    public void setSelection(@Optional @Named(value="navi-selection") @Named(value="navi-selection") TreeItem<UIModelElement> treeItem) {
        TreeItem currentlySelected;
        if (treeItem != null && (currentlySelected = (TreeItem)this.view.getSelectionModel().getSelectedItem()) != treeItem) {
            this.view.getSelectionModel().select(treeItem);
        }
    }

    private void onDoubleClick(Event e) {
        TreeItem treeItem = (TreeItem)this.view.getSelectionModel().getSelectedItem();
        if (this.naviContrib != null) {
            this.naviContrib.onTreeItemDoubleClick(this, (TreeItem<UIModelElement>)treeItem);
        }
    }

    @Refresh
    public void refresh() {
        final MMenu menu = this.findMenu(MENU_TREE_ID);
        CallableTask<List<TreeItem<UIModelElement>>> task = new CallableTask<List<TreeItem<UIModelElement>>>(){

            public List<TreeItem<UIModelElement>> call() throws Exception {
                LinkedList<TreeItem<UIModelElement>> rootItems = new LinkedList<TreeItem<UIModelElement>>();
                for (MMenuElement me : menu.getChildren()) {
                    TreeItem<UIModelElement> nvti = GenericNavigationPart.this.createNavigationTree(me);
                    if (nvti == null) continue;
                    nvti.setExpanded(true);
                    rootItems.add(nvti);
                }
                return rootItems;
            }
        };
        TaskUtils.executeUITask((ProgressIndicatorPane)this.progressPane, (CallableTask)task).consumeResult((s, items) -> {
            if (s == Worker.State.SUCCEEDED) {
                Platform.runLater(() -> {
                    boolean bl = this.rootItem.getChildren().setAll((Collection)items);
                });
            }
        });
    }

    private MMenu findMenu(String menuId) {
        for (MMenu m : this.part.getMenus()) {
            if (!m.getElementId().equals(menuId)) continue;
            return m;
        }
        return null;
    }

    /*
     * Unable to fully structure code
     */
    private static MenuME findMenuME(TreeItem<UIModelElement> selection) {
        if (selection != null) ** GOTO lbl4
        return null;
lbl-1000:
        // 1 sources

        {
            selection = selection.getParent();
lbl4:
            // 2 sources

            ** while (selection != null && !(selection.getValue() instanceof MenuME))
        }
lbl5:
        // 1 sources

        return (MenuME)selection.getValue();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private TreeItem<UIModelElement> createNavigationTree(MMenuElement me) {
        TreeItem result = null;
        MenuME value = new MenuME(me);
        if (me instanceof MMenu) {
            result = new TreeItem((Object)value);
            MMenu subMenu = (MMenu)me;
            for (MMenuElement child : subMenu.getChildren()) {
                TreeItem<UIModelElement> menuItem = this.createNavigationTree(child);
                if (menuItem == null) continue;
                result.getChildren().add(menuItem);
            }
            return result;
        } else {
            if (!(me instanceof MDirectMenuItem)) return result;
            MDirectMenuItem di = (MDirectMenuItem)me;
            try {
                Object contributionObject = PartUtils.getContributionObject((IEclipseContext)this.part.getContext(), (MContribution)di);
                if (contributionObject instanceof INavigationContribution) {
                    value.naviContrib = (INavigationContribution)contributionObject;
                    result = new LazyTreeItem((Object)value, value.naviContrib.getChildrenCreator());
                } else {
                    result = new TreeItem((Object)value);
                }
                if (contributionObject == null) return result;
                value.onselect = () -> ContextInjectionFactory.invoke((Object)contributionObject, Execute.class, (IEclipseContext)this.part.getContext());
                return result;
            }
            catch (Exception exc) {
                this.logger.error("Error building Engin Navi", (Throwable)exc);
            }
        }
        return result;
    }

    private class MenuME
    implements INavigationTreeElement {
        private MMenuElement element;
        private Runnable onselect;
        private INavigationContribution<UIModelElement> naviContrib;

        public MenuME(MMenuElement element) {
            this.element = element;
        }

        public String toString() {
            return this.element.getLocalizedLabel();
        }

        public boolean isEnabled() {
            return this.element instanceof MMenu || this.onselect != null;
        }

        public String getIconUri() {
            try {
                return this.element.getIconURI();
            }
            catch (Exception exception) {
                return null;
            }
        }
    }
}

