/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.engin.gui.navi.server.accessmanagement.group.handlers;

import de.elpro.ewms.core.auth.User;
import de.elpro.ewms.core.client.Transactions;
import de.elpro.ewms.core.client.auth.UserDAO;
import de.elpro.ewms.core.db.Transaction;
import de.elpro.ewms.engin.gui.navi.model.INavigationTreeElement;
import de.elpro.ewms.engin.gui.navi.model.LazyNavigationContribution;
import de.elpro.ewms.engin.gui.navi.server.accessmanagement.group.handlers.GroupsEditHandler;
import de.elpro.ewms.gui.utils.e4.EOSPartUtils;
import de.elpro.ui.model.UIModelElement;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Function;
import javafx.scene.control.TreeItem;
import javax.inject.Inject;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.workbench.modeling.EModelService;

public class CreateGroupsNaviTreeHandler
extends LazyNavigationContribution<UIModelElement> {
    private Function<TreeItem<UIModelElement>, List<TreeItem<UIModelElement>>> LIST_CREATOR = new Function<TreeItem<UIModelElement>, List<TreeItem<UIModelElement>>>(){

        @Override
        public List<TreeItem<UIModelElement>> apply(TreeItem<UIModelElement> item) {
            LinkedList<TreeItem<UIModelElement>> elements = new LinkedList<TreeItem<UIModelElement>>();
            Transaction trx = Transactions.begin();
            try {
                if (item.getValue() == null || item.getValue() instanceof INavigationTreeElement) {
                    elements.addAll(CreateGroupsNaviTreeHandler.this.createTreeItemCollection((UIModelElement[])UserDAO.getAll((Transaction)trx)));
                }
            }
            finally {
                Transactions.close((Transaction)trx);
            }
            return elements;
        }
    };
    @Inject
    private MApplication app;
    @Inject
    private EModelService modelService;

    @Override
    public Function<TreeItem<UIModelElement>, List<TreeItem<UIModelElement>>> getChildrenCreator() {
        return this.LIST_CREATOR;
    }

    @Execute
    public void execute() {
    }

    public List<TreeItem<UIModelElement>> getChildren() {
        Transaction trx = Transactions.begin();
        LinkedList<TreeItem<UIModelElement>> rootItems = new LinkedList<TreeItem<UIModelElement>>();
        try {
            User[] userArray = UserDAO.getAll((Transaction)trx);
            int n = userArray.length;
            int n2 = 0;
            while (n2 < n) {
                User user = userArray[n2];
                TreeItem userItem = new TreeItem((Object)user);
                rootItems.add((TreeItem<UIModelElement>)userItem);
                ++n2;
            }
        }
        finally {
            Transactions.close((Transaction)trx);
        }
        return rootItems;
    }

    @Override
    public String getContextMenuId() {
        return "de.elpro.ewms.engin.gui.menu.navi.auth.groups";
    }

    @Override
    public void onTreeItemClick(Object sender, TreeItem<UIModelElement> treeItem) {
        if (treeItem != null && treeItem.getValue() instanceof User) {
            new GroupsEditHandler().execute(this.app, treeItem);
        }
    }

    @Override
    public void onTreeItemDoubleClick(Object sender, TreeItem<UIModelElement> treeItem) {
        EOSPartUtils.pinSelectedMPart((EModelService)this.modelService, (MApplication)this.app, (String)"de.elpro.ewms.engin.gui.partstack.editors");
    }
}

