/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.engin.gui.navi.server.auth.handlers;

import de.elpro.ewms.core.auth.StrongPasswordEncryptor;
import de.elpro.ewms.core.auth.User;
import de.elpro.ewms.core.client.Transactions;
import de.elpro.ewms.core.client.auth.UserDAO;
import de.elpro.ewms.core.db.DAOOperationException;
import de.elpro.ewms.core.db.Transaction;
import de.elpro.ewms.engin.gui.navi.server.auth.parts.UserChangePasswordDialog;
import javafx.scene.Scene;
import javafx.scene.control.Alert;
import javafx.scene.control.ButtonType;
import javafx.scene.control.TreeItem;
import javax.inject.Named;
import org.eclipse.e4.core.di.annotations.CanExecute;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.core.di.annotations.Optional;

public class UsersChangePasswordHandler {
    @Execute
    public void execute(@Named(value="org.eclipse.ui.selection") @Named(value="org.eclipse.ui.selection") TreeItem<?> item, Scene scene) {
        User user = (User)item.getValue();
        User currentUser = UserDAO.get();
        UserChangePasswordDialog dialog = new UserChangePasswordDialog(scene.getWindow(), !currentUser.isAdmin());
        dialog.showAndWait().ifPresent(bt -> {
            if (bt == ButtonType.OK) {
                Transaction trx = Transactions.begin();
                try {
                    try {
                        StrongPasswordEncryptor encryptor = new StrongPasswordEncryptor();
                        String encOldPswd = dialog.getOldPassword() != null && !dialog.getOldPassword().isEmpty() ? encryptor.encryptPassword(dialog.getOldPassword()) : null;
                        String encNewPswd = dialog.getNewPassword() != null && !dialog.getNewPassword().isEmpty() ? encryptor.encryptPassword(dialog.getNewPassword()) : null;
                        UserDAO.changePassword((Transaction)trx, (String)user.getDomain(), (String)user.getLogin(), (String)encOldPswd, (String)encNewPswd);
                        Transactions.commitSync((Transaction)trx);
                    }
                    catch (DAOOperationException exc) {
                        Transactions.rollback((Transaction)trx);
                        Alert alert = new Alert(Alert.AlertType.ERROR);
                        alert.setContentText(exc.getMessage());
                        alert.show();
                        Transactions.close((Transaction)trx);
                    }
                }
                finally {
                    Transactions.close((Transaction)trx);
                }
            }
        });
    }

    @CanExecute
    public boolean canExecute(@Optional @Named(value="org.eclipse.ui.selection") @Named(value="org.eclipse.ui.selection") TreeItem<?> item) {
        return item != null && item.getValue() instanceof User;
    }
}

