/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.engin.gui.navi.server.auth.handlers;

import de.elpro.ewms.core.auth.User;
import de.elpro.ewms.core.client.Transactions;
import de.elpro.ewms.core.client.auth.UserDAO;
import de.elpro.ewms.core.db.DAOOperationException;
import de.elpro.ewms.core.db.Transaction;
import de.elpro.ui.utils.e4.PartUtils;
import javafx.scene.Scene;
import javafx.scene.control.Alert;
import javafx.scene.control.ButtonType;
import javafx.scene.control.TreeItem;
import javax.inject.Inject;
import javax.inject.Named;
import org.eclipse.e4.core.di.annotations.CanExecute;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.fx.core.log.Log;
import org.eclipse.fx.core.log.Logger;

public class UsersDeleteHandler {
    @Inject
    @Log
    private Logger logger;
    @Inject
    private MApplication app;

    @Execute
    public void execute(@Optional @Named(value="org.eclipse.ui.selection") @Named(value="org.eclipse.ui.selection") TreeItem<?> item, Scene scene) {
        User user = (User)item.getValue();
        Alert alert = new Alert(Alert.AlertType.CONFIRMATION);
        alert.initOwner(scene.getWindow());
        alert.setTitle("Confirmation Dialog");
        alert.setContentText(String.format("Do you shure you want delete \"%s\"?", user));
        if (alert.showAndWait().get() == ButtonType.OK) {
            PartUtils.closePart((String)"de.elpro.ewms.engin.gui.partdescriptor.auth.user", (MApplication)this.app, (Object[])new Object[]{user});
            Transaction trx = Transactions.begin();
            try {
                try {
                    UserDAO.delete((Transaction)trx, (int)user.getId());
                    Transactions.commitSync((Transaction)trx);
                    item.getParent().getChildren().remove(item);
                }
                catch (DAOOperationException exc) {
                    this.logger.error("Error deleting user", (Throwable)exc);
                    Transactions.rollback((Transaction)trx);
                    Alert errorAlert = new Alert(Alert.AlertType.ERROR);
                    errorAlert.setContentText(exc.getMessage());
                    errorAlert.show();
                    Transactions.close((Transaction)trx);
                }
            }
            finally {
                Transactions.close((Transaction)trx);
            }
        }
    }

    @CanExecute
    public boolean canExecute(@Optional @Named(value="org.eclipse.ui.selection") @Named(value="org.eclipse.ui.selection") TreeItem<?> item) {
        return item != null && item.getValue() instanceof User;
    }
}

