/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.engin.gui.navi.server.auth.parts;

import de.elpro.ui.fx.validator.Validators;
import javafx.beans.Observable;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.value.ObservableValue;
import javafx.event.EventType;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.control.ButtonType;
import javafx.scene.control.Dialog;
import javafx.scene.control.Label;
import javafx.scene.control.PasswordField;
import javafx.scene.control.TextField;
import javafx.scene.layout.ColumnConstraints;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.Priority;
import javafx.stage.Window;
import jidefx.scene.control.decoration.DecorationPane;
import jidefx.scene.control.validation.ValidationEvent;
import jidefx.scene.control.validation.ValidationGroup;
import jidefx.scene.control.validation.ValidationMode;
import jidefx.scene.control.validation.ValidationUtils;
import jidefx.scene.control.validation.Validator;

public class UserChangePasswordDialog
extends Dialog<ButtonType> {
    private final SimpleStringProperty oldPassword = new SimpleStringProperty();
    private final SimpleStringProperty newPassword = new SimpleStringProperty();

    public UserChangePasswordDialog(Window window, boolean enterCurrentPassword) {
        this.initOwner(window);
        GridPane pane = new GridPane();
        pane.setHgap(5.0);
        pane.setVgap(10.0);
        pane.setPadding(new Insets(10.0));
        pane.setPrefWidth(500.0);
        pane.getColumnConstraints().add((Object)new ColumnConstraints(){
            {
                this.setMinWidth(100.0);
            }
        });
        int row = 0;
        if (enterCurrentPassword) {
            PasswordField oldPasswdField = new PasswordField();
            GridPane.setHgrow((Node)oldPasswdField, (Priority)Priority.ALWAYS);
            this.oldPassword.bind((ObservableValue)oldPasswdField.textProperty());
            pane.addRow(row++, new Node[]{new Label("Old Password"), oldPasswdField});
        }
        PasswordField newPasswdField = new PasswordField();
        GridPane.setHgrow((Node)newPasswdField, (Priority)Priority.ALWAYS);
        this.newPassword.bind((ObservableValue)newPasswdField.textProperty());
        PasswordField newPasswdConfirmationField = new PasswordField();
        GridPane.setHgrow((Node)newPasswdConfirmationField, (Priority)Priority.ALWAYS);
        Validator passwdEqValidator = Validators.createValidator((arg_0, arg_1, arg_2) -> UserChangePasswordDialog.lambda$0((TextField)newPasswdField, (TextField)newPasswdConfirmationField, arg_0, arg_1, arg_2), (String)"Password and its Confirmation must be equal");
        Validator shortPasswdValidator = Validators.createValidator((o, ov, nv) -> nv != null && ((String)nv).length() >= 4, (EventType)ValidationEvent.VALIDATION_WARNING, (String)"Password is to short");
        ValidationUtils.install((Node)newPasswdField, (Validator)Validators.combine((Validator[])new Validator[]{passwdEqValidator, shortPasswdValidator}));
        ValidationUtils.install((Node)newPasswdConfirmationField, (Validator)Validators.combine((Validator[])new Validator[]{passwdEqValidator, shortPasswdValidator}));
        newPasswdField.textProperty().addListener(arg_0 -> UserChangePasswordDialog.lambda$2((TextField)newPasswdConfirmationField, arg_0));
        newPasswdConfirmationField.textProperty().addListener(arg_0 -> UserChangePasswordDialog.lambda$3((TextField)newPasswdField, arg_0));
        pane.addRow(row++, new Node[]{new Label("New Password"), newPasswdField});
        pane.addRow(row++, new Node[]{new Label("New Password (conf.)"), newPasswdConfirmationField});
        this.getDialogPane().setContent((Node)new DecorationPane((Parent)pane));
        this.getDialogPane().getButtonTypes().addAll((Object[])new ButtonType[]{ButtonType.OK, ButtonType.CANCEL});
        ValidationGroup validationGroup = new ValidationGroup(new Node[]{newPasswdField, newPasswdConfirmationField});
        Node confirmNode = this.getDialogPane().lookupButton(ButtonType.OK);
        confirmNode.disableProperty().bind((ObservableValue)validationGroup.invalidProperty());
        ValidationUtils.forceValidate((Node)newPasswdField, (ValidationMode)ValidationMode.ON_FLY);
        ValidationUtils.forceValidate((Node)newPasswdConfirmationField, (ValidationMode)ValidationMode.ON_FLY);
    }

    public String getOldPassword() {
        return this.oldPassword.get();
    }

    public String getNewPassword() {
        return this.newPassword.get();
    }

    private static /* synthetic */ boolean lambda$0(TextField textField, TextField textField2, Object o, Object ov, Object nv) {
        if (textField.getText() != null && textField2.getText() != null) {
            return textField.getText().equals(textField2.getText());
        }
        return true;
    }

    private static /* synthetic */ void lambda$2(TextField textField, Observable il) {
        ValidationUtils.forceValidate((Node)textField, (ValidationMode)ValidationMode.ON_FLY);
    }

    private static /* synthetic */ void lambda$3(TextField textField, Observable il) {
        ValidationUtils.forceValidate((Node)textField, (ValidationMode)ValidationMode.ON_FLY);
    }
}

