/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.engin.gui.navi.server.auth.parts;

import de.elpro.ewms.core.auth.LoginCredentialsValidator;
import de.elpro.ewms.core.auth.User;
import de.elpro.ewms.core.client.Transactions;
import de.elpro.ewms.core.client.auth.UserDAO;
import de.elpro.ewms.core.db.DAOOperationException;
import de.elpro.ewms.core.db.Transaction;
import de.elpro.ewms.engin.gui.services.EnginPartUtils;
import de.elpro.ui.fx.propertysheet.BooleanPropertyItem;
import de.elpro.ui.fx.propertysheet.IntegerPropertyItem;
import de.elpro.ui.fx.propertysheet.NumberPropertyItem;
import de.elpro.ui.fx.propertysheet.PropertyItemsHelper;
import de.elpro.ui.fx.propertysheet.StringPropertyItem;
import de.elpro.ui.fx.validator.Validators;
import de.elpro.ui.utils.e4.PartUtils;
import java.util.Collection;
import java.util.List;
import javafx.beans.property.ReadOnlyProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.value.ObservableValue;
import javafx.event.EventType;
import javafx.scene.Node;
import javafx.scene.Scene;
import javafx.scene.control.Alert;
import javafx.scene.control.ButtonType;
import javafx.scene.layout.BorderPane;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import jidefx.scene.control.validation.ValidationEvent;
import jidefx.scene.control.validation.ValidationObject;
import jidefx.scene.control.validation.Validator;
import org.controlsfx.control.PropertySheet;
import org.controlsfx.dialog.ExceptionDialog;
import org.eclipse.e4.ui.di.Persist;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.workbench.modeling.EPartService;

public class UserEditPart {
    public static final String ID = "de.elpro.ewms.engin.gui.partdescriptor.auth.user";
    private static final String MAIN_CATEGORY = "Main";
    @Inject
    private User user;
    @Inject
    private MPart part;
    @Inject
    private EPartService partService;
    @Inject
    private Scene scene;
    private final PropertySheet sheet = new PropertySheet();
    private final SimpleBooleanProperty hasChanges = new SimpleBooleanProperty(false);
    private final SimpleBooleanProperty hasErrors = new SimpleBooleanProperty(false);
    private NumberPropertyItem<Integer> idItem;
    private String initialLoginPhrase;

    @PostConstruct
    public void postConstruct(BorderPane parent) {
        User currentUser = UserDAO.get();
        Transaction trx = Transactions.begin();
        try {
            if (this.user.getId() != null) {
                this.user = UserDAO.get((Transaction)trx, (int)this.user.getId());
            }
        }
        finally {
            Transactions.close((Transaction)trx);
        }
        this.idItem = new IntegerPropertyItem(MAIN_CATEGORY, "Id", (ObservableValue)this.user.idProperty());
        this.idItem.setReadOnly(true);
        StringPropertyItem domainItem = new StringPropertyItem(MAIN_CATEGORY, "Domain", (ObservableValue)this.user.domainProperty());
        domainItem.setValidator(new Validator(){

            public ValidationEvent call(ValidationObject param) {
                List errors = LoginCredentialsValidator.checkLoginToken((String)((String)param.getNewValue()), (boolean)false);
                if (errors == null || errors.isEmpty()) {
                    return ValidationEvent.OK;
                }
                return new ValidationEvent(ValidationEvent.VALIDATION_ERROR, 0, (String)errors.get(0));
            }
        });
        StringPropertyItem loginItem = new StringPropertyItem(MAIN_CATEGORY, "Login", (ObservableValue)this.user.loginProperty());
        loginItem.setValidator(new Validator(){

            public ValidationEvent call(ValidationObject param) {
                List errors = LoginCredentialsValidator.checkLoginToken((String)((String)param.getNewValue()), (boolean)true);
                if (errors == null || errors.isEmpty()) {
                    return ValidationEvent.OK;
                }
                return new ValidationEvent(ValidationEvent.VALIDATION_ERROR, 0, (String)errors.get(0));
            }
        });
        StringPropertyItem firstNameItem = new StringPropertyItem(MAIN_CATEGORY, "First Name", (ObservableValue)this.user.firstNameProperty());
        StringPropertyItem lastNameItem = new StringPropertyItem(MAIN_CATEGORY, "Last Name", (ObservableValue)this.user.lastNameProperty());
        StringPropertyItem emailItem = new StringPropertyItem(MAIN_CATEGORY, "E-Mail", (ObservableValue)this.user.emailProperty());
        emailItem.setValidator(Validators.combine((Validator[])new Validator[]{Validators.createEmailValidator((String)"Invalid E-Mail"), Validators.createNotEmptyValidator((String)"Empy E-Mail", (EventType)ValidationEvent.VALIDATION_WARNING)}));
        BooleanPropertyItem activeItem = new BooleanPropertyItem(MAIN_CATEGORY, "Active", (ReadOnlyProperty)this.user.activeProperty());
        activeItem.setReadOnly(!currentUser.isAdmin() || currentUser.equals((Object)this.user));
        BooleanPropertyItem adminItem = new BooleanPropertyItem(MAIN_CATEGORY, "Administrator", (ReadOnlyProperty)this.user.adminProperty());
        adminItem.setReadOnly(!currentUser.isAdmin() || currentUser.equals((Object)this.user));
        this.sheet.getItems().addAll((Object[])new PropertySheet.Item[]{this.idItem, domainItem, loginItem, firstNameItem, lastNameItem, emailItem, activeItem, adminItem});
        this.hasChanges.bind((ObservableValue)PropertyItemsHelper.createHasChangesProperty((Collection)this.sheet.getItems()));
        this.hasErrors.bind((ObservableValue)PropertyItemsHelper.createHasErrorsProperty((Collection)this.sheet.getItems()));
        this.initialLoginPhrase = this.user.getLoginPhrase();
        parent.setCenter((Node)this.sheet);
        this.hasChanges.addListener((o, ov, nv) -> this.part.setDirty(nv.booleanValue()));
    }

    @Persist
    public void save() {
        String loginPhrase;
        if (!this.hasChanges.get()) {
            return;
        }
        if (this.hasErrors.get()) {
            Alert alert = new Alert(Alert.AlertType.WARNING);
            alert.initOwner(this.scene.getWindow());
            alert.setContentText(String.format("Cannot save %s. Fix errors first.", this.user.toString()));
            alert.showAndWait();
            return;
        }
        if (this.user.getId() != null && !(loginPhrase = this.user.getLoginPhrase()).equals(this.initialLoginPhrase)) {
            Alert alert = new Alert(Alert.AlertType.CONFIRMATION);
            alert.initOwner(this.scene.getWindow());
            alert.setContentText("Login credentials changed. Active session of user, if exists, will be closed and user logged off. Proceed?");
            ButtonType buttonType = (ButtonType)alert.showAndWait().get();
            if (buttonType != ButtonType.OK) {
                return;
            }
        }
        if (this.user.getDomain() != null) {
            this.user.setDomain(this.user.getDomain().trim());
            if (this.user.getDomain().isBlank()) {
                this.user.setDomain(null);
            }
        }
        this.user.setLogin(this.user.getLogin().trim());
        Transaction trx = Transactions.begin();
        try {
            try {
                if (this.user.getId() == null) {
                    this.idItem.setValue((Object)UserDAO.create((Transaction)trx, (User)this.user, null));
                } else {
                    UserDAO.update((Transaction)trx, (User)this.user);
                }
                Transactions.commitSync((Transaction)trx);
                PropertyItemsHelper.resetHasChangesProperties((Collection)this.sheet.getItems());
                this.part.setDirty(false);
                this.part.setLabel(this.user.toString());
                this.initialLoginPhrase = this.user.getLoginPhrase();
                EnginPartUtils.refreshItems(this.user, this.part);
            }
            catch (DAOOperationException exc) {
                Transactions.rollback((Transaction)trx);
                ExceptionDialog dlg = new ExceptionDialog((Throwable)exc);
                dlg.initOwner(this.scene.getWindow());
                dlg.setContentText("Error saving User");
                dlg.show();
                Transactions.close((Transaction)trx);
                return;
            }
        }
        finally {
            Transactions.close((Transaction)trx);
        }
        PartUtils.refreshParts((EPartService)this.partService, User.class);
        this.part.setLabel(this.user.toString());
    }

    @PreDestroy
    protected void close() {
        this.part.setDirty(false);
    }
}

