/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.engin.gui.navi.server.characteristics.handlers;

import de.elpro.ewms.core.characteristic.Characteristic2D;
import de.elpro.ewms.core.characteristic.Characteristic3D;
import de.elpro.ewms.core.client.characteristic.Characteristic2DDAO;
import de.elpro.ewms.core.client.characteristic.Characteristic3DDAO;
import de.elpro.ewms.core.db.Transaction;
import de.elpro.ewms.engin.gui.services.EnginPartUtils;
import de.elpro.ui.model.UIModelElement;
import de.elpro.ui.utils.e4.PartUtils;
import javafx.scene.Scene;
import javafx.scene.control.TreeItem;
import javax.inject.Inject;
import javax.inject.Named;
import org.eclipse.e4.core.di.annotations.CanExecute;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.fx.core.log.Log;
import org.eclipse.fx.core.log.Logger;

public class CharacteristicsDeleteHandler {
    @Inject
    @Log
    private Logger logger;
    @Inject
    private MApplication app;

    @Execute
    public void execute(Scene scene, @Optional @Named(value="org.eclipse.ui.selection") @Named(value="org.eclipse.ui.selection") TreeItem<? extends UIModelElement> item) {
        if (item.getValue() instanceof Characteristic2D) {
            CharacteristicsDeleteHandler.deleteCharacteristic2D(this.logger, scene, this.app, item);
        }
        if (item.getValue() instanceof Characteristic3D) {
            CharacteristicsDeleteHandler.deleteCharacteristic3D(this.logger, scene, this.app, item);
        }
    }

    public static void deleteCharacteristic2D(Logger logger, Scene scene, MApplication app, TreeItem<? extends UIModelElement> item) {
        EnginPartUtils.showDeleteDialog(scene.getWindow(), app, item, (trx, c2d) -> {
            Characteristic2DDAO.delete((Transaction)trx, (int)((Characteristic2D)c2d).getId());
            return true;
        }, (a, c2d) -> PartUtils.closePart((String)"de.elpro.ewms.engin.gui.partdescriptor.characteristics.c2deditpart", (MApplication)app, (Object[])new Object[]{c2d}));
    }

    public static void deleteCharacteristic3D(Logger logger, Scene scene, MApplication app, TreeItem<? extends UIModelElement> item) {
        EnginPartUtils.showDeleteDialog(scene.getWindow(), app, item, (trx, c3d) -> {
            Characteristic3DDAO.delete((Transaction)trx, (int)((Characteristic3D)c3d).getId());
            return true;
        }, (a, c3d) -> PartUtils.closePart((String)"de.elpro.ewms.engin.gui.partdescriptor.characteristics.c3deditpart", (MApplication)app, (Object[])new Object[]{c3d}));
    }

    @CanExecute
    public boolean canExecute(@Optional @Named(value="org.eclipse.ui.selection") @Named(value="org.eclipse.ui.selection") TreeItem<?> item) {
        if (item == null) {
            return false;
        }
        return item.getValue() instanceof Characteristic2D || item.getValue() instanceof Characteristic3D;
    }
}

