/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.engin.gui.navi.server.characteristics.handlers;

import com.google.common.collect.TreeMultimap;
import de.elpro.ewms.core.characteristic.Characteristic2D;
import de.elpro.ewms.core.characteristic.Characteristic2DInstance;
import de.elpro.ewms.core.characteristic.Characteristic3D;
import de.elpro.ewms.core.characteristic.Characteristic3DInstance;
import de.elpro.ewms.core.client.Transactions;
import de.elpro.ewms.core.client.characteristic.Characteristic2DDAO;
import de.elpro.ewms.core.client.characteristic.Characteristic2DInstanceDAO;
import de.elpro.ewms.core.client.characteristic.Characteristic3DDAO;
import de.elpro.ewms.core.client.characteristic.Characteristic3DInstanceDAO;
import de.elpro.ewms.core.client.structure.StructureClassDAO;
import de.elpro.ewms.core.client.structure.StructureObjectDAO;
import de.elpro.ewms.core.db.Transaction;
import de.elpro.ewms.core.structure.StructureClass;
import de.elpro.ewms.core.structure.StructureObject;
import de.elpro.ewms.engin.gui.navi.model.INavigationTreeElement;
import de.elpro.ewms.engin.gui.navi.model.LazyNavigationContribution;
import de.elpro.ewms.engin.gui.navi.server.characteristics.handlers.CharacteristicsEditHandler;
import de.elpro.ewms.gui.utils.e4.EOSPartUtils;
import de.elpro.ui.fx.controls.tree.LazyTreeItem;
import de.elpro.ui.model.UIModelElement;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Function;
import javafx.scene.control.TreeItem;
import javax.inject.Inject;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.workbench.modeling.EModelService;
import org.eclipse.fx.core.log.Log;
import org.eclipse.fx.core.log.Logger;

public class CreateNaviTreeHandler
extends LazyNavigationContribution<UIModelElement> {
    @Inject
    @Log
    private Logger logger;
    @Inject
    private MApplication app;
    @Inject
    private EModelService modelService;
    private Function<TreeItem<UIModelElement>, List<TreeItem<UIModelElement>>> LIST_CREATOR = new Function<TreeItem<UIModelElement>, List<TreeItem<UIModelElement>>>(){

        @Override
        public List<TreeItem<UIModelElement>> apply(TreeItem<UIModelElement> item) {
            LinkedList<TreeItem<UIModelElement>> elements = new LinkedList<TreeItem<UIModelElement>>();
            Transaction trx = Transactions.begin();
            try {
                if (item.getValue() == null || item.getValue() instanceof INavigationTreeElement) {
                    StructureClass structureClass;
                    TreeMultimap classCharacteristics = TreeMultimap.create();
                    Characteristic2D[] characteristic2DArray = Characteristic2DDAO.getAll((Transaction)trx);
                    int n = characteristic2DArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Characteristic2D c2d = characteristic2DArray[n2];
                        structureClass = c2d.getStructureClass();
                        if (!classCharacteristics.containsKey((Object)structureClass)) {
                            structureClass = StructureClassDAO.get((Transaction)trx, (int)structureClass.getId());
                        }
                        classCharacteristics.put((Object)structureClass, (Object)c2d);
                        ++n2;
                    }
                    characteristic2DArray = Characteristic3DDAO.getAll((Transaction)trx);
                    n = characteristic2DArray.length;
                    n2 = 0;
                    while (n2 < n) {
                        Characteristic2D c3d = characteristic2DArray[n2];
                        structureClass = c3d.getStructureClass();
                        if (!classCharacteristics.containsKey((Object)structureClass)) {
                            structureClass = StructureClassDAO.get((Transaction)trx, (int)structureClass.getId());
                        }
                        classCharacteristics.put((Object)structureClass, (Object)c3d);
                        ++n2;
                    }
                    for (StructureClass structureClass2 : classCharacteristics.keySet()) {
                        LinkedList<LazyTreeItem<UIModelElement>> characteristicsTreeItems = new LinkedList<LazyTreeItem<UIModelElement>>();
                        for (UIModelElement c2dOr3d : classCharacteristics.get((Object)structureClass2)) {
                            characteristicsTreeItems.add(CreateNaviTreeHandler.this.createLazyTreeItem(c2dOr3d));
                        }
                        elements.add((TreeItem<UIModelElement>)new LazyTreeItem((Object)structureClass2, characteristicsTreeItems, CreateNaviTreeHandler.this.LIST_CREATOR));
                    }
                } else if (item.getValue() instanceof StructureClass) {
                    StructureClass structureClass = (StructureClass)item.getValue();
                    elements.addAll(CreateNaviTreeHandler.this.createLazyTreeItemCollection((UIModelElement[])Characteristic2DDAO.getByClass((Transaction)trx, (StructureClass)structureClass)));
                    elements.addAll(CreateNaviTreeHandler.this.createLazyTreeItemCollection((UIModelElement[])Characteristic3DDAO.getByClass((Transaction)trx, (StructureClass)structureClass)));
                    if (!structureClass.isEnabled() && !elements.isEmpty()) {
                        structureClass.setEnabled(true);
                        item.setValue(null);
                        item.setValue((Object)structureClass);
                    }
                } else if (item.getValue() instanceof Characteristic2D) {
                    Characteristic2D c2d = (Characteristic2D)item.getValue();
                    Characteristic2DInstance[] c2dInstances = Characteristic2DInstanceDAO.getAll((Transaction)trx, (Characteristic2D)c2d);
                    StructureObject[] c2dInstanceObjects = StructureObjectDAO.get((Transaction)trx, (int[])Arrays.stream(c2dInstances).mapToInt(i -> i.getStructureObject().getId()).toArray());
                    int i2 = 0;
                    while (i2 < c2dInstances.length) {
                        Characteristic2DInstance instance = c2dInstances[i2];
                        instance.setStructureObject(c2dInstanceObjects[i2]);
                        instance.setBuildTextLabelCallback(o -> {
                            if (instance.getStructureObject().getKey() != null && !instance.getStructureObject().getKey().isBlank()) {
                                return String.format("%s [key: %s]", instance.getStructureObject(), instance.getStructureObject().getKey());
                            }
                            return instance.getStructureObject().toString();
                        });
                        ++i2;
                    }
                    elements.addAll(CreateNaviTreeHandler.this.createTreeItemCollection((UIModelElement[])c2dInstances));
                } else if (item.getValue() instanceof Characteristic3D) {
                    Characteristic3D c3d = (Characteristic3D)item.getValue();
                    Characteristic3DInstance[] c3dInstances = Characteristic3DInstanceDAO.getAll((Transaction)trx, (Characteristic3D)c3d);
                    StructureObject[] c3dInstanceObjects = StructureObjectDAO.get((Transaction)trx, (int[])Arrays.stream(c3dInstances).mapToInt(i -> i.getStructureObject().getId()).toArray());
                    int i3 = 0;
                    while (i3 < c3dInstances.length) {
                        Characteristic3DInstance instance = c3dInstances[i3];
                        instance.setStructureObject(c3dInstanceObjects[i3]);
                        instance.setBuildTextLabelCallback(o -> {
                            if (instance.getStructureObject().getKey() != null && !instance.getStructureObject().getKey().isBlank()) {
                                return String.format("%s [key: %s]", instance.getStructureObject(), instance.getStructureObject().getKey());
                            }
                            return instance.getStructureObject().toString();
                        });
                        ++i3;
                    }
                    elements.addAll(CreateNaviTreeHandler.this.createTreeItemCollection((UIModelElement[])c3dInstances));
                }
            }
            finally {
                Transactions.close((Transaction)trx);
            }
            return elements;
        }
    };

    @Execute
    public void execute() {
    }

    @Override
    public String getContextMenuId() {
        return "de.elpro.ewms.engin.gui.menu.navi.characteristics";
    }

    @Override
    public void onTreeItemClick(Object sender, TreeItem<UIModelElement> treeItem) {
        new CharacteristicsEditHandler().execute(this.app, treeItem);
    }

    @Override
    public void onTreeItemDoubleClick(Object sender, TreeItem<UIModelElement> treeItem) {
        EOSPartUtils.pinSelectedMPart((EModelService)this.modelService, (MApplication)this.app, (String)"de.elpro.ewms.engin.gui.partstack.editors");
    }

    @Override
    public Function<TreeItem<UIModelElement>, List<TreeItem<UIModelElement>>> getChildrenCreator() {
        return this.LIST_CREATOR;
    }

    @Override
    public boolean canDragItem(UIModelElement item) {
        return item instanceof Characteristic2D || item instanceof Characteristic2DInstance || item instanceof Characteristic3D || item instanceof Characteristic3DInstance;
    }
}

