/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.engin.gui.navi.server.characteristics.parts;

import de.elpro.ewms.core.characteristic.Characteristic2D;
import de.elpro.ewms.core.characteristic.Characteristic2DRole;
import de.elpro.ewms.core.client.Transactions;
import de.elpro.ewms.core.client.characteristic.Characteristic2DDAO;
import de.elpro.ewms.core.client.characteristic.Characteristic2DRoleDAO;
import de.elpro.ewms.core.client.structure.StructureClassDAO;
import de.elpro.ewms.core.client.variable.LocationDAO;
import de.elpro.ewms.core.client.variable.MediumDAO;
import de.elpro.ewms.core.client.variable.SpecializationDAO;
import de.elpro.ewms.core.client.variable.ValuesBoundsDAO;
import de.elpro.ewms.core.db.DAOOperationException;
import de.elpro.ewms.core.db.Transaction;
import de.elpro.ewms.core.structure.StructureClass;
import de.elpro.ewms.core.units.PhysicalUnit;
import de.elpro.ewms.core.units.PhysicalUnitRegistry;
import de.elpro.ewms.core.variable.Location;
import de.elpro.ewms.core.variable.Medium;
import de.elpro.ewms.core.variable.Specialization;
import de.elpro.ewms.core.variable.ValuesBounds;
import de.elpro.ewms.engin.gui.services.EnginPartUtils;
import de.elpro.ui.controlsfx.propertysheet.SeparatorItem;
import de.elpro.ui.di.Refresh;
import de.elpro.ui.fx.propertysheet.ChoicePropertyItem;
import de.elpro.ui.fx.propertysheet.IntegerPropertyItem;
import de.elpro.ui.fx.propertysheet.MultChoicesPropertyItem;
import de.elpro.ui.fx.propertysheet.NumberPropertyItem;
import de.elpro.ui.fx.propertysheet.PropertyItemsHelper;
import de.elpro.ui.fx.propertysheet.StringPropertyItem;
import de.elpro.ui.fx.validator.Validators;
import de.elpro.ui.utils.e4.PartUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.layout.BorderPane;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import org.controlsfx.control.PropertySheet;
import org.controlsfx.dialog.ExceptionDialog;
import org.eclipse.e4.ui.di.Persist;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.workbench.modeling.EPartService;

public class Characteristic2DEditPart {
    public static final String ID = "de.elpro.ewms.engin.gui.partdescriptor.characteristics.c2deditpart";
    @Inject
    private Characteristic2D characteristic;
    @Inject
    private MPart part;
    @Inject
    private EPartService partService;
    private final ObservableList<Location> locations = FXCollections.observableArrayList();
    private final ObservableList<Medium> mediums = FXCollections.observableArrayList();
    private final ObservableList<Specialization> specializations = FXCollections.observableArrayList();
    private final ObservableList<ValuesBounds> inputValuesBounds = FXCollections.observableArrayList();
    private final ObservableList<ValuesBounds> outputValuesBounds = FXCollections.observableArrayList();
    private final ObservableList<Characteristic2DRole> roles = FXCollections.observableArrayList();
    private final PropertySheet sheet = new PropertySheet();
    private final SimpleBooleanProperty hasChanges = new SimpleBooleanProperty(false);
    private final SimpleBooleanProperty hasErrors = new SimpleBooleanProperty(false);
    private NumberPropertyItem<Integer> idItem;

    @PostConstruct
    public void postConstruct(BorderPane parent) {
        LinkedList<StructureClass> structureClasses = new LinkedList<StructureClass>();
        Transaction trx = Transactions.begin();
        try {
            if (this.characteristic.getId() != null) {
                this.characteristic = Characteristic2DDAO.get((Transaction)trx, (int)this.characteristic.getId());
            }
            if (this.characteristic.getStructureClass() != null) {
                this.characteristic.setStructureClass(StructureClassDAO.get((Transaction)trx, (int)this.characteristic.getStructureClass().getId()));
                structureClasses.add(this.characteristic.getStructureClass());
            } else {
                Collections.addAll(structureClasses, StructureClassDAO.getAll((Transaction)trx));
            }
            this.loadChoises(trx);
            if (this.characteristic.getInputValuesBounds() != null) {
                this.characteristic.setInputValuesBounds(ValuesBoundsDAO.get((Transaction)trx, (int)this.characteristic.getInputValuesBounds().getId()));
            }
            if (this.characteristic.getOutputValuesBounds() != null) {
                this.characteristic.setOutputValuesBounds(ValuesBoundsDAO.get((Transaction)trx, (int)this.characteristic.getOutputValuesBounds().getId()));
            }
        }
        finally {
            Transactions.close((Transaction)trx);
        }
        this.idItem = new IntegerPropertyItem("Id", (ObservableValue)this.characteristic.idProperty());
        this.idItem.setReadOnly(true);
        StringPropertyItem keyItem = new StringPropertyItem("key", (ObservableValue)this.characteristic.keyProperty());
        ChoicePropertyItem structureClassItem = new ChoicePropertyItem("Structure Class", (ObservableValue)this.characteristic.structureClassProperty(), structureClasses);
        structureClassItem.setNullable(false);
        structureClassItem.setReadOnly(this.characteristic.getStructureClass() != null);
        structureClassItem.setValidator(Validators.createNotEmptyValidator((String)"Structure Class must be not empty"));
        ChoicePropertyItem locationItem = new ChoicePropertyItem("Location", (ObservableValue)this.characteristic.locationProperty(), this.locations);
        ChoicePropertyItem mediumItem = new ChoicePropertyItem("Medium", (ObservableValue)this.characteristic.mediumProperty(), this.mediums);
        mediumItem.setNullable(false);
        mediumItem.setValidator(Validators.createNotEmptyValidator((String)"Medium must be not empty"));
        ChoicePropertyItem inputPhysicalUnitItem = new ChoicePropertyItem("Input\tPhysical Unit", (ObservableValue)this.characteristic.inputPhysicalUnitProperty(), PhysicalUnitRegistry.getPhysicalUnits());
        inputPhysicalUnitItem.setNullable(false);
        inputPhysicalUnitItem.setValidator(Validators.createNotEmptyValidator((String)"Physical Unit must be not empty"));
        Collection availableInputUnits = new ArrayList();
        if (this.characteristic.getInputPhysicalUnit() != null) {
            availableInputUnits = this.characteristic.getInputPhysicalUnit().getMeasuringUnits();
        }
        ChoicePropertyItem inputMeasuringUnitItem = new ChoicePropertyItem("\t\tMeasuring Unit", (ObservableValue)this.characteristic.inputMeasuringUnitProperty(), availableInputUnits);
        inputMeasuringUnitItem.setNullable(false);
        inputMeasuringUnitItem.setValidator(Validators.createNotEmptyValidator((String)"Measuring Unit must be not empty"));
        ChoicePropertyItem inputValuesBoundsItem = new ChoicePropertyItem("\t\tValues Bounds", (ObservableValue)this.characteristic.inputValuesBoundsProperty(), this.inputValuesBounds);
        ChoicePropertyItem outputPhysicalUnitItem = new ChoicePropertyItem("Output\tPhysical Unit", (ObservableValue)this.characteristic.outputPhysicalUnitProperty(), PhysicalUnitRegistry.getPhysicalUnits());
        outputPhysicalUnitItem.setNullable(false);
        outputPhysicalUnitItem.setValidator(Validators.createNotEmptyValidator((String)"Physical Unit must be not empty"));
        Collection availableOutputUnits = new ArrayList();
        if (this.characteristic.getOutputPhysicalUnit() != null) {
            availableOutputUnits = this.characteristic.getOutputPhysicalUnit().getMeasuringUnits();
        }
        ChoicePropertyItem outputMeasuringUnitItem = new ChoicePropertyItem("\t\tMeasuring Unit", (ObservableValue)this.characteristic.outputMeasuringUnitProperty(), availableOutputUnits);
        outputMeasuringUnitItem.setNullable(false);
        outputMeasuringUnitItem.setValidator(Validators.createNotEmptyValidator((String)"Measuring Unit must be not empty"));
        ChoicePropertyItem outputValuesBoundsItem = new ChoicePropertyItem("\t\tValues Bounds", (ObservableValue)this.characteristic.outputValuesBoundsProperty(), this.outputValuesBounds);
        ChoicePropertyItem specItem = new ChoicePropertyItem("Specialization\t1.", (ObservableValue)this.characteristic.specializationProperty(), this.specializations);
        ChoicePropertyItem spec2Item = new ChoicePropertyItem("\t\t\t2.", (ObservableValue)this.characteristic.specialization2Property(), this.specializations);
        ObservableList selectedRoles = FXCollections.observableArrayList();
        for (String roleId : this.characteristic.getRoleIds()) {
            selectedRoles.add((Object)Characteristic2DRoleDAO.get((String)roleId));
        }
        selectedRoles.addListener(il -> {
            this.characteristic.getRoleIds().clear();
            selectedRoles.forEach(r -> {
                boolean bl = this.characteristic.getRoleIds().add(r.getId());
            });
        });
        MultChoicesPropertyItem rolesItem = new MultChoicesPropertyItem("Roles", (Collection)selectedRoles, this.roles);
        StringPropertyItem descriptionItem = new StringPropertyItem("Description", (ObservableValue)this.characteristic.descriptionProperty());
        descriptionItem.useAreaEditor(true);
        this.characteristic.inputPhysicalUnitProperty().addListener((o, ov, nv) -> {
            inputMeasuringUnitItem.setChoices(nv == null ? new ArrayList() : new ArrayList(nv.getMeasuringUnits()));
            this.updateInputValuesBounds();
            Transaction t = Transactions.begin();
            try {
                this.loadRoles(t);
                rolesItem.setChoises(this.roles);
            }
            finally {
                Transactions.close((Transaction)t);
            }
        });
        this.characteristic.outputPhysicalUnitProperty().addListener((o, ov, nv) -> {
            outputMeasuringUnitItem.setChoices(nv == null ? new ArrayList() : new ArrayList(nv.getMeasuringUnits()));
            this.updateOutputValuesBounds();
            Transaction t = Transactions.begin();
            try {
                this.loadRoles(t);
                rolesItem.setChoises(this.roles);
            }
            finally {
                Transactions.close((Transaction)t);
            }
        });
        this.sheet.getItems().addAll((Object[])new PropertySheet.Item[]{this.idItem, keyItem, structureClassItem, locationItem, mediumItem, new SeparatorItem(), inputPhysicalUnitItem, inputMeasuringUnitItem, inputValuesBoundsItem, new SeparatorItem(), outputPhysicalUnitItem, outputMeasuringUnitItem, outputValuesBoundsItem, new SeparatorItem(), specItem, spec2Item, new SeparatorItem(), rolesItem, new SeparatorItem(), descriptionItem});
        this.hasChanges.bind((ObservableValue)PropertyItemsHelper.createHasChangesProperty((Collection)this.sheet.getItems()));
        this.hasErrors.bind((ObservableValue)PropertyItemsHelper.createHasErrorsProperty((Collection)this.sheet.getItems()));
        this.hasChanges.addListener((o, ov, nv) -> this.part.setDirty(nv != false || this.idItem.getValue() == null));
        this.part.setLabel(String.format("Characteristic2D: %s", this.characteristic.toString()));
        parent.setCenter((Node)this.sheet);
    }

    private void loadRoles(Transaction trx) {
        if (this.characteristic.getInputPhysicalUnit() != null && this.characteristic.getOutputPhysicalUnit() != null) {
            this.roles.setAll((Object[])Characteristic2DRoleDAO.getAll((Transaction)trx, (StructureClass)this.characteristic.getStructureClass(), (PhysicalUnit)this.characteristic.getInputPhysicalUnit(), (PhysicalUnit)this.characteristic.getOutputPhysicalUnit()));
        } else {
            this.roles.clear();
        }
    }

    private void loadChoises(Transaction trx) {
        this.locations.setAll((Object[])LocationDAO.getAll((Transaction)trx));
        this.mediums.setAll((Object[])MediumDAO.getAll((Transaction)trx));
        this.specializations.setAll((Object[])SpecializationDAO.getAll((Transaction)trx));
        if (this.characteristic.getInputPhysicalUnit() != null) {
            this.inputValuesBounds.setAll((Object[])ValuesBoundsDAO.getAll((Transaction)trx, (PhysicalUnit)this.characteristic.getInputPhysicalUnit()));
        } else {
            this.inputValuesBounds.clear();
        }
        if (this.characteristic.getOutputPhysicalUnit() != null) {
            this.outputValuesBounds.setAll((Object[])ValuesBoundsDAO.getAll((Transaction)trx, (PhysicalUnit)this.characteristic.getOutputPhysicalUnit()));
        } else {
            this.outputValuesBounds.clear();
        }
        this.loadRoles(trx);
    }

    @Refresh(refreshClasses={Location.class})
    public void updateLocations() {
        Transaction trx = Transactions.begin();
        try {
            this.locations.setAll((Object[])LocationDAO.getAll((Transaction)trx));
        }
        finally {
            Transactions.close((Transaction)trx);
        }
    }

    @Refresh(refreshClasses={Medium.class})
    public void updateMediums() {
        Transaction trx = Transactions.begin();
        try {
            this.mediums.setAll((Object[])MediumDAO.getAll((Transaction)trx));
        }
        finally {
            Transactions.close((Transaction)trx);
        }
    }

    @Refresh(refreshClasses={Specialization.class})
    public void updateSpecialization() {
        Transaction trx = Transactions.begin();
        try {
            this.specializations.setAll((Object[])SpecializationDAO.getAll((Transaction)trx));
        }
        finally {
            Transactions.close((Transaction)trx);
        }
    }

    @Refresh(refreshClasses={ValuesBounds.class})
    public void updateInputValuesBounds() {
        if (this.characteristic.getInputPhysicalUnit() == null) {
            this.inputValuesBounds.clear();
        } else {
            Transaction trx = Transactions.begin();
            try {
                this.inputValuesBounds.setAll((Object[])ValuesBoundsDAO.getAll((Transaction)trx, (PhysicalUnit)this.characteristic.getInputPhysicalUnit()));
            }
            finally {
                Transactions.close((Transaction)trx);
            }
        }
    }

    @Refresh(refreshClasses={ValuesBounds.class})
    public void updateOutputValuesBounds() {
        if (this.characteristic.getOutputPhysicalUnit() == null) {
            this.outputValuesBounds.clear();
        } else {
            Transaction trx = Transactions.begin();
            try {
                this.outputValuesBounds.setAll((Object[])ValuesBoundsDAO.getAll((Transaction)trx, (PhysicalUnit)this.characteristic.getOutputPhysicalUnit()));
            }
            finally {
                Transactions.close((Transaction)trx);
            }
        }
    }

    @Persist
    public void save() {
        if (!this.hasChanges.get() && this.idItem.getValue() != null) {
            return;
        }
        if (this.hasErrors.get()) {
            Alert alert = new Alert(Alert.AlertType.WARNING);
            alert.setContentText(String.format("Cannot save %s. Fix errors first.", this.characteristic.toString()));
            alert.showAndWait();
            return;
        }
        Transaction trx = Transactions.begin();
        try {
            try {
                this.idItem.setValue((Object)Characteristic2DDAO.saveOrUpdate((Transaction)trx, (Characteristic2D)this.characteristic));
                Characteristic2DDAO.createMissingInstances((Transaction)trx, (Characteristic2D)this.characteristic);
                Transactions.commitSync((Transaction)trx);
                PropertyItemsHelper.resetHasChangesProperties((Collection)this.sheet.getItems());
                this.part.setDirty(false);
                this.part.setLabel(String.format("Characteristic2D: %s", this.characteristic.toString()));
                EnginPartUtils.refreshItems(this.characteristic, this.part);
            }
            catch (DAOOperationException exc) {
                Transactions.rollback((Transaction)trx);
                ExceptionDialog dlg = new ExceptionDialog((Throwable)exc);
                dlg.setContentText("Error saving characteristic2d");
                dlg.show();
                Transactions.close((Transaction)trx);
                return;
            }
        }
        finally {
            Transactions.close((Transaction)trx);
        }
        PartUtils.refreshParts((EPartService)this.partService, Characteristic2D.class);
    }

    @PreDestroy
    protected void close() {
        this.part.setDirty(false);
    }
}

