/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.engin.gui.navi.server.characteristics.parts;

import de.elpro.ewms.core.characteristic.Characteristic3D;
import de.elpro.ewms.core.characteristic.Characteristic3DRole;
import de.elpro.ewms.core.client.Transactions;
import de.elpro.ewms.core.client.characteristic.Characteristic3DDAO;
import de.elpro.ewms.core.client.characteristic.Characteristic3DRoleDAO;
import de.elpro.ewms.core.client.structure.StructureClassDAO;
import de.elpro.ewms.core.client.variable.LocationDAO;
import de.elpro.ewms.core.client.variable.MediumDAO;
import de.elpro.ewms.core.client.variable.SpecializationDAO;
import de.elpro.ewms.core.db.DAOOperationException;
import de.elpro.ewms.core.db.Transaction;
import de.elpro.ewms.core.structure.StructureClass;
import de.elpro.ewms.core.units.PhysicalUnit;
import de.elpro.ewms.core.units.PhysicalUnitRegistry;
import de.elpro.ewms.core.variable.Location;
import de.elpro.ewms.core.variable.Medium;
import de.elpro.ewms.core.variable.Specialization;
import de.elpro.ewms.core.variable.ValuesBounds;
import de.elpro.ewms.engin.gui.services.EnginPartUtils;
import de.elpro.ui.controlsfx.propertysheet.SeparatorItem;
import de.elpro.ui.di.Refresh;
import de.elpro.ui.fx.propertysheet.ChoicePropertyItem;
import de.elpro.ui.fx.propertysheet.IntegerPropertyItem;
import de.elpro.ui.fx.propertysheet.MultChoicesPropertyItem;
import de.elpro.ui.fx.propertysheet.NumberPropertyItem;
import de.elpro.ui.fx.propertysheet.PropertyItemsHelper;
import de.elpro.ui.fx.propertysheet.StringPropertyItem;
import de.elpro.ui.fx.validator.Validators;
import de.elpro.ui.utils.e4.PartUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.layout.BorderPane;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import org.controlsfx.control.PropertySheet;
import org.controlsfx.dialog.ExceptionDialog;
import org.eclipse.e4.ui.di.Persist;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.workbench.modeling.EPartService;

public class Characteristic3DEditPart {
    public static final String ID = "de.elpro.ewms.engin.gui.partdescriptor.characteristics.c3deditpart";
    @Inject
    private Characteristic3D characteristic;
    @Inject
    private MPart part;
    @Inject
    private EPartService partService;
    private final ObservableList<Location> locations = FXCollections.observableArrayList();
    private final ObservableList<Medium> mediums = FXCollections.observableArrayList();
    private final ObservableList<Specialization> specializations = FXCollections.observableArrayList();
    private final ObservableList<ValuesBounds> inputValuesBounds = FXCollections.observableArrayList();
    private final ObservableList<ValuesBounds> outputValuesBounds = FXCollections.observableArrayList();
    private final ObservableList<Characteristic3DRole> roles = FXCollections.observableArrayList();
    private final PropertySheet sheet = new PropertySheet();
    private final SimpleBooleanProperty hasChanges = new SimpleBooleanProperty(false);
    private final SimpleBooleanProperty hasErrors = new SimpleBooleanProperty(false);
    private NumberPropertyItem<Integer> idItem;

    @PostConstruct
    public void postConstruct(BorderPane parent) {
        LinkedList<StructureClass> structureClasses = new LinkedList<StructureClass>();
        Transaction trx = Transactions.begin();
        try {
            if (this.characteristic.getId() != null) {
                this.characteristic = Characteristic3DDAO.get((Transaction)trx, (int)this.characteristic.getId());
            }
            if (this.characteristic.getStructureClass() != null) {
                this.characteristic.setStructureClass(StructureClassDAO.get((Transaction)trx, (int)this.characteristic.getStructureClass().getId()));
                structureClasses.add(this.characteristic.getStructureClass());
            } else {
                Collections.addAll(structureClasses, StructureClassDAO.getAll((Transaction)trx));
            }
            this.loadChoises(trx);
        }
        finally {
            Transactions.close((Transaction)trx);
        }
        this.idItem = new IntegerPropertyItem("Id", (ObservableValue)this.characteristic.idProperty());
        this.idItem.setReadOnly(true);
        StringPropertyItem keyItem = new StringPropertyItem("key", (ObservableValue)this.characteristic.keyProperty());
        ChoicePropertyItem structureClassItem = new ChoicePropertyItem("Structure Class", (ObservableValue)this.characteristic.structureClassProperty(), structureClasses);
        structureClassItem.setNullable(false);
        structureClassItem.setReadOnly(this.characteristic.getStructureClass() != null);
        structureClassItem.setValidator(Validators.createNotEmptyValidator((String)"Structure Class must be not empty"));
        ChoicePropertyItem locationItem = new ChoicePropertyItem("Location", (ObservableValue)this.characteristic.locationProperty(), this.locations);
        ChoicePropertyItem mediumItem = new ChoicePropertyItem("Medium", (ObservableValue)this.characteristic.mediumProperty(), this.mediums);
        mediumItem.setNullable(false);
        mediumItem.setValidator(Validators.createNotEmptyValidator((String)"Medium must be not empty"));
        ChoicePropertyItem inputXAxisPhysicalUnitItem = new ChoicePropertyItem("Input X Axis\tPhysical Unit", (ObservableValue)this.characteristic.inputXAxisPhysicalUnitProperty(), PhysicalUnitRegistry.getPhysicalUnits());
        inputXAxisPhysicalUnitItem.setNullable(false);
        inputXAxisPhysicalUnitItem.setValidator(Validators.createNotEmptyValidator((String)"Physical Unit must be not empty"));
        Collection availableMeasuringUnits = new ArrayList();
        if (this.characteristic.getInputXAxisPhysicalUnit() != null) {
            availableMeasuringUnits = this.characteristic.getInputXAxisPhysicalUnit().getMeasuringUnits();
        }
        ChoicePropertyItem inputXAxisMeasuringUnitItem = new ChoicePropertyItem("\t\t\tMeasuring Unit", (ObservableValue)this.characteristic.inputXAxisMeasuringUnitProperty(), availableMeasuringUnits);
        inputXAxisMeasuringUnitItem.setNullable(false);
        inputXAxisMeasuringUnitItem.setValidator(Validators.createNotEmptyValidator((String)"Measuring Unit must be not empty"));
        ChoicePropertyItem inputYAxisPhysicalUnitItem = new ChoicePropertyItem("Input Y Axis\tPhysical Unit", (ObservableValue)this.characteristic.inputYAxisPhysicalUnitProperty(), PhysicalUnitRegistry.getPhysicalUnits());
        inputYAxisPhysicalUnitItem.setNullable(false);
        inputYAxisPhysicalUnitItem.setValidator(Validators.createNotEmptyValidator((String)"Input Z Axis Physical Unit must be not empty"));
        availableMeasuringUnits = new ArrayList();
        if (this.characteristic.getInputYAxisPhysicalUnit() != null) {
            availableMeasuringUnits = this.characteristic.getInputYAxisPhysicalUnit().getMeasuringUnits();
        }
        ChoicePropertyItem inputYAxisMeasuringUnitItem = new ChoicePropertyItem("\t\t\tMeasuring Unit", (ObservableValue)this.characteristic.inputYAxisMeasuringUnitProperty(), availableMeasuringUnits);
        inputYAxisMeasuringUnitItem.setNullable(false);
        inputYAxisMeasuringUnitItem.setValidator(Validators.createNotEmptyValidator((String)"Measuring Unit must be not empty"));
        ChoicePropertyItem outputZAxisPhysicalUnitItem = new ChoicePropertyItem("Output Z Axis\tPhysical Unit", (ObservableValue)this.characteristic.outputZAxisPhysicalUnitProperty(), PhysicalUnitRegistry.getPhysicalUnits());
        outputZAxisPhysicalUnitItem.setNullable(false);
        outputZAxisPhysicalUnitItem.setValidator(Validators.createNotEmptyValidator((String)"Output Z Axis Physical Unit must be not empty"));
        availableMeasuringUnits = new ArrayList();
        if (this.characteristic.getOutputZAxisPhysicalUnit() != null) {
            availableMeasuringUnits = this.characteristic.getOutputZAxisPhysicalUnit().getMeasuringUnits();
        }
        ChoicePropertyItem outputZAxisMeasuringUnitItem = new ChoicePropertyItem("\t\t\tMeasuring Unit", (ObservableValue)this.characteristic.outputZAxisMeasuringUnitProperty(), availableMeasuringUnits);
        outputZAxisMeasuringUnitItem.setNullable(false);
        outputZAxisMeasuringUnitItem.setValidator(Validators.createNotEmptyValidator((String)"Measuring Unit must be not empty"));
        ChoicePropertyItem outputWAxisPhysicalUnitItem = new ChoicePropertyItem("Output W Axis\tPhysical Unit", (ObservableValue)this.characteristic.outputWAxisPhysicalUnitProperty(), PhysicalUnitRegistry.getPhysicalUnits());
        availableMeasuringUnits = new ArrayList();
        if (this.characteristic.getOutputWAxisPhysicalUnit() != null) {
            availableMeasuringUnits = this.characteristic.getOutputWAxisPhysicalUnit().getMeasuringUnits();
        }
        ChoicePropertyItem outputWAxisMeasuringUnitItem = new ChoicePropertyItem("\t\t\tMeasuring Unit", (ObservableValue)this.characteristic.outputWAxisMeasuringUnitProperty(), availableMeasuringUnits);
        ChoicePropertyItem specItem = new ChoicePropertyItem("Specialization\t1.", (ObservableValue)this.characteristic.specializationProperty(), this.specializations);
        ChoicePropertyItem spec2Item = new ChoicePropertyItem("\t\t\t2.", (ObservableValue)this.characteristic.specialization2Property(), this.specializations);
        ObservableList selectedRoles = FXCollections.observableArrayList();
        for (String roleId : this.characteristic.getRoleIds()) {
            selectedRoles.add((Object)Characteristic3DRoleDAO.get((String)roleId));
        }
        selectedRoles.addListener(il -> {
            this.characteristic.getRoleIds().clear();
            selectedRoles.forEach(r -> {
                boolean bl = this.characteristic.getRoleIds().add(r.getId());
            });
        });
        MultChoicesPropertyItem rolesItem = new MultChoicesPropertyItem("Roles", (Collection)selectedRoles, this.roles);
        StringPropertyItem descriptionItem = new StringPropertyItem("Description", (ObservableValue)this.characteristic.descriptionProperty());
        descriptionItem.useAreaEditor(true);
        this.characteristic.inputXAxisPhysicalUnitProperty().addListener((o, ov, nv) -> {
            inputXAxisMeasuringUnitItem.setChoices(nv == null ? new ArrayList() : new ArrayList(nv.getMeasuringUnits()));
            Transaction t = Transactions.begin();
            try {
                this.loadRoles(t);
                rolesItem.setChoises(this.roles);
            }
            finally {
                Transactions.close((Transaction)t);
            }
        });
        this.characteristic.inputYAxisPhysicalUnitProperty().addListener((o, ov, nv) -> {
            inputYAxisMeasuringUnitItem.setChoices(nv == null ? new ArrayList() : new ArrayList(nv.getMeasuringUnits()));
            Transaction t = Transactions.begin();
            try {
                this.loadRoles(t);
                rolesItem.setChoises(this.roles);
            }
            finally {
                Transactions.close((Transaction)t);
            }
        });
        this.characteristic.outputZAxisPhysicalUnitProperty().addListener((o, ov, nv) -> {
            outputZAxisMeasuringUnitItem.setChoices(nv == null ? new ArrayList() : new ArrayList(nv.getMeasuringUnits()));
            Transaction t = Transactions.begin();
            try {
                this.loadRoles(t);
                rolesItem.setChoises(this.roles);
            }
            finally {
                Transactions.close((Transaction)t);
            }
        });
        this.characteristic.outputWAxisPhysicalUnitProperty().addListener((o, ov, nv) -> {
            outputWAxisMeasuringUnitItem.setChoices(nv == null ? new ArrayList() : new ArrayList(nv.getMeasuringUnits()));
            Transaction t = Transactions.begin();
            try {
                this.loadRoles(t);
                rolesItem.setChoises(this.roles);
            }
            finally {
                Transactions.close((Transaction)t);
            }
        });
        this.sheet.getItems().addAll((Object[])new PropertySheet.Item[]{this.idItem, keyItem, structureClassItem, locationItem, mediumItem, new SeparatorItem(), inputXAxisPhysicalUnitItem, inputXAxisMeasuringUnitItem, inputYAxisPhysicalUnitItem, inputYAxisMeasuringUnitItem, new SeparatorItem(), outputZAxisPhysicalUnitItem, outputZAxisMeasuringUnitItem, outputWAxisPhysicalUnitItem, outputWAxisMeasuringUnitItem, new SeparatorItem(), specItem, spec2Item, new SeparatorItem(), rolesItem, new SeparatorItem(), descriptionItem});
        this.hasChanges.bind((ObservableValue)PropertyItemsHelper.createHasChangesProperty((Collection)this.sheet.getItems()));
        this.hasErrors.bind((ObservableValue)PropertyItemsHelper.createHasErrorsProperty((Collection)this.sheet.getItems()));
        this.hasChanges.addListener((o, ov, nv) -> this.part.setDirty(nv != false || this.idItem.getValue() == null));
        this.part.setLabel(String.format("Characteristic3D: %s", this.characteristic.toString()));
        parent.setCenter((Node)this.sheet);
    }

    private void loadRoles(Transaction trx) {
        if (this.characteristic.getInputXAxisPhysicalUnit() != null && this.characteristic.getInputYAxisPhysicalUnit() != null && this.characteristic.getOutputZAxisPhysicalUnit() != null) {
            this.roles.setAll((Object[])Characteristic3DRoleDAO.getAll((Transaction)trx, (StructureClass)this.characteristic.getStructureClass(), (PhysicalUnit)this.characteristic.getInputXAxisPhysicalUnit(), (PhysicalUnit)this.characteristic.getInputYAxisPhysicalUnit(), (PhysicalUnit)this.characteristic.getOutputZAxisPhysicalUnit(), (PhysicalUnit)this.characteristic.getOutputWAxisPhysicalUnit()));
        } else {
            this.roles.clear();
        }
    }

    private void loadChoises(Transaction trx) {
        this.locations.setAll((Object[])LocationDAO.getAll((Transaction)trx));
        this.mediums.setAll((Object[])MediumDAO.getAll((Transaction)trx));
        this.specializations.setAll((Object[])SpecializationDAO.getAll((Transaction)trx));
        this.loadRoles(trx);
    }

    @Refresh(refreshClasses={Location.class})
    public void updateLocations() {
        Transaction trx = Transactions.begin();
        try {
            this.locations.setAll((Object[])LocationDAO.getAll((Transaction)trx));
        }
        finally {
            Transactions.close((Transaction)trx);
        }
    }

    @Refresh(refreshClasses={Medium.class})
    public void updateMediums() {
        Transaction trx = Transactions.begin();
        try {
            this.mediums.setAll((Object[])MediumDAO.getAll((Transaction)trx));
        }
        finally {
            Transactions.close((Transaction)trx);
        }
    }

    @Refresh(refreshClasses={Specialization.class})
    public void updateSpecialization() {
        Transaction trx = Transactions.begin();
        try {
            this.specializations.setAll((Object[])SpecializationDAO.getAll((Transaction)trx));
        }
        finally {
            Transactions.close((Transaction)trx);
        }
    }

    @Persist
    public void save() {
        if (!this.hasChanges.get() && this.idItem.getValue() != null) {
            return;
        }
        if (this.hasErrors.get()) {
            Alert alert = new Alert(Alert.AlertType.WARNING);
            alert.setContentText(String.format("Cannot save %s. Fix errors first.", this.characteristic.toString()));
            alert.showAndWait();
            return;
        }
        Transaction trx = Transactions.begin();
        try {
            try {
                this.idItem.setValue((Object)Characteristic3DDAO.saveOrUpdate((Transaction)trx, (Characteristic3D)this.characteristic));
                Characteristic3DDAO.createMissingInstances((Transaction)trx, (Characteristic3D)this.characteristic);
                Transactions.commitSync((Transaction)trx);
                PropertyItemsHelper.resetHasChangesProperties((Collection)this.sheet.getItems());
                this.part.setDirty(false);
                this.part.setLabel(String.format("Characteristic3D: %s", this.characteristic.toString()));
                EnginPartUtils.refreshItems(this.characteristic, this.part);
            }
            catch (DAOOperationException exc) {
                Transactions.rollback((Transaction)trx);
                ExceptionDialog dlg = new ExceptionDialog((Throwable)exc);
                dlg.setContentText("Error saving characteristic3d");
                dlg.show();
                Transactions.close((Transaction)trx);
                return;
            }
        }
        finally {
            Transactions.close((Transaction)trx);
        }
        PartUtils.refreshParts((EPartService)this.partService, Characteristic3D.class);
    }

    @PreDestroy
    protected void close() {
        this.part.setDirty(false);
    }
}

