/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.engin.gui.navi.server.characteristics.parts;

import de.elpro.ewms.core.characteristic.Characteristic3DInstance;
import de.elpro.ewms.core.client.Transactions;
import de.elpro.ewms.core.client.characteristic.Characteristic3DDAO;
import de.elpro.ewms.core.client.characteristic.Characteristic3DInstanceDAO;
import de.elpro.ewms.core.client.structure.StructureObjectDAO;
import de.elpro.ewms.core.db.DAOOperationException;
import de.elpro.ewms.core.db.Transaction;
import de.elpro.ewms.engin.gui.services.EnginPartUtils;
import de.elpro.ui.fx.propertysheet.ChoicePropertyItem;
import de.elpro.ui.fx.propertysheet.IntegerPropertyItem;
import de.elpro.ui.fx.propertysheet.NumberPropertyItem;
import de.elpro.ui.fx.propertysheet.PropertyItemsHelper;
import de.elpro.ui.fx.propertysheet.StringPropertyItem;
import de.elpro.ui.utils.e4.PartUtils;
import java.util.Collection;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ObservableValue;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.layout.BorderPane;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import org.controlsfx.control.PropertySheet;
import org.controlsfx.dialog.ExceptionDialog;
import org.eclipse.e4.ui.di.Persist;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.workbench.modeling.EPartService;

public class Characteristic3DInstanceEditPart {
    public static final String ID = "de.elpro.ewms.engin.gui.partdescriptor.characteristics.c3dieditpart";
    @Inject
    private Characteristic3DInstance characteristicInstance;
    @Inject
    private MPart part;
    @Inject
    private EPartService partService;
    private final PropertySheet sheet = new PropertySheet();
    private final SimpleBooleanProperty hasChanges = new SimpleBooleanProperty(false);
    private final SimpleBooleanProperty hasErrors = new SimpleBooleanProperty(false);
    private NumberPropertyItem<Integer> idItem;
    private final StringProperty functionsJson = new SimpleStringProperty();

    @PostConstruct
    public void postConstruct(BorderPane parent) {
        Transaction trx = Transactions.begin();
        try {
            if (this.characteristicInstance.getId() != null) {
                this.characteristicInstance = Characteristic3DInstanceDAO.get((Transaction)trx, (int)this.characteristicInstance.getId());
            }
            this.characteristicInstance.setCharacteristic(Characteristic3DDAO.get((Transaction)trx, (int)this.characteristicInstance.getCharacteristic().getId()));
            this.characteristicInstance.setStructureObject(StructureObjectDAO.get((Transaction)trx, (int)this.characteristicInstance.getStructureObject().getId()));
            this.functionsJson.set((Object)this.characteristicInstance.getFunctionsSerialized());
        }
        finally {
            Transactions.close((Transaction)trx);
        }
        this.idItem = new IntegerPropertyItem("Id", (ObservableValue)this.characteristicInstance.idProperty());
        this.idItem.setReadOnly(true);
        ChoicePropertyItem c2dItem = new ChoicePropertyItem("Characteristic", (ObservableValue)this.characteristicInstance.characteristicProperty());
        ChoicePropertyItem objectItem = new ChoicePropertyItem("Structure Object", (ObservableValue)this.characteristicInstance.structureObjectProperty());
        StringPropertyItem characteristicJsonDefinitionItem = new StringPropertyItem("Json Definition", (ObservableValue)this.functionsJson);
        characteristicJsonDefinitionItem.useAreaEditor(true);
        this.functionsJson.addListener((o, ov, nv) -> this.characteristicInstance.setFunctionsSerialized(nv));
        this.sheet.getItems().addAll((Object[])new PropertySheet.Item[]{this.idItem, c2dItem, objectItem, characteristicJsonDefinitionItem});
        this.hasChanges.bind((ObservableValue)PropertyItemsHelper.createHasChangesProperty((Collection)this.sheet.getItems()));
        this.hasErrors.bind((ObservableValue)PropertyItemsHelper.createHasErrorsProperty((Collection)this.sheet.getItems()));
        this.hasChanges.addListener((o, ov, nv) -> this.part.setDirty(nv != false || this.idItem.getValue() == null));
        this.part.setLabel(String.format("Characteristic3D Instance: %s", this.characteristicInstance.toString()));
        parent.setCenter((Node)this.sheet);
    }

    @Persist
    public void save() {
        if (!this.hasChanges.get() && this.idItem.getValue() != null) {
            return;
        }
        if (this.hasErrors.get()) {
            Alert alert = new Alert(Alert.AlertType.WARNING);
            alert.setContentText(String.format("Cannot save %s. Fix errors first.", this.characteristicInstance.toString()));
            alert.showAndWait();
            return;
        }
        Transaction trx = Transactions.begin();
        try {
            try {
                this.idItem.setValue((Object)Characteristic3DInstanceDAO.saveOrUpdate((Transaction)trx, (Characteristic3DInstance)this.characteristicInstance));
                Transactions.commitSync((Transaction)trx);
                PropertyItemsHelper.resetHasChangesProperties((Collection)this.sheet.getItems());
                this.part.setDirty(false);
                this.part.setLabel(String.format("Characteristic3D Instance: %s", this.characteristicInstance.toString()));
                EnginPartUtils.refreshItems(this.characteristicInstance, this.part);
            }
            catch (DAOOperationException exc) {
                Transactions.rollback((Transaction)trx);
                ExceptionDialog dlg = new ExceptionDialog((Throwable)exc);
                dlg.setContentText("Error saving characteristic3d instance");
                dlg.show();
                Transactions.close((Transaction)trx);
                return;
            }
        }
        finally {
            Transactions.close((Transaction)trx);
        }
        PartUtils.refreshParts((EPartService)this.partService, Characteristic3DInstance.class);
    }

    @PreDestroy
    protected void close() {
        this.part.setDirty(false);
    }
}

