/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.engin.gui.navi.server.classes.handlers;

import de.elpro.ewms.core.client.Transactions;
import de.elpro.ewms.core.client.structure.PropertyDAO;
import de.elpro.ewms.core.client.structure.PropertyGroupDAO;
import de.elpro.ewms.core.client.structure.StructureClassDAO;
import de.elpro.ewms.core.db.Transaction;
import de.elpro.ewms.core.structure.Property;
import de.elpro.ewms.core.structure.PropertyGroup;
import de.elpro.ewms.core.structure.StructureClass;
import de.elpro.ewms.core.variable.Variable;
import de.elpro.ewms.engin.gui.navi.model.INavigationTreeElement;
import de.elpro.ewms.engin.gui.navi.model.LazyNavigationContribution;
import de.elpro.ewms.engin.gui.navi.server.classes.handlers.StructureClassEditHandler;
import de.elpro.ewms.gui.utils.e4.EOSPartUtils;
import de.elpro.resources.Resources;
import de.elpro.ui.model.UIModelElement;
import java.net.URL;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Function;
import javafx.scene.control.TreeItem;
import javax.inject.Inject;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.workbench.modeling.EModelService;

public class CreateClassesTreeHandler
extends LazyNavigationContribution<UIModelElement> {
    @Inject
    private MApplication app;
    @Inject
    private EModelService modelService;
    private Function<TreeItem<UIModelElement>, List<TreeItem<UIModelElement>>> LIST_CREATOR = new Function<TreeItem<UIModelElement>, List<TreeItem<UIModelElement>>>(){

        @Override
        public List<TreeItem<UIModelElement>> apply(TreeItem<UIModelElement> item) {
            LinkedList<TreeItem<UIModelElement>> elements = new LinkedList<TreeItem<UIModelElement>>();
            Transaction trx = Transactions.begin();
            try {
                if (item.getValue() == null || item.getValue() instanceof INavigationTreeElement) {
                    StructureClass[] structureClassArray = StructureClassDAO.getAll((Transaction)trx);
                    int n = structureClassArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        StructureClass structureClass = structureClassArray[n2];
                        TreeItem structureClassTreeItem = new TreeItem((Object)structureClass);
                        structureClassTreeItem.getChildren().add(CreateClassesTreeHandler.this.createLazyTreeItem(new ObjectsFolder(structureClass)));
                        structureClassTreeItem.getChildren().add(CreateClassesTreeHandler.this.createLazyTreeItem(new PropertyGroupFolder(structureClass)));
                        elements.add((TreeItem<UIModelElement>)structureClassTreeItem);
                        ++n2;
                    }
                } else if (item.getValue() instanceof ObjectsFolder) {
                    StructureClass structureClass = ((ObjectsFolder)item.getValue()).getStructureClass();
                    elements.addAll(CreateClassesTreeHandler.this.createTreeItemCollection((UIModelElement[])StructureClassDAO.getAllObjects((Transaction)trx, (StructureClass)structureClass)));
                } else if (item.getValue() instanceof PropertyGroupFolder) {
                    PropertyGroup[] allPgs;
                    StructureClass structureClass = ((PropertyGroupFolder)item.getValue()).getStructureClass();
                    structureClass = StructureClassDAO.get((Transaction)trx, (int)structureClass.getId());
                    PropertyGroup[] propertyGroupArray = allPgs = PropertyGroupDAO.getAllByStructureClass((Transaction)trx, (StructureClass)structureClass);
                    int n = allPgs.length;
                    int n3 = 0;
                    while (n3 < n) {
                        PropertyGroup pg = propertyGroupArray[n3];
                        pg.setEnabled(structureClass.getPropertyGroups().contains(pg));
                        ++n3;
                    }
                    Arrays.sort(allPgs, (pg1, pg2) -> pg1.isEnabled() == pg2.isEnabled() ? pg1.compareTo(pg2) : (pg1.isEnabled() ? -1 : 1));
                    elements.addAll(CreateClassesTreeHandler.this.createLazyTreeItemCollection((UIModelElement[])allPgs));
                } else if (item.getValue() instanceof PropertyGroup) {
                    PropertyGroup pg = (PropertyGroup)item.getValue();
                    elements.addAll(CreateClassesTreeHandler.this.createTreeItemCollection((UIModelElement[])PropertyDAO.get((Transaction)trx, (PropertyGroup)pg)));
                }
            }
            finally {
                Transactions.close((Transaction)trx);
            }
            return elements;
        }
    };

    @Override
    public Function<TreeItem<UIModelElement>, List<TreeItem<UIModelElement>>> getChildrenCreator() {
        return this.LIST_CREATOR;
    }

    @Execute
    public void execute() {
    }

    @Override
    public String getContextMenuId() {
        return "de.elpro.ewms.engin.gui.menu.navi.classes";
    }

    @Override
    public void onTreeItemClick(Object sender, TreeItem<UIModelElement> treeItem) {
        new StructureClassEditHandler().execute(this.app, treeItem);
    }

    @Override
    public void onTreeItemDoubleClick(Object sender, TreeItem<UIModelElement> treeItem) {
        EOSPartUtils.pinSelectedMPart((EModelService)this.modelService, (MApplication)this.app, (String)"de.elpro.ewms.engin.gui.partstack.editors");
    }

    @Override
    public boolean canDragItem(UIModelElement item) {
        return item instanceof Variable || item instanceof Property;
    }

    static class ObjectsFolder
    implements UIModelElement {
        public static final URL DEFAULT_ICON = Resources.getResourceUrl((String)"/icons/16x16/", (String)"eclipse/newpackfolder_wiz.gif");
        private final StructureClass structureClass;

        public ObjectsFolder(StructureClass structureClass) {
            this.structureClass = structureClass;
        }

        public StructureClass getStructureClass() {
            return this.structureClass;
        }

        public String toString() {
            return "Objects";
        }

        public String getIconUri() {
            return DEFAULT_ICON.toString();
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof ObjectsFolder)) {
                return false;
            }
            return this.getStructureClass().equals((Object)((ObjectsFolder)obj).getStructureClass());
        }

        public int hashCode() {
            return ObjectsFolder.class.hashCode() + 17 * this.getStructureClass().hashCode();
        }
    }

    static class PropertyGroupFolder
    implements UIModelElement {
        public static final URL DEFAULT_ICON = Resources.getResourceUrl((String)"/icons/16x16/", (String)"eclipse/pg_category.png");
        private final StructureClass structureClass;

        public PropertyGroupFolder(StructureClass structureClass) {
            this.structureClass = structureClass;
        }

        public StructureClass getStructureClass() {
            return this.structureClass;
        }

        public String toString() {
            return "Properties";
        }

        public String getIconUri() {
            return DEFAULT_ICON.toString();
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof PropertyGroupFolder)) {
                return false;
            }
            return this.getStructureClass().equals((Object)((PropertyGroupFolder)obj).getStructureClass());
        }

        public int hashCode() {
            return PropertyGroupFolder.class.hashCode() + 17 * this.getStructureClass().hashCode();
        }
    }
}

