/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.engin.gui.navi.server.classes.handlers;

import de.elpro.ewms.core.client.structure.PropertyGroupDAO;
import de.elpro.ewms.core.db.Transaction;
import de.elpro.ewms.core.structure.PropertyGroup;
import de.elpro.ewms.engin.gui.services.EnginPartUtils;
import de.elpro.ui.model.UIModelElement;
import de.elpro.ui.utils.e4.PartUtils;
import javafx.scene.Scene;
import javafx.scene.control.TreeItem;
import javax.inject.Inject;
import javax.inject.Named;
import org.eclipse.e4.core.di.annotations.CanExecute;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.fx.core.log.Log;
import org.eclipse.fx.core.log.Logger;

public class PropertyGroupDeleteHandler {
    @Inject
    @Log
    private Logger logger;
    @Inject
    private MApplication app;

    @Execute
    public void execute(Scene scene, @Optional @Named(value="org.eclipse.ui.selection") @Named(value="org.eclipse.ui.selection") TreeItem<? extends UIModelElement> item) {
        if (item.getValue() instanceof PropertyGroup) {
            PropertyGroupDeleteHandler.deletePropertyGroup(this.logger, scene, this.app, item);
        }
    }

    public static void deletePropertyGroup(Logger logger, Scene scene, MApplication app, TreeItem<? extends UIModelElement> item) {
        String dialogContentText = String.format("%d properties und their values will be deleted.\r\nDo you shure you want delete \"%s\"?", ((PropertyGroup)item.getValue()).getProperties().size(), item.getValue());
        EnginPartUtils.showDeleteDialog(dialogContentText, scene.getWindow(), app, item, (trx, pg) -> {
            PropertyGroupDAO.delete((Transaction)trx, (String)((PropertyGroup)pg).getKey());
            return true;
        }, (a, pg) -> PartUtils.closePart((String)"de.elpro.ewms.engin.gui.partdescriptor.propertygroup", (MApplication)app, (Object[])new Object[]{pg}));
    }

    @CanExecute
    public boolean canExecute(@Optional @Named(value="org.eclipse.ui.selection") @Named(value="org.eclipse.ui.selection") TreeItem<?> item) {
        if (item == null) {
            return false;
        }
        return item.getValue() instanceof PropertyGroup;
    }
}

