/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.engin.gui.navi.server.classes.handlers;

import de.elpro.ewms.core.client.structure.StructureClassDAO;
import de.elpro.ewms.core.db.Transaction;
import de.elpro.ewms.core.structure.Property;
import de.elpro.ewms.core.structure.PropertyGroup;
import de.elpro.ewms.core.structure.StructureClass;
import de.elpro.ewms.core.structure.StructureObject;
import de.elpro.ewms.core.variable.Variable;
import de.elpro.ewms.engin.gui.navi.server.classes.handlers.PropertyDeleteHandler;
import de.elpro.ewms.engin.gui.navi.server.classes.handlers.PropertyGroupDeleteHandler;
import de.elpro.ewms.engin.gui.navi.server.objects.handlers.StructureObjectDeleteHandler;
import de.elpro.ewms.engin.gui.navi.server.vai.handlers.VariablesAndInstancesDeleteHandler;
import de.elpro.ewms.engin.gui.services.EnginPartUtils;
import de.elpro.ui.model.UIModelElement;
import de.elpro.ui.utils.e4.PartUtils;
import javafx.scene.Scene;
import javafx.scene.control.TreeItem;
import javax.inject.Inject;
import javax.inject.Named;
import org.eclipse.e4.core.di.annotations.CanExecute;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.fx.core.log.Log;
import org.eclipse.fx.core.log.Logger;

public class StructureClassDeleteHandler {
    @Inject
    @Log
    private Logger logger;
    @Inject
    private MApplication app;

    @Execute
    public void execute(Scene scene, @Optional @Named(value="org.eclipse.ui.selection") @Named(value="org.eclipse.ui.selection") TreeItem<? extends UIModelElement> item) {
        if (item.getValue() instanceof StructureClass) {
            StructureClassDeleteHandler.deleteClass(this.logger, scene, this.app, item);
        } else if (item.getValue() instanceof StructureObject) {
            StructureObjectDeleteHandler.deleteObject(this.logger, scene, this.app, item);
        } else if (item.getValue() instanceof Variable) {
            VariablesAndInstancesDeleteHandler.deleteVariable(this.logger, scene, this.app, item);
        } else if (item.getValue() instanceof PropertyGroup) {
            PropertyGroupDeleteHandler.deletePropertyGroup(this.logger, scene, this.app, item);
        } else if (item.getValue() instanceof Property) {
            PropertyDeleteHandler.deleteProperty(this.logger, scene, this.app, item);
        }
    }

    public static void deleteClass(Logger logger, Scene scene, MApplication app, TreeItem<? extends UIModelElement> item) {
        StructureClass clazz = (StructureClass)item.getValue();
        String dialogContentText = String.format("%d Objects and %d variables of \"%s\" class will be deleted.\r\nDo you shure you want delete \"%s\"?", clazz.getObjects().size(), clazz.getVariables().size(), clazz, clazz);
        EnginPartUtils.showDeleteDialog(dialogContentText, scene.getWindow(), app, item, (trx, c) -> {
            StructureClassDAO.delete((Transaction)trx, (int)clazz.getId());
            return true;
        }, (a, c) -> PartUtils.closePart((String)"de.elpro.ewms.engin.gui.partdescriptor.classeditpart", (MApplication)app, (Object[])new Object[]{clazz}));
    }

    @CanExecute
    public boolean canExecute(@Optional @Named(value="org.eclipse.ui.selection") @Named(value="org.eclipse.ui.selection") TreeItem<?> item) {
        if (item == null) {
            return false;
        }
        if (item.getValue() instanceof StructureClass && ((StructureClass)item.getValue()).getExtendClasses().isEmpty()) {
            return true;
        }
        if (item.getValue() instanceof StructureObject && ((StructureObject)item.getValue()).getChildren().isEmpty()) {
            return true;
        }
        if (item.getValue() instanceof Variable) {
            return true;
        }
        if (item.getValue() instanceof PropertyGroup) {
            return true;
        }
        return item.getValue() instanceof Property;
    }
}

