/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.engin.gui.navi.server.classes.parts;

import de.elpro.ewms.core.charts.ChartGroup;
import de.elpro.ewms.core.client.Transactions;
import de.elpro.ewms.core.client.structure.PropertyDAO;
import de.elpro.ewms.core.client.structure.PropertyGroupDAO;
import de.elpro.ewms.core.db.DAOOperationException;
import de.elpro.ewms.core.db.Transaction;
import de.elpro.ewms.core.structure.IPropertyType;
import de.elpro.ewms.core.structure.PropertyTypes;
import de.elpro.ewms.engin.gui.services.EnginPartUtils;
import de.elpro.ui.fx.propertysheet.BooleanPropertyItem;
import de.elpro.ui.fx.propertysheet.ChoicePropertyItem;
import de.elpro.ui.fx.propertysheet.DynamicEditorPropertyItem;
import de.elpro.ui.fx.propertysheet.IntegerPropertyItem;
import de.elpro.ui.fx.propertysheet.LocaleStringPropertyItem;
import de.elpro.ui.fx.propertysheet.NumberPropertyItem;
import de.elpro.ui.fx.propertysheet.PropertyItemsHelper;
import de.elpro.ui.fx.propertysheet.StringPropertyItem;
import de.elpro.ui.fx.validator.Validators;
import de.elpro.ui.utils.e4.PartUtils;
import java.util.Collection;
import javafx.beans.property.Property;
import javafx.beans.property.ReadOnlyProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableValue;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.layout.BorderPane;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import org.controlsfx.control.PropertySheet;
import org.controlsfx.dialog.ExceptionDialog;
import org.eclipse.e4.ui.di.Persist;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.workbench.modeling.EPartService;

public class ClassPropertyEditPart {
    public static final String ID = "de.elpro.ewms.engin.gui.partdescriptor.classpropertyedit";
    @Inject
    private de.elpro.ewms.core.structure.Property property;
    @Inject
    private MPart part;
    @Inject
    private EPartService partService;
    private final PropertySheet sheet = new PropertySheet();
    private final SimpleBooleanProperty hasChanges = new SimpleBooleanProperty(false);
    private final SimpleBooleanProperty hasErrors = new SimpleBooleanProperty(false);
    private NumberPropertyItem<Integer> idItem;

    @PostConstruct
    public void postConstruct(BorderPane parent) {
        Transaction trx = Transactions.begin();
        try {
            if (this.property.getId() != null) {
                this.property = PropertyDAO.get((Transaction)trx, (Integer)this.property.getId());
            }
            this.property.setGroup(PropertyGroupDAO.get((Transaction)trx, (String)this.property.getGroup().getKey()));
        }
        finally {
            Transactions.close((Transaction)trx);
        }
        this.idItem = new IntegerPropertyItem("Id", (ObservableValue)this.property.idProperty());
        this.idItem.setReadOnly(true);
        ChoicePropertyItem pgItem = new ChoicePropertyItem("Group", (ObservableValue)this.property.groupProperty());
        StringPropertyItem keyItem = new StringPropertyItem("Key", (ObservableValue)this.property.keyProperty());
        keyItem.setValidator(Validators.createNotEmptyValidator((String)"Property key must be not empty and unique for a group"));
        LocaleStringPropertyItem displayNameItem = new LocaleStringPropertyItem("Display Name", (ObservableValue)this.property.nameProperty());
        displayNameItem.setValidator(Validators.createNotEmptyValidator((String)"Display Name must be not empty"));
        Collection types = PropertyTypes.getPropertyTypes();
        SimpleObjectProperty typeProperty = new SimpleObjectProperty();
        for (IPropertyType type : types) {
            if (!type.getId().equals(this.property.getTypeId())) continue;
            typeProperty.set((Object)type);
        }
        typeProperty.addListener((o, ov, nv) -> this.property.setTypeId(nv.getId()));
        ChoicePropertyItem propertyTypeItem = new ChoicePropertyItem("Type", (ObservableValue)typeProperty, types);
        propertyTypeItem.setNullable(false);
        propertyTypeItem.setValidator(Validators.createNotEmptyValidator((String)"Type must be not empty"));
        DynamicEditorPropertyItem parameterItem = new DynamicEditorPropertyItem("Parameter", (ObservableValue)this.property.parameterProperty());
        Node parameterEditor = this.createParameterEditor((IPropertyType)typeProperty.get());
        if (parameterEditor != null) {
            parameterItem.setEditor(parameterEditor, ((IPropertyType)typeProperty.get()).getParameterValidator());
        } else {
            parameterItem.setHidden(true);
        }
        typeProperty.addListener(il -> {
            Node editor = this.createParameterEditor((IPropertyType)typeProperty.get());
            parameterItem.setEditor(editor, ((IPropertyType)typeProperty.get()).getParameterValidator());
            parameterItem.setHidden(editor == null);
        });
        BooleanPropertyItem userVisibleItem = new BooleanPropertyItem("User Visible", (ReadOnlyProperty)this.property.userVisibleProperty());
        BooleanPropertyItem userEditableItem = new BooleanPropertyItem("User Editable", (ReadOnlyProperty)this.property.userEditableProperty());
        userVisibleItem.valueProperty().addListener((o, ov, nv) -> {
            if (!nv.booleanValue()) {
                this.property.setUserEditable(false);
                userEditableItem.setReadOnly(true);
            } else {
                userEditableItem.setReadOnly(false);
            }
        });
        IntegerPropertyItem visualOrderPositionItem = new IntegerPropertyItem("Visual Order Position", (ObservableValue)this.property.visualOrderPositionProperty());
        this.sheet.getItems().addAll((Object[])new PropertySheet.Item[]{this.idItem, pgItem, keyItem, displayNameItem, propertyTypeItem, parameterItem, userVisibleItem, userEditableItem, visualOrderPositionItem});
        this.hasChanges.bind((ObservableValue)PropertyItemsHelper.createHasChangesProperty((Collection)this.sheet.getItems()));
        this.hasErrors.bind((ObservableValue)PropertyItemsHelper.createHasErrorsProperty((Collection)this.sheet.getItems()));
        parent.setCenter((Node)this.sheet);
        this.part.setDirty(this.hasChanges.get());
        this.hasChanges.addListener((o, ov, nv) -> this.part.setDirty(nv.booleanValue()));
    }

    public <P> Node createParameterEditor(IPropertyType<?, P> type) {
        if (type == null) {
            return null;
        }
        Property parameterProperty = type.createParameterProperty((Property)this.property.parameterProperty());
        if (parameterProperty == null) {
            return null;
        }
        return type.createParameterEditor(parameterProperty);
    }

    @Persist
    public void save() {
        if (!this.hasChanges.get()) {
            return;
        }
        if (this.hasErrors.get()) {
            Alert alert = new Alert(Alert.AlertType.WARNING);
            alert.setContentText(String.format("Cannot save %s. Fix errors first.", this.property.toString()));
            alert.showAndWait();
            return;
        }
        Transaction trx = Transactions.begin();
        try {
            try {
                this.idItem.setValue((Object)PropertyDAO.saveOrUpdate((Transaction)trx, (de.elpro.ewms.core.structure.Property)this.property));
                Transactions.commitSync((Transaction)trx);
                PropertyItemsHelper.resetHasChangesProperties((Collection)this.sheet.getItems());
                this.part.setDirty(false);
                this.part.setLabel(this.property.toString());
                EnginPartUtils.refreshItems(this.property, this.part);
            }
            catch (DAOOperationException exc) {
                Transactions.rollback((Transaction)trx);
                ExceptionDialog dlg = new ExceptionDialog((Throwable)exc);
                dlg.setContentText("Error saving class property");
                dlg.show();
                Transactions.close((Transaction)trx);
                return;
            }
        }
        finally {
            Transactions.close((Transaction)trx);
        }
        PartUtils.refreshParts((EPartService)this.partService, ChartGroup.class);
    }

    @PreDestroy
    protected void close() {
        this.part.setDirty(false);
    }
}

