/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.engin.gui.navi.server.classes.parts;

import de.elpro.ewms.core.charts.ChartGroup;
import de.elpro.ewms.core.client.Transactions;
import de.elpro.ewms.core.client.structure.PropertyGroupDAO;
import de.elpro.ewms.core.client.structure.StructureClassDAO;
import de.elpro.ewms.core.db.DAOOperationException;
import de.elpro.ewms.core.db.Transaction;
import de.elpro.ewms.core.structure.PropertyGroup;
import de.elpro.ewms.engin.gui.services.EnginPartUtils;
import de.elpro.ui.fx.propertysheet.ChoicePropertyItem;
import de.elpro.ui.fx.propertysheet.IntegerPropertyItem;
import de.elpro.ui.fx.propertysheet.LocaleStringPropertyItem;
import de.elpro.ui.fx.propertysheet.PropertyItemsHelper;
import de.elpro.ui.fx.propertysheet.StringPropertyItem;
import de.elpro.ui.fx.validator.Validators;
import de.elpro.ui.utils.e4.PartUtils;
import java.util.Collection;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.value.ObservableValue;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.layout.BorderPane;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import org.controlsfx.control.PropertySheet;
import org.controlsfx.dialog.ExceptionDialog;
import org.eclipse.e4.ui.di.Persist;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.workbench.modeling.EPartService;

public class PropertyGroupEditPart {
    public static final String ID = "de.elpro.ewms.engin.gui.partdescriptor.propertygroup";
    @Inject
    private PropertyGroup propertyGroup;
    @Inject
    private MPart part;
    @Inject
    private EPartService partService;
    private final PropertySheet sheet = new PropertySheet();
    private final SimpleBooleanProperty hasChanges = new SimpleBooleanProperty(false);
    private final SimpleBooleanProperty hasErrors = new SimpleBooleanProperty(false);

    @PostConstruct
    public void postConstruct(BorderPane parent) {
        Transaction trx = Transactions.begin();
        try {
            if (this.propertyGroup.getKey() != null) {
                this.propertyGroup = PropertyGroupDAO.get((Transaction)trx, (String)this.propertyGroup.getKey());
            }
            this.propertyGroup.setStructureClass(StructureClassDAO.get((Transaction)trx, (int)this.propertyGroup.getStructureClass().getId()));
        }
        finally {
            Transactions.close((Transaction)trx);
        }
        ChoicePropertyItem structureClassItem = new ChoicePropertyItem("Structure Class", (ObservableValue)this.propertyGroup.structureClassProperty());
        StringPropertyItem keyItem = new StringPropertyItem("Key", (ObservableValue)this.propertyGroup.keyProperty());
        keyItem.setValidator(Validators.createNotEmptyValidator((String)"Property group key must be not empty and unique"));
        LocaleStringPropertyItem displayNameItem = new LocaleStringPropertyItem("Display Name", (ObservableValue)this.propertyGroup.nameProperty());
        displayNameItem.setValidator(Validators.createNotEmptyValidator((String)"Display Name must be not empty"));
        IntegerPropertyItem visualOrderPositionItem = new IntegerPropertyItem("Visual Order Position", (ObservableValue)this.propertyGroup.visualOrderPositionProperty());
        this.sheet.getItems().addAll((Object[])new PropertySheet.Item[]{structureClassItem, keyItem, displayNameItem, visualOrderPositionItem});
        this.hasChanges.bind((ObservableValue)PropertyItemsHelper.createHasChangesProperty((Collection)this.sheet.getItems()));
        this.hasErrors.bind((ObservableValue)PropertyItemsHelper.createHasErrorsProperty((Collection)this.sheet.getItems()));
        parent.setCenter((Node)this.sheet);
        this.hasChanges.addListener((o, ov, nv) -> this.part.setDirty(nv.booleanValue()));
    }

    @Persist
    public void save() {
        if (!this.hasChanges.get()) {
            return;
        }
        if (this.hasErrors.get()) {
            Alert alert = new Alert(Alert.AlertType.WARNING);
            alert.setContentText(String.format("Cannot save %s. Fix errors first.", this.propertyGroup.toString()));
            alert.showAndWait();
            return;
        }
        Transaction trx = Transactions.begin();
        try {
            try {
                PropertyGroupDAO.saveOrUpdate((Transaction)trx, (PropertyGroup)this.propertyGroup);
                Transactions.commitSync((Transaction)trx);
                PropertyItemsHelper.resetHasChangesProperties((Collection)this.sheet.getItems());
                this.part.setDirty(false);
                this.part.setLabel(this.propertyGroup.toString());
                EnginPartUtils.refreshItems(this.propertyGroup, this.part);
            }
            catch (DAOOperationException exc) {
                Transactions.rollback((Transaction)trx);
                ExceptionDialog dlg = new ExceptionDialog((Throwable)exc);
                dlg.setContentText("Error saving property group");
                dlg.show();
                Transactions.close((Transaction)trx);
                return;
            }
        }
        finally {
            Transactions.close((Transaction)trx);
        }
        PartUtils.refreshParts((EPartService)this.partService, ChartGroup.class);
    }

    @PreDestroy
    protected void close() {
        this.part.setDirty(false);
    }
}

