/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.engin.gui.navi.server.classes.parts;

import de.elpro.ewms.core.client.Transactions;
import de.elpro.ewms.core.client.structure.StructureClassDAO;
import de.elpro.ewms.core.client.structure.StructureClassRoleDAO;
import de.elpro.ewms.core.db.Transaction;
import de.elpro.ewms.core.fx.propertysheet.IconKeyPropertyItem;
import de.elpro.ewms.core.structure.IStructureClassRole;
import de.elpro.ewms.core.structure.StructureClass;
import de.elpro.ewms.engin.gui.services.EnginPartUtils;
import de.elpro.ewms.engin.gui.tools.validators.ValidatorUtils;
import de.elpro.ewms.gui.dialogs.DialogFactory;
import de.elpro.ui.fx.propertysheet.IntegerPropertyItem;
import de.elpro.ui.fx.propertysheet.LocaleStringPropertyItem;
import de.elpro.ui.fx.propertysheet.MultChoicesPropertyItem;
import de.elpro.ui.fx.propertysheet.NumberPropertyItem;
import de.elpro.ui.fx.propertysheet.PropertyItemsHelper;
import de.elpro.ui.fx.propertysheet.StringPropertyItem;
import de.elpro.ui.fx.validator.Validators;
import de.elpro.ui.utils.e4.PartUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.Priority;
import javafx.stage.Window;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import jidefx.scene.control.validation.ValidationEvent;
import org.controlsfx.control.PropertySheet;
import org.eclipse.e4.ui.di.Persist;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.workbench.modeling.EPartService;

public class StructureClassEditPart {
    public static final String ID = "de.elpro.ewms.engin.gui.partdescriptor.classeditpart";
    private static final String MAIN_CATEGORY = "Main";
    @Inject
    private StructureClass structureClass;
    @Inject
    private MPart part;
    @Inject
    private EPartService partService;
    private final PropertySheet sheet = new PropertySheet();
    private final SimpleBooleanProperty hasChanges = new SimpleBooleanProperty(false);
    private final SimpleBooleanProperty hasErrors = new SimpleBooleanProperty(false);
    private NumberPropertyItem<Integer> idItem;

    @PostConstruct
    public void postConstruct(BorderPane parent) {
        Transaction trx = Transactions.begin();
        LinkedList<StructureClass> allClasses = new LinkedList<StructureClass>();
        LinkedList<StructureClass> allSuperClasses = new LinkedList<StructureClass>();
        LinkedList<StructureClass> parentClasses = new LinkedList<StructureClass>();
        LinkedList<StructureClass> connectedClasses = new LinkedList<StructureClass>();
        ArrayList<IStructureClassRole> roles = new ArrayList<IStructureClassRole>();
        try {
            if (this.structureClass.getId() != null) {
                this.structureClass = StructureClassDAO.get((Transaction)trx, (int)this.structureClass.getId());
                for (StructureClass parentClass : this.structureClass.getParentClasses()) {
                    parentClasses.add(StructureClassDAO.get((Transaction)trx, (int)parentClass.getId()));
                }
                for (StructureClass connectedClass : this.structureClass.getConnectedClasses()) {
                    connectedClasses.add(StructureClassDAO.get((Transaction)trx, (int)connectedClass.getId()));
                }
                this.structureClass.getParentClasses().clear();
                this.structureClass.getParentClasses().addAll(parentClasses);
                this.structureClass.getConnectedClasses().clear();
                this.structureClass.getConnectedClasses().addAll(connectedClasses);
            }
            StructureClass[] structureClassArray = StructureClassDAO.getAll((Transaction)trx);
            int n = structureClassArray.length;
            int n2 = 0;
            while (n2 < n) {
                StructureClass clazz = structureClassArray[n2];
                allClasses.add(clazz);
                if (this.structureClass.getId() == null || !StructureClassDAO.isSubclass((Transaction)trx, (StructureClass)this.structureClass, (StructureClass)clazz)) {
                    allSuperClasses.add(clazz);
                }
                ++n2;
            }
            roles.addAll(Arrays.asList(StructureClassRoleDAO.getAll()));
        }
        finally {
            Transactions.close((Transaction)trx);
        }
        this.idItem = new IntegerPropertyItem(MAIN_CATEGORY, "Id", (ObservableValue)this.structureClass.idProperty());
        this.idItem.setReadOnly(true);
        LocaleStringPropertyItem displayNameItem = new LocaleStringPropertyItem(MAIN_CATEGORY, "Display Name", (ObservableValue)this.structureClass.nameProperty());
        displayNameItem.setValidator(Validators.createNotEmptyValidator((String)"Display Name cannot be empty"));
        MultChoicesPropertyItem parentClassesItem = new MultChoicesPropertyItem(MAIN_CATEGORY, "Extend Classes", (Collection)this.structureClass.getParentClasses(), allSuperClasses);
        MultChoicesPropertyItem connectedClassesItem = new MultChoicesPropertyItem(MAIN_CATEGORY, "Connected Classes", (Collection)this.structureClass.getConnectedClasses(), allClasses);
        ObservableList selectedRoles = FXCollections.observableArrayList();
        for (IStructureClassRole availableRole : roles) {
            if (!this.structureClass.getRoleIds().contains(availableRole.getId())) continue;
            selectedRoles.add((Object)availableRole);
        }
        MultChoicesPropertyItem rolesItem = new MultChoicesPropertyItem(MAIN_CATEGORY, "Roles", null, (Collection)selectedRoles, roles);
        selectedRoles.addListener(il -> {
            this.structureClass.getRoleIds().clear();
            selectedRoles.forEach(r -> {
                boolean bl = this.structureClass.getRoleIds().add(r.getId());
            });
        });
        StringPropertyItem tokenItem = new StringPropertyItem(MAIN_CATEGORY, "Token", (ObservableValue)this.structureClass.tokenProperty());
        IntegerPropertyItem visualOrderPositionItem = new IntegerPropertyItem(MAIN_CATEGORY, "Visual Order Position", (ObservableValue)this.structureClass.visualOrderPositionProperty());
        tokenItem.setValidator(vo -> {
            if (this.structureClass.getParentClasses().isEmpty()) {
                String token = this.structureClass.getToken();
                if (token == null || token.isEmpty()) {
                    return new ValidationEvent(ValidationEvent.VALIDATION_ERROR, 0, "Token of root classes should not be empty!\r\nProvide not empty text that will be used as abbreviation to this class (in formulas).");
                }
            } else if (this.structureClass.getToken() == null || this.structureClass.getToken().isEmpty()) {
                return ValidationEvent.OK;
            }
            return (ValidationEvent)ValidatorUtils.VAR_NAME_TOKEN_VALIDATOR.call(vo);
        });
        IconKeyPropertyItem iconKeyItem = new IconKeyPropertyItem(MAIN_CATEGORY, "Icon", null, (ObservableValue)this.structureClass.iconKeyProperty(), "ewms/icons/structure/class");
        StringPropertyItem descriptionItem = new StringPropertyItem(MAIN_CATEGORY, "Description", (ObservableValue)this.structureClass.descriptionProperty());
        descriptionItem.useAreaEditor(true);
        descriptionItem.setEditorVgrow(Priority.ALWAYS);
        this.sheet.getItems().addAll((Object[])new PropertySheet.Item[]{this.idItem, displayNameItem, parentClassesItem, connectedClassesItem, rolesItem, tokenItem, visualOrderPositionItem, iconKeyItem, descriptionItem});
        parentClassesItem.valueProperty().addListener(il -> tokenItem.forceValidate());
        this.hasChanges.bind((ObservableValue)PropertyItemsHelper.createHasChangesProperty((Collection)this.sheet.getItems()));
        this.hasErrors.bind((ObservableValue)PropertyItemsHelper.createHasErrorsProperty((Collection)this.sheet.getItems()));
        this.sheet.setMode(PropertySheet.Mode.CATEGORY);
        parent.setCenter((Node)this.sheet);
        this.hasChanges.addListener((o, ov, nv) -> this.part.setDirty(nv.booleanValue()));
        this.part.setLabel(String.format("Class: %s", this.structureClass.toString()));
    }

    @Persist
    public void save() {
        if (!this.hasChanges.get()) {
            return;
        }
        if (this.hasErrors.get()) {
            Alert alert = new Alert(Alert.AlertType.WARNING);
            alert.setContentText(String.format("Cannot save %s. Fix errors first.", this.structureClass.toString()));
            alert.showAndWait();
            return;
        }
        Transaction trx = Transactions.begin();
        try {
            try {
                this.idItem.setValue((Object)StructureClassDAO.saveOrUpdate((Transaction)trx, (StructureClass)this.structureClass));
                Transactions.commitSync((Transaction)trx);
                PropertyItemsHelper.resetHasChangesProperties((Collection)this.sheet.getItems());
                this.part.setDirty(false);
                this.part.setLabel(this.structureClass.toString());
                EnginPartUtils.refreshItems(this.structureClass, this.part);
            }
            catch (Exception exc) {
                Transactions.rollback((Transaction)trx);
                DialogFactory.showExceptionDialog((String)"Save structure class", (Exception)exc, (Window)this.sheet.getScene().getWindow());
                Transactions.close((Transaction)trx);
                return;
            }
        }
        finally {
            Transactions.close((Transaction)trx);
        }
        PartUtils.refreshParts((EPartService)this.partService, StructureClass.class);
        this.part.setLabel(String.format("Class: %s", this.structureClass.toString()));
    }

    @PreDestroy
    protected void close() {
        this.part.setDirty(false);
    }
}

