/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.engin.gui.navi.server.events.handlers;

import de.elpro.ewms.core.client.Transactions;
import de.elpro.ewms.core.client.events.EventActionDAO;
import de.elpro.ewms.core.client.events.EventDAO;
import de.elpro.ewms.core.db.DAOOperationException;
import de.elpro.ewms.core.db.Transaction;
import de.elpro.ewms.core.events.Event;
import de.elpro.ewms.core.events.EventAction;
import de.elpro.ui.utils.e4.PartUtils;
import javafx.scene.Scene;
import javafx.scene.control.Alert;
import javafx.scene.control.ButtonType;
import javafx.scene.control.TreeItem;
import javax.inject.Named;
import org.controlsfx.dialog.ExceptionDialog;
import org.eclipse.e4.core.di.annotations.CanExecute;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.ui.model.application.MApplication;

public class EventDeleteHandler {
    @Execute
    public void execute(MApplication app, @Optional @Named(value="org.eclipse.ui.selection") @Named(value="org.eclipse.ui.selection") TreeItem<?> item, Scene scene) {
        Alert alert = new Alert(Alert.AlertType.WARNING, "Warning", new ButtonType[]{ButtonType.OK, ButtonType.CANCEL});
        alert.initOwner(scene.getWindow());
        alert.setContentText(String.format("Do you really want do delete '%s'?", item.getValue().toString()));
        alert.showAndWait().ifPresent(buttonType -> {
            if (buttonType == ButtonType.OK) {
                Transaction trx = Transactions.begin();
                try {
                    try {
                        if (item.getValue() instanceof Event) {
                            EventDAO.delete((Transaction)trx, (int)((Event)item.getValue()).getId());
                            PartUtils.closePart((String)"de.elpro.ewms.engin.gui.partdescriptor.events.event", (MApplication)app, (Object[])new Object[]{item.getValue()});
                        } else if (item.getValue() instanceof EventAction) {
                            EventActionDAO.delete((Transaction)trx, (int)((EventAction)item.getValue()).getId());
                            PartUtils.closePart((String)"de.elpro.ewms.engin.gui.partdescriptor.events.eventaction", (MApplication)app, (Object[])new Object[]{item.getValue()});
                        }
                        Transactions.commitSync((Transaction)trx);
                        item.getParent().getChildren().remove((Object)item);
                    }
                    catch (DAOOperationException exc) {
                        Transactions.rollback((Transaction)trx);
                        ExceptionDialog exceptionDialog = new ExceptionDialog((Throwable)exc);
                        exceptionDialog.setContentText(String.format("Error ocured during deleting of '%s'", item.getValue()));
                        exceptionDialog.show();
                        Transactions.close((Transaction)trx);
                    }
                }
                finally {
                    Transactions.close((Transaction)trx);
                }
            }
        });
    }

    @CanExecute
    public boolean canExecute(@Optional @Named(value="org.eclipse.ui.selection") @Named(value="org.eclipse.ui.selection") TreeItem<?> item) {
        return item != null && item.getValue() != null;
    }
}

