/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.engin.gui.navi.server.events.parts;

import de.elpro.ewms.core.client.Transactions;
import de.elpro.ewms.core.client.structure.StructureObjectDAO;
import de.elpro.ewms.core.client.variable.VariableDAO;
import de.elpro.ewms.core.client.variable.VariableInstanceDAO;
import de.elpro.ewms.core.db.Transaction;
import de.elpro.ewms.core.events.Event;
import de.elpro.ewms.core.variable.Variable;
import de.elpro.ewms.core.variable.VariableInstance;
import de.elpro.resources.Icons;
import de.elpro.ui.fx.cells.editable.TextFieldTableCell;
import de.elpro.ui.fx.cells.uimodel.UIModelListCell;
import de.elpro.ui.fx.propertysheet.CustomEditorPropertyItem;
import de.elpro.ui.fx.utils.FXUtils;
import de.elpro.ui.model.IdObject;
import de.elpro.ui.model.UIModelElement;
import de.elpro.ui.utils.e4.PartUtils;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import javafx.collections.FXCollections;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.scene.Node;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.Label;
import javafx.scene.control.ListView;
import javafx.scene.control.MenuItem;
import javafx.scene.control.SelectionMode;
import javafx.scene.image.ImageView;
import javafx.scene.input.MouseButton;
import javafx.scene.input.TransferMode;
import org.controlsfx.control.PropertySheet;
import org.controlsfx.property.editor.PropertyEditor;
import org.eclipse.e4.ui.model.application.MApplication;

public class CheckItemPropertyEditor
implements PropertyEditor<List<UIModelElement>> {
    private final ObservableList<UIModelElement> checkItems = FXCollections.observableArrayList();
    private final CustomEditorPropertyItem<List<UIModelElement>> customItem;
    private final MApplication app;
    protected final Event event;

    public CheckItemPropertyEditor(PropertySheet.Item item, MApplication app) {
        this.customItem = (CustomEditorPropertyItem)item;
        this.app = app;
        this.event = (Event)this.customItem.getEditItem();
    }

    public Node getEditor() {
        ListView view = new ListView(this.checkItems);
        view.getSelectionModel().setSelectionMode(SelectionMode.MULTIPLE);
        view.setCellFactory(cf -> new UIModelListCell(item -> item instanceof VariableInstance ? ((VariableInstance)item).getFullName() : item.toString()));
        view.setOnMouseClicked(e -> {
            if (e.getButton() == MouseButton.PRIMARY && e.getClickCount() == 2 && (view.getSelectionModel().getSelectedItem() instanceof Variable || view.getSelectionModel().getSelectedItem() instanceof VariableInstance)) {
                if (FXUtils.findParent((Node)e.getPickResult().getIntersectedNode(), TextFieldTableCell.class, (int)1) != null) {
                    return;
                }
                if (view.getSelectionModel().getSelectedItem() instanceof VariableInstance) {
                    PartUtils.showPart((String)"de.elpro.ewms.engin.gui.partstack.editors", (String)"de.elpro.ewms.engin.gui.partdescriptor.vai.instanceedit", (MApplication)this.app, (Object[])new Object[]{view.getSelectionModel().getSelectedItem()});
                } else if (view.getSelectionModel().getSelectedItem() instanceof Variable) {
                    PartUtils.showPart((String)"de.elpro.ewms.engin.gui.partstack.editors", (String)"de.elpro.ewms.engin.gui.partdescriptor.vai.variableedit", (MApplication)this.app, (Object[])new Object[]{view.getSelectionModel().getSelectedItem()});
                }
            }
        });
        view.setOnDragOver(event -> {
            String[] stringArray;
            String clipboardContent;
            if (event.getGestureSource() != view && (clipboardContent = event.getDragboard().getString()) != null && (stringArray = clipboardContent.split(";")).length != 0) {
                String part = stringArray[0];
                IdObject o = IdObject.getObjectByFullId((ClassLoader)this.getClass().getClassLoader(), (String)part);
                if (o instanceof Variable || o instanceof VariableInstance) {
                    event.acceptTransferModes(new TransferMode[]{TransferMode.LINK});
                }
            }
            event.consume();
        });
        view.setOnDragDropped(e -> {
            String clipboardContent = e.getDragboard().getString();
            if (clipboardContent != null) {
                Transaction trx = Transactions.begin();
                try {
                    String[] stringArray = clipboardContent.split(";");
                    int n = stringArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Variable var;
                        String part = stringArray[n2];
                        IdObject o = IdObject.getObjectByFullId((ClassLoader)this.getClass().getClassLoader(), (String)part);
                        if (o instanceof VariableInstance) {
                            VariableInstance dependentOn = (VariableInstance)o;
                            dependentOn = VariableInstanceDAO.get((Transaction)trx, (int)dependentOn.getId());
                            dependentOn.setVariable(VariableDAO.get((Transaction)trx, (int)dependentOn.getVariable().getId()));
                            dependentOn.setStructureObject(StructureObjectDAO.get((Transaction)trx, (int)dependentOn.getStructureObject().getId()));
                            if (!this.checkItems.contains((Object)dependentOn) && !this.checkItems.contains((Object)dependentOn.getVariable())) {
                                this.checkItems.add((Object)dependentOn);
                            }
                        } else if (o instanceof Variable && !this.checkItems.contains((Object)(var = VariableDAO.get((Transaction)trx, (int)((Variable)o).getId())))) {
                            this.checkItems.add((Object)var);
                            this.checkItems.removeAll((Collection)this.checkItems.filtered(ci -> ci instanceof VariableInstance && ((VariableInstance)ci).getVariable().equals((Object)var)));
                        }
                        ++n2;
                    }
                    this.updateEventCheckItems();
                }
                finally {
                    Transactions.close((Transaction)trx);
                }
            }
            e.consume();
        });
        this.checkItems.addListener((ListChangeListener)new ListChangeListener<UIModelElement>(){

            public void onChanged(ListChangeListener.Change<? extends UIModelElement> c) {
                CheckItemPropertyEditor.this.customItem.valueChanged();
            }
        });
        view.setEditable(true);
        MenuItem deleteItem = new MenuItem("Remove", (Node)new ImageView(Icons.DELETE_ITEM_URL.toString()));
        ContextMenu contextMenu = new ContextMenu(new MenuItem[]{deleteItem});
        deleteItem.setOnAction(e -> {
            LinkedList selectedItems = new LinkedList(view.getSelectionModel().getSelectedItems());
            view.getSelectionModel().clearSelection();
            this.checkItems.removeAll(selectedItems);
            this.updateEventCheckItems();
        });
        view.setContextMenu(contextMenu);
        view.setPlaceholder((Node)new Label("Put Variable or Variable Instance per Drag and Drop here"));
        return view;
    }

    protected void updateEventCheckItems() {
        this.event.getCheckVariables().clear();
        this.event.getCheckVariableInstances().clear();
        this.checkItems.stream().filter(ci -> ci instanceof Variable).forEach(ci -> {
            boolean bl = this.event.getCheckVariables().add((Variable)ci);
        });
        this.checkItems.stream().filter(ci -> ci instanceof VariableInstance && !this.event.getCheckVariables().contains(((VariableInstance)ci).getVariable())).forEach(ci -> {
            boolean bl = this.event.getCheckVariableInstances().add((VariableInstance)ci);
        });
    }

    public List<UIModelElement> getValue() {
        return new LinkedList<UIModelElement>((Collection<UIModelElement>)this.checkItems);
    }

    public void setValue(List<UIModelElement> value) {
        this.checkItems.setAll(value);
    }
}

