/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.engin.gui.navi.server.events.parts;

import de.elpro.ewms.core.client.Transactions;
import de.elpro.ewms.core.client.events.EventActionDAO;
import de.elpro.ewms.core.client.events.EventDAO;
import de.elpro.ewms.core.db.DAOOperationException;
import de.elpro.ewms.core.db.Transaction;
import de.elpro.ewms.core.events.EventAction;
import de.elpro.ewms.core.events.EventActionJobDescriptor;
import de.elpro.ewms.core.log.LogLevel;
import de.elpro.ewms.engin.gui.services.EnginPartUtils;
import de.elpro.ui.fx.propertysheet.BooleanPropertyItem;
import de.elpro.ui.fx.propertysheet.ChoicePropertyItem;
import de.elpro.ui.fx.propertysheet.EnumPropertyItem;
import de.elpro.ui.fx.propertysheet.IntegerPropertyItem;
import de.elpro.ui.fx.propertysheet.LocaleStringPropertyItem;
import de.elpro.ui.fx.propertysheet.NumberPropertyItem;
import de.elpro.ui.fx.propertysheet.PropertyItemsHelper;
import de.elpro.ui.fx.propertysheet.StringPropertyItem;
import de.elpro.ui.fx.validator.Validators;
import de.elpro.ui.utils.e4.PartUtils;
import java.util.Collection;
import java.util.LinkedList;
import javafx.beans.property.ReadOnlyProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableValue;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.layout.BorderPane;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import org.controlsfx.control.PropertySheet;
import org.controlsfx.dialog.ExceptionDialog;
import org.eclipse.e4.ui.di.Persist;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.workbench.modeling.EPartService;
import org.eclipse.fx.core.log.Log;
import org.eclipse.fx.core.log.Logger;

public class EventActionEditPart {
    public static final String ID = "de.elpro.ewms.engin.gui.partdescriptor.events.eventaction";
    @Inject
    @Log
    private Logger logger;
    @Inject
    private EventAction eventAction;
    @Inject
    private MPart part;
    @Inject
    private EPartService partService;
    private final PropertySheet sheet = new PropertySheet();
    private final SimpleBooleanProperty hasChanges = new SimpleBooleanProperty(false);
    private final SimpleBooleanProperty hasErrors = new SimpleBooleanProperty(false);
    private NumberPropertyItem<Integer> idItem;

    @PostConstruct
    public void postConstruct(BorderPane parent) {
        SimpleObjectProperty descriptorProperty = new SimpleObjectProperty();
        LinkedList<EventActionJobDescriptor> descriptors = new LinkedList<EventActionJobDescriptor>();
        Transaction trx = Transactions.begin();
        try {
            if (this.eventAction.getId() != null) {
                this.eventAction = EventActionDAO.get((Transaction)trx, (int)this.eventAction.getId());
            }
            EventActionJobDescriptor[] eventActionJobDescriptorArray = EventActionDAO.getJobDescriptors();
            int n = eventActionJobDescriptorArray.length;
            int n2 = 0;
            while (n2 < n) {
                EventActionJobDescriptor descriptor = eventActionJobDescriptorArray[n2];
                if (descriptor.getJobId().equals(this.eventAction.getJobId())) {
                    descriptorProperty.set((Object)descriptor);
                }
                descriptors.add(descriptor);
                ++n2;
            }
            this.eventAction.setEvent(EventDAO.get((Transaction)trx, (int)this.eventAction.getEvent().getId()));
        }
        finally {
            Transactions.close((Transaction)trx);
        }
        this.idItem = new IntegerPropertyItem("Id", (ObservableValue)this.eventAction.idProperty());
        this.idItem.setReadOnly(true);
        ChoicePropertyItem eventItem = new ChoicePropertyItem("Event", (ObservableValue)this.eventAction.eventProperty());
        LocaleStringPropertyItem nameItem = new LocaleStringPropertyItem("Name", (ObservableValue)this.eventAction.nameProperty());
        nameItem.setValidator(Validators.createNotEmptyValidator((String)"Name must be not empty"));
        ChoicePropertyItem descriptorItem = new ChoicePropertyItem("Job", (ObservableValue)descriptorProperty, descriptors);
        descriptorItem.setNullable(false);
        descriptorItem.setValidator(Validators.createNotEmptyValidator((String)"Job must be selected"));
        descriptorProperty.addListener((o, ov, nv) -> this.eventAction.setJobId(nv != null ? nv.getJobId() : null));
        StringPropertyItem executionParametersItem = new StringPropertyItem("Execution Parameters", (ObservableValue)this.eventAction.executionParametersProperty());
        EnumPropertyItem priorityItem = new EnumPropertyItem("Message Level", LogLevel.class, (ObservableValue)this.eventAction.levelProperty());
        priorityItem.setNullable(false);
        String messagePatterDescr = "Use Java String Pattern. You can use following parameters:\r\n";
        messagePatterDescr = String.valueOf(messagePatterDescr) + "\t1: Short list of variable instances\r\n";
        messagePatterDescr = String.valueOf(messagePatterDescr) + "\t2: Short list of variable instances and values\r\n";
        messagePatterDescr = String.valueOf(messagePatterDescr) + "\t3: Full list of variable instances\r\n";
        messagePatterDescr = String.valueOf(messagePatterDescr) + "\t4: Full list of variable instances and values";
        StringPropertyItem messagePatternItem = new StringPropertyItem(null, "Message Pattern", messagePatterDescr, (ObservableValue)this.eventAction.messagePatternProperty());
        messagePatternItem.useAreaEditor(true);
        messagePatternItem.setPromptText("Exp: Event XYZ fired on %1$s variable instances");
        BooleanPropertyItem activeItem = new BooleanPropertyItem("Active", (ReadOnlyProperty)this.eventAction.activeProperty());
        this.sheet.getItems().addAll((Object[])new PropertySheet.Item[]{this.idItem, eventItem, nameItem, descriptorItem, executionParametersItem, priorityItem, messagePatternItem, activeItem});
        this.hasChanges.bind((ObservableValue)PropertyItemsHelper.createHasChangesProperty((Collection)this.sheet.getItems()));
        this.hasErrors.bind((ObservableValue)PropertyItemsHelper.createHasErrorsProperty((Collection)this.sheet.getItems()));
        parent.setCenter((Node)this.sheet);
        this.hasChanges.addListener((o, ov, nv) -> this.part.setDirty(nv.booleanValue()));
        this.part.setLabel(String.format("EventAction: %s", this.eventAction.toString()));
    }

    @Persist
    public void save() {
        if (!this.hasChanges.get() && this.idItem.getValue() != null) {
            return;
        }
        if (this.hasErrors.get()) {
            Alert alert = new Alert(Alert.AlertType.WARNING);
            alert.setContentText(String.format("Cannot save %s. Fix errors first.", this.eventAction.toString()));
            alert.showAndWait();
            return;
        }
        Transaction trx = Transactions.begin();
        try {
            try {
                this.idItem.setValue((Object)EventActionDAO.saveOrUpdate((Transaction)trx, (EventAction)this.eventAction));
                Transactions.commitSync((Transaction)trx);
                PropertyItemsHelper.resetHasChangesProperties((Collection)this.sheet.getItems());
                this.part.setDirty(false);
                this.part.setLabel(String.format("EventAction: %s", this.eventAction.toString()));
                EnginPartUtils.refreshItems(this.eventAction, this.part);
            }
            catch (DAOOperationException exc) {
                Transactions.rollback((Transaction)trx);
                ExceptionDialog dlg = new ExceptionDialog((Throwable)exc);
                dlg.setContentText("Error saving event action");
                dlg.show();
                Transactions.close((Transaction)trx);
                return;
            }
        }
        finally {
            Transactions.close((Transaction)trx);
        }
        PartUtils.refreshParts((EPartService)this.partService, EventAction.class);
    }

    @PreDestroy
    protected void close() {
        this.part.setDirty(false);
    }
}

