/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.engin.gui.navi.server.events.parts;

import de.elpro.ewms.core.client.Transactions;
import de.elpro.ewms.core.client.events.EventDAO;
import de.elpro.ewms.core.client.variable.VariableDAO;
import de.elpro.ewms.core.client.variable.VariableInstanceDAO;
import de.elpro.ewms.core.db.DAOOperationException;
import de.elpro.ewms.core.db.Transaction;
import de.elpro.ewms.core.events.Event;
import de.elpro.ewms.core.variable.Variable;
import de.elpro.ewms.core.variable.VariableInstance;
import de.elpro.ewms.engin.gui.navi.server.events.parts.CheckItemPropertyEditor;
import de.elpro.ewms.engin.gui.services.EnginPartUtils;
import de.elpro.ui.fx.propertysheet.CustomEditorPropertyItem;
import de.elpro.ui.fx.propertysheet.IntegerPropertyItem;
import de.elpro.ui.fx.propertysheet.LocaleStringPropertyItem;
import de.elpro.ui.fx.propertysheet.NumberPropertyItem;
import de.elpro.ui.fx.propertysheet.PropertyItemsHelper;
import de.elpro.ui.fx.propertysheet.StringPropertyItem;
import de.elpro.ui.fx.validator.Validators;
import de.elpro.ui.utils.e4.PartUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableValue;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.layout.BorderPane;
import javafx.util.Callback;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import org.controlsfx.control.PropertySheet;
import org.controlsfx.dialog.ExceptionDialog;
import org.controlsfx.property.editor.PropertyEditor;
import org.eclipse.e4.ui.di.Persist;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.workbench.modeling.EPartService;
import org.eclipse.fx.core.log.Log;
import org.eclipse.fx.core.log.Logger;

public class EventEditPart {
    public static final String ID = "de.elpro.ewms.engin.gui.partdescriptor.events.event";
    @Inject
    @Log
    private Logger logger;
    @Inject
    private Event event;
    @Inject
    private MPart part;
    @Inject
    private EPartService partService;
    @Inject
    private MApplication app;
    private final PropertySheet sheet = new PropertySheet();
    private final SimpleBooleanProperty hasChanges = new SimpleBooleanProperty(false);
    private final SimpleBooleanProperty hasErrors = new SimpleBooleanProperty(false);
    private NumberPropertyItem<Integer> idItem;

    @PostConstruct
    public void postConstruct(BorderPane parent) {
        ArrayList<Variable> variables = new ArrayList<Variable>();
        ArrayList<VariableInstance> variableInstances = new ArrayList<VariableInstance>();
        Transaction trx = Transactions.begin();
        try {
            if (this.event.getId() != null) {
                this.event = EventDAO.get((Transaction)trx, (int)this.event.getId());
            }
            for (Variable var : this.event.getCheckVariables()) {
                variables.add(VariableDAO.get((Transaction)trx, (int)var.getId()));
            }
            for (VariableInstance variableInstance : this.event.getCheckVariableInstances()) {
                variableInstance = VariableInstanceDAO.get((Transaction)trx, (int)variableInstance.getId());
                variableInstance.setVariable(VariableDAO.get((Transaction)trx, (int)variableInstance.getVariable().getId()));
                variableInstances.add(variableInstance);
            }
            this.event.getCheckVariables().clear();
            this.event.getCheckVariables().addAll(variables);
            this.event.getCheckVariableInstances().clear();
            this.event.getCheckVariableInstances().addAll(variableInstances);
        }
        finally {
            Transactions.close((Transaction)trx);
        }
        this.idItem = new IntegerPropertyItem("Id", (ObservableValue)this.event.idProperty());
        this.idItem.setReadOnly(true);
        LocaleStringPropertyItem nameItem = new LocaleStringPropertyItem("Name", (ObservableValue)this.event.nameProperty());
        nameItem.setValidator(Validators.createNotEmptyValidator((String)"Name must be not empty"));
        StringPropertyItem fireWhenExpressionItem = new StringPropertyItem("Fire When Expr.", (ObservableValue)this.event.fireWhenExpressionProperty());
        fireWhenExpressionItem.useAreaEditor(true);
        fireWhenExpressionItem.setPromptText("Use 'x' as formula parameter for Variable Instance value");
        SimpleObjectProperty allItems = new SimpleObjectProperty(new ArrayList());
        ((List)allItems.getValue()).addAll(this.event.getCheckVariables());
        this.event.getCheckVariableInstances().forEach(i -> {
            if (!((List)allItems.getValue()).contains(i.getVariable())) {
                ((List)allItems.getValue()).add(i);
            }
        });
        CustomEditorPropertyItem checkItem = new CustomEditorPropertyItem(null, "Check Items", null, CheckItemPropertyEditor.class, (Object)this.event, (ObservableValue)allItems);
        Callback defaultFactory = this.sheet.getPropertyEditorFactory();
        this.sheet.setPropertyEditorFactory(item -> {
            if (!(item instanceof CustomEditorPropertyItem)) {
                return (PropertyEditor)defaultFactory.call(item);
            }
            return new CheckItemPropertyEditor((PropertySheet.Item)item, this.app);
        });
        this.sheet.getItems().addAll((Object[])new PropertySheet.Item[]{this.idItem, nameItem, fireWhenExpressionItem, checkItem});
        this.hasChanges.bind((ObservableValue)PropertyItemsHelper.createHasChangesProperty((Collection)this.sheet.getItems()));
        this.hasErrors.bind((ObservableValue)PropertyItemsHelper.createHasErrorsProperty((Collection)this.sheet.getItems()));
        parent.setCenter((Node)this.sheet);
        this.hasChanges.addListener((o, ov, nv) -> this.part.setDirty(nv.booleanValue()));
        this.part.setLabel(String.format("Event: %s", this.event.toString()));
    }

    @Persist
    public void save() {
        if (!this.hasChanges.get() && this.idItem.getValue() != null) {
            return;
        }
        if (this.hasErrors.get()) {
            Alert alert = new Alert(Alert.AlertType.WARNING);
            alert.setContentText(String.format("Cannot save %s. Fix errors first.", this.event.toString()));
            alert.showAndWait();
            return;
        }
        Transaction trx = Transactions.begin();
        try {
            try {
                this.idItem.setValue((Object)EventDAO.saveOrUpdate((Transaction)trx, (Event)this.event));
                Transactions.commitSync((Transaction)trx);
                PropertyItemsHelper.resetHasChangesProperties((Collection)this.sheet.getItems());
                this.part.setDirty(false);
                this.part.setLabel(String.format("Event: %s", this.event.toString()));
                EnginPartUtils.refreshItems(this.event, this.part);
            }
            catch (DAOOperationException exc) {
                Transactions.rollback((Transaction)trx);
                ExceptionDialog dlg = new ExceptionDialog((Throwable)exc);
                dlg.setContentText("Error saving event");
                dlg.show();
                Transactions.close((Transaction)trx);
                return;
            }
        }
        finally {
            Transactions.close((Transaction)trx);
        }
        PartUtils.refreshParts((EPartService)this.partService, Event.class);
    }

    @PreDestroy
    protected void close() {
        this.part.setDirty(false);
    }
}

