/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.engin.gui.navi.server.export.handlers;

import de.elpro.ewms.core.client.export.ExportDataProfileDAO;
import de.elpro.ewms.core.db.DAOOperationException;
import de.elpro.ewms.core.export.ExportDataProfile;
import de.elpro.ewms.core.export.ExportDataRequest;
import de.elpro.ewms.core.time.ITimeRangeFilter;
import de.elpro.ewms.engin.gui.navi.server.export.parts.ExportDataDialog;
import de.elpro.ui.model.UIModelElement;
import javafx.scene.Scene;
import javafx.scene.control.ButtonType;
import javafx.scene.control.TreeItem;
import javax.inject.Named;
import org.controlsfx.dialog.ExceptionDialog;
import org.eclipse.e4.core.di.annotations.CanExecute;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.core.di.annotations.Optional;

public class ExportDataHandler {
    @Execute
    public void execute(Scene scene, @Optional @Named(value="org.eclipse.ui.selection") @Named(value="org.eclipse.ui.selection") TreeItem<? extends UIModelElement> item, ITimeRangeFilter timeRangeFilter) {
        if (item.getValue() instanceof ExportDataProfile) {
            ExportDataDialog dlg = new ExportDataDialog(scene.getWindow(), (ExportDataProfile)item.getValue(), timeRangeFilter.getFrom(), timeRangeFilter.getTo());
            dlg.showAndWait().ifPresent(btn -> {
                if (btn == ButtonType.OK) {
                    try {
                        ExportDataProfileDAO.exportData((ExportDataRequest)dlg.getRequest());
                    }
                    catch (DAOOperationException exc) {
                        ExceptionDialog excDlg = new ExceptionDialog((Throwable)exc);
                        excDlg.initOwner(scene.getWindow());
                        excDlg.show();
                    }
                }
            });
        }
    }

    @CanExecute
    public boolean canExecute(@Optional @Named(value="org.eclipse.ui.selection") @Named(value="org.eclipse.ui.selection") TreeItem<?> item) {
        if (item == null) {
            return false;
        }
        return item.getValue() instanceof ExportDataProfile;
    }
}

