/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.engin.gui.navi.server.export.parts;

import de.elpro.ewms.core.export.ExportDataProfile;
import de.elpro.ewms.core.export.ExportDataRequest;
import de.elpro.ui.fx.propertysheet.LocalDateTimePropertyItem;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.scene.Node;
import javafx.scene.control.ButtonType;
import javafx.scene.control.Dialog;
import javafx.stage.Window;
import org.controlsfx.control.PropertySheet;

public class ExportDataDialog
extends Dialog<ButtonType> {
    private final ExportDataProfile profile;
    private final ObjectProperty<LocalDateTime> from = new SimpleObjectProperty();
    private final ObjectProperty<LocalDateTime> to = new SimpleObjectProperty();

    public ExportDataDialog(Window owner, ExportDataProfile profile, Instant fromTs, Instant toTs) {
        this.initOwner(owner);
        this.profile = profile;
        if (fromTs != null) {
            this.from.set((Object)LocalDateTime.ofInstant(fromTs, ZoneId.systemDefault()));
        }
        if (fromTs != null) {
            this.to.set((Object)LocalDateTime.ofInstant(toTs, ZoneId.systemDefault()));
        }
        LocalDateTimePropertyItem fromItem = new LocalDateTimePropertyItem("From", this.from);
        LocalDateTimePropertyItem toItem = new LocalDateTimePropertyItem("From", this.to);
        PropertySheet sheet = new PropertySheet();
        sheet.getItems().addAll((Object[])new PropertySheet.Item[]{fromItem, toItem});
        sheet.setPrefWidth(400.0);
        sheet.setPrefHeight(210.0);
        this.getDialogPane().setContent((Node)sheet);
        this.getDialogPane().getButtonTypes().setAll((Object[])new ButtonType[]{ButtonType.OK, ButtonType.CANCEL});
    }

    public ExportDataRequest getRequest() {
        Instant fromTs = this.from.get() != null ? ((LocalDateTime)this.from.get()).atZone(ZoneId.systemDefault()).toInstant() : null;
        Instant toTs = this.to.get() != null ? ((LocalDateTime)this.to.get()).atZone(ZoneId.systemDefault()).toInstant() : null;
        return new ExportDataRequest(this.profile, fromTs, toTs);
    }
}

