/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.engin.gui.navi.server.export.parts;

import de.elpro.ewms.core.client.Transactions;
import de.elpro.ewms.core.client.export.ExportDataProfileDAO;
import de.elpro.ewms.core.client.preferences.ServerDAO;
import de.elpro.ewms.core.db.DAOOperationException;
import de.elpro.ewms.core.db.Transaction;
import de.elpro.ewms.core.export.ExportDataPolicy;
import de.elpro.ewms.core.export.ExportDataProfile;
import de.elpro.ewms.core.export.ExportDataWriterDescriptor;
import de.elpro.ewms.core.rawvalues.RawValuesViewType;
import de.elpro.ewms.core.time.Raster;
import de.elpro.ewms.core.variable.VariableInstance;
import de.elpro.ewms.core.virtualtime.ComplexRaster;
import de.elpro.ewms.engin.gui.navi.server.export.parts.ExportDataProfileInstanceSelectionEditor;
import de.elpro.ewms.engin.gui.services.EnginPartUtils;
import de.elpro.ui.fx.propertysheet.BooleanPropertyItem;
import de.elpro.ui.fx.propertysheet.ChoicePropertyItem;
import de.elpro.ui.fx.propertysheet.DynamicEditorPropertyItem;
import de.elpro.ui.fx.propertysheet.EnumPropertyItem;
import de.elpro.ui.fx.propertysheet.IntegerPropertyItem;
import de.elpro.ui.fx.propertysheet.LocaleStringPropertyItem;
import de.elpro.ui.fx.propertysheet.NumberPropertyItem;
import de.elpro.ui.fx.propertysheet.PropertyItemsHelper;
import de.elpro.ui.fx.propertysheet.StringPropertyItem;
import de.elpro.ui.fx.validator.Validators;
import de.elpro.ui.utils.e4.PartUtils;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ReadOnlyProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableValue;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.layout.BorderPane;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import jidefx.scene.control.validation.Validator;
import org.controlsfx.control.PropertySheet;
import org.controlsfx.dialog.ExceptionDialog;
import org.eclipse.e4.ui.di.Persist;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.workbench.modeling.EPartService;

public class ExportDataProfileEditPart {
    public static final String ID = "de.elpro.ewms.engin.gui.partdescriptor.export.exportdataprofile.editpart";
    private static final String EXPORT_INSTANCES_SECTION_GROUP = "Variable Instances";
    @Inject
    private ExportDataProfile exportDataProfile;
    @Inject
    private MPart part;
    @Inject
    private EPartService partService;
    private final PropertySheet sheet = new PropertySheet();
    private final SimpleBooleanProperty hasChanges = new SimpleBooleanProperty(false);
    private final SimpleBooleanProperty hasErrors = new SimpleBooleanProperty(false);
    private NumberPropertyItem<Integer> idItem;

    @PostConstruct
    public void postConstruct(BorderPane parent) {
        Object[] dataWriters = ExportDataProfileDAO.getAvailableExportDataWriters();
        SimpleObjectProperty dataWriterProperty = new SimpleObjectProperty();
        Transaction trx = Transactions.begin();
        try {
            if (this.exportDataProfile.getId() != null) {
                this.exportDataProfile = ExportDataProfileDAO.get((Transaction)trx, (int)this.exportDataProfile.getId());
            }
            if (this.exportDataProfile.getDataWriterId() != null) {
                Object[] objectArray = dataWriters;
                int n = dataWriters.length;
                int n2 = 0;
                while (n2 < n) {
                    ExportDataWriterDescriptor writer = objectArray[n2];
                    if (this.exportDataProfile.getDataWriterId().equals(writer.getId())) {
                        dataWriterProperty.set((Object)writer);
                    }
                    ++n2;
                }
            }
        }
        finally {
            Transactions.close((Transaction)trx);
        }
        this.idItem = new IntegerPropertyItem("Id", (ObservableValue)this.exportDataProfile.idProperty());
        this.idItem.setReadOnly(true);
        LocaleStringPropertyItem nameItem = new LocaleStringPropertyItem("Name", (ObservableValue)this.exportDataProfile.nameProperty());
        nameItem.setValidator(Validators.createNotEmptyValidator((String)"Name should not be empty"));
        ChoicePropertyItem dsvtItem = new ChoicePropertyItem("Data Source Type", (ObservableValue)this.exportDataProfile.dataSourceValuesViewTypeProperty(), (Object[])new RawValuesViewType[]{RawValuesViewType.GlobalView, RawValuesViewType.RealtimeView});
        dsvtItem.setNullable(false);
        dsvtItem.setValidator(Validators.createNotEmptyValidator((String)"Data Source Type should not be empty"));
        ChoicePropertyItem dataRasterItem = new ChoicePropertyItem("Data Raster", (ObservableValue)this.exportDataProfile.dataRasterProperty(), (Object[])ComplexRaster.values());
        dataRasterItem.setNullable(false);
        ChoicePropertyItem dataSliceSizeItem = new ChoicePropertyItem("Data Slice Size", (ObservableValue)this.exportDataProfile.dataSliceSizeProperty(), (Object[])ComplexRaster.values());
        dataSliceSizeItem.setNullable(false);
        ChoicePropertyItem dataWriterItem = new ChoicePropertyItem("Data Writer", (ObservableValue)dataWriterProperty, dataWriters);
        dataWriterItem.setNullable(false);
        dataWriterItem.setValidator(Validators.createNotEmptyValidator((String)"Data Writer should not be empty"));
        StringPropertyItem dataWriterOptionsItem = new StringPropertyItem("Writer Options", (ObservableValue)this.exportDataProfile.dataWriterOptionsProperty());
        dataWriterOptionsItem.useAreaEditor(true);
        dataWriterOptionsItem.setPromptText(dataWriterProperty.get() != null ? ((ExportDataWriterDescriptor)dataWriterProperty.get()).getDefaultOptions() : null);
        EnumPropertyItem executionIntervalItem = new EnumPropertyItem("Execution Interval", Raster.class, (ObservableValue)this.exportDataProfile.executionIntervalProperty());
        executionIntervalItem.setNullable(false);
        executionIntervalItem.setValidator(Validators.createNotEmptyValidator((String)"Execution Interval should not be empty"));
        StringPropertyItem descriptionItem = new StringPropertyItem("Description", (ObservableValue)this.exportDataProfile.descriptionProperty());
        descriptionItem.useAreaEditor(true);
        EnumPropertyItem exportPolicyItem = new EnumPropertyItem(EXPORT_INSTANCES_SECTION_GROUP, "ExportPolicy", ExportDataPolicy.class, (ObservableValue)this.exportDataProfile.exportPolicyProperty());
        exportPolicyItem.setNullable(false);
        exportPolicyItem.setValidator(Validators.createNotEmptyValidator((String)"Execution Interval should not be empty"));
        SimpleObjectProperty selectedVariableInstances = new SimpleObjectProperty(new HashSet(this.exportDataProfile.getVariableInstances()));
        selectedVariableInstances.addListener((o, ov, nv) -> {
            this.exportDataProfile.getVariableInstances().clear();
            this.exportDataProfile.getVariableInstances().addAll(nv);
        });
        DynamicEditorPropertyItem variableInstancesSelectionItem = new DynamicEditorPropertyItem(EXPORT_INSTANCES_SECTION_GROUP, "Selected Instances", (ObservableValue)selectedVariableInstances);
        variableInstancesSelectionItem.setEditor((Node)new ExportDataProfileInstanceSelectionEditor((ObjectProperty<Set<VariableInstance>>)selectedVariableInstances));
        BooleanPropertyItem activeItem = new BooleanPropertyItem("Active", (ReadOnlyProperty)this.exportDataProfile.activeProperty());
        Validator drsValidator = Validators.createValidator((o, ov, nv) -> this.exportDataProfile.getDataRaster() != null && this.exportDataProfile.getDataSliceSize() != null && this.exportDataProfile.getDataSliceSize().ordinal() >= this.exportDataProfile.getDataRaster().ordinal(), (String)"Data Slice Size should be greater or equal to Data Raster");
        Validator drValidator = Validators.createValidator((o, ov, nv) -> this.exportDataProfile.getDataSourceValuesViewType() != null && this.exportDataProfile.getDataRaster() != null && this.exportDataProfile.getDataRaster().ordinal() >= ServerDAO.getRawValuesViewRaster((RawValuesViewType)this.exportDataProfile.getDataSourceValuesViewType(), (Integer)this.exportDataProfile.getDataSourceValuesViewIndex()).ordinal(), (String)"Data Raster should be greater or equal underlying Data Source Raster");
        dsvtItem.setValidator(drValidator);
        dataRasterItem.setValidator(Validators.combine((Validator[])new Validator[]{drValidator, drsValidator}));
        dataSliceSizeItem.setValidator(drsValidator);
        dataWriterItem.valueProperty().addListener((o, ov, nv) -> {
            this.exportDataProfile.setDataWriterId(nv.getId());
            if (this.exportDataProfile.getDataWriterOptions() == null || this.exportDataProfile.getDataWriterOptions().isBlank()) {
                this.exportDataProfile.setDataWriterOptions(nv.getDefaultOptions());
            }
        });
        dsvtItem.valueProperty().addListener(il -> dataRasterItem.forceValidate());
        dataRasterItem.valueProperty().addListener(il -> {
            dsvtItem.forceValidate();
            dataSliceSizeItem.forceValidate();
        });
        dataSliceSizeItem.valueProperty().addListener(il -> dataRasterItem.forceValidate());
        this.sheet.getItems().addAll((Object[])new PropertySheet.Item[]{this.idItem, nameItem, dsvtItem, dataRasterItem, dataSliceSizeItem, dataWriterItem, dataWriterOptionsItem, executionIntervalItem, descriptionItem, activeItem, exportPolicyItem, variableInstancesSelectionItem});
        this.sheet.setMode(PropertySheet.Mode.CATEGORY);
        this.hasChanges.bind((ObservableValue)PropertyItemsHelper.createHasChangesProperty((Collection)this.sheet.getItems()));
        this.hasErrors.bind((ObservableValue)PropertyItemsHelper.createHasErrorsProperty((Collection)this.sheet.getItems()));
        this.hasChanges.addListener((o, ov, nv) -> this.part.setDirty(nv != false || this.idItem.getValue() == null));
        this.part.setLabel(String.format("Export Data Profile: %s", this.exportDataProfile.toString()));
        parent.setCenter((Node)this.sheet);
    }

    @Persist
    public void save() {
        if (!this.hasChanges.get() && this.idItem.getValue() != null) {
            return;
        }
        if (this.hasErrors.get()) {
            Alert alert = new Alert(Alert.AlertType.WARNING);
            alert.setContentText(String.format("Cannot save %s. Fix errors first.", this.exportDataProfile.toString()));
            alert.showAndWait();
            return;
        }
        Transaction trx = Transactions.begin();
        try {
            try {
                this.idItem.setValue((Object)ExportDataProfileDAO.saveOrUpdate((Transaction)trx, (ExportDataProfile)this.exportDataProfile));
                Transactions.commitSync((Transaction)trx);
                PropertyItemsHelper.resetHasChangesProperties((Collection)this.sheet.getItems());
                this.part.setDirty(false);
                this.part.setLabel(String.format("Export Data Profile: %s", this.exportDataProfile.toString()));
                EnginPartUtils.refreshItems(this.exportDataProfile, this.part);
            }
            catch (DAOOperationException exc) {
                Transactions.rollback((Transaction)trx);
                ExceptionDialog dlg = new ExceptionDialog((Throwable)exc);
                dlg.setContentText("Error saving Export Data Profile");
                dlg.show();
                Transactions.close((Transaction)trx);
                return;
            }
        }
        finally {
            Transactions.close((Transaction)trx);
        }
        PartUtils.refreshParts((EPartService)this.partService, ExportDataProfile.class);
    }

    @PreDestroy
    protected void close() {
        this.part.setDirty(false);
    }
}

