/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.engin.gui.navi.server.export.parts;

import de.elpro.ewms.core.client.Transactions;
import de.elpro.ewms.core.client.structure.StructureClassDAO;
import de.elpro.ewms.core.client.structure.StructureObjectDAO;
import de.elpro.ewms.core.client.variable.VariableDAO;
import de.elpro.ewms.core.client.variable.VariableInstanceDAO;
import de.elpro.ewms.core.db.Transaction;
import de.elpro.ewms.core.structure.StructureClass;
import de.elpro.ewms.core.structure.StructureObject;
import de.elpro.ewms.core.variable.Variable;
import de.elpro.ewms.core.variable.VariableInstance;
import de.elpro.resources.Icons;
import de.elpro.ui.concurrent.CallableTask;
import de.elpro.ui.fx.controls.IntermediateCheckBox;
import de.elpro.ui.fx.layout.ProgressIndicatorPane;
import de.elpro.ui.fx.utils.TaskUtils;
import de.elpro.ui.model.UIModelElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javafx.application.Platform;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.Property;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.scene.Node;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.MenuItem;
import javafx.scene.control.TreeItem;
import javafx.scene.control.TreeTableCell;
import javafx.scene.control.TreeTableColumn;
import javafx.scene.control.TreeTableView;
import javafx.scene.image.ImageView;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.HBox;
import javafx.scene.text.Font;
import javafx.scene.text.FontWeight;

public class ExportDataProfileInstanceSelectionEditor
extends BorderPane {
    private final TreeTableView<SelectionItem> treeTableView = new TreeTableView();
    private final ProgressIndicatorPane progressIndicatorPane = new ProgressIndicatorPane(this.treeTableView);
    private final ObjectProperty<Set<VariableInstance>> selectedVariableInstances;

    public ExportDataProfileInstanceSelectionEditor(ObjectProperty<Set<VariableInstance>> selectedVariableInstances) {
        this.selectedVariableInstances = selectedVariableInstances;
        this.setCenter((Node)this.progressIndicatorPane);
        TreeTableColumn itemColumn = new TreeTableColumn("Selection");
        itemColumn.setCellValueFactory(cf -> cf.getValue().valueProperty());
        itemColumn.setCellFactory(cf -> new SelectionTTVItem());
        itemColumn.setPrefWidth(500.0);
        this.treeTableView.getColumns().add((Object)itemColumn);
        this.treeTableView.setMaxWidth(Double.MAX_VALUE);
        this.treeTableView.setShowRoot(false);
        this.setMaxWidth(Double.MAX_VALUE);
        this.setPrefHeight(600.0);
        MenuItem refreshItem = new MenuItem("Refresh", (Node)new ImageView(Icons.REFRESH_ITEM_URL.toString()));
        refreshItem.setOnAction(e -> this.refresh());
        ContextMenu cm = new ContextMenu(new MenuItem[]{refreshItem});
        this.treeTableView.setContextMenu(cm);
        this.refresh();
    }

    private static TreeItem<SelectionItem> loadTree(Set<VariableInstance> selectedInstances, Runnable updateSelectedInstancesCallback) {
        TreeItem rootItem = new TreeItem();
        HashMap<Integer, StructureObject> allInstances = new HashMap<Integer, StructureObject>();
        HashMap<Integer, StructureObject> allVariables = new HashMap<Integer, StructureObject>();
        HashMap<Integer, StructureObject> allClasses = new HashMap<Integer, StructureObject>();
        HashMap<Integer, StructureObject> allObjects = new HashMap<Integer, StructureObject>();
        HashMap<StructureObject, TreeItem> instanceTreeItems = new HashMap<StructureObject, TreeItem>();
        HashMap<StructureObject, TreeItem> variableTreeItems = new HashMap<StructureObject, TreeItem>();
        Transaction trx = Transactions.begin();
        try {
            Boolean selected;
            boolean instanceSelected;
            boolean partialSelected;
            TreeItem item;
            StructureObject[] structureObjectArray = StructureObjectDAO.getAll((Transaction)trx);
            int n = structureObjectArray.length;
            int n2 = 0;
            while (n2 < n) {
                StructureObject object = structureObjectArray[n2];
                allObjects.put(object.getId(), object);
                ++n2;
            }
            structureObjectArray = StructureClassDAO.getAll((Transaction)trx);
            n = structureObjectArray.length;
            n2 = 0;
            while (n2 < n) {
                StructureObject structureClass = structureObjectArray[n2];
                allClasses.put(structureClass.getId(), structureClass);
                ++n2;
            }
            structureObjectArray = VariableDAO.getAll((Transaction)trx);
            n = structureObjectArray.length;
            n2 = 0;
            while (n2 < n) {
                StructureObject variable = structureObjectArray[n2];
                variable.setStructureClass((StructureClass)allClasses.get(variable.getStructureClass().getId()));
                allVariables.put(variable.getId(), variable);
                ++n2;
            }
            structureObjectArray = VariableInstanceDAO.getAll((Transaction)trx);
            n = structureObjectArray.length;
            n2 = 0;
            while (n2 < n) {
                StructureObject instance = structureObjectArray[n2];
                instance.setStructureObject((StructureObject)allObjects.get(instance.getStructureObject().getId()));
                instance.setVariable((Variable)allVariables.get(instance.getVariable().getId()));
                allInstances.put(instance.getId(), instance);
                TreeItem item2 = new TreeItem((Object)new SelectionItem((UIModelElement)instance, selectedInstances.contains(instance)));
                instanceTreeItems.put(instance, item2);
                ++n2;
            }
            for (StructureObject variable : allVariables.values()) {
                if (variable.getInstances().isEmpty()) continue;
                ArrayList<Property<Boolean>> checkboxes = new ArrayList<Property<Boolean>>();
                item = new TreeItem();
                boolean allSelected = true;
                partialSelected = false;
                for (VariableInstance instance : variable.getInstances()) {
                    TreeItem instanceItem = (TreeItem)instanceTreeItems.get(instance);
                    checkboxes.add((Property<Boolean>)((SelectionItem)instanceItem.getValue()).selected);
                    instanceSelected = ((SelectionItem)instanceItem.getValue()).selected.get() != null && (Boolean)((SelectionItem)instanceItem.getValue()).selected.get() != false;
                    allSelected &= instanceSelected;
                    partialSelected |= instanceSelected;
                    item.getChildren().add((Object)instanceItem);
                }
                Collections.sort(item.getChildren(), (o1, o2) -> ((SelectionItem)o1.getValue()).element.compareTo((Object)((SelectionItem)o2.getValue()).element));
                selected = allSelected ? Boolean.TRUE : (partialSelected ? null : Boolean.FALSE);
                item.setValue((Object)new SelectionItem((UIModelElement)variable, selected));
                ExportDataProfileInstanceSelectionEditor.bindHierarchicalSelection(((SelectionItem)item.getValue()).selected, checkboxes, updateSelectedInstancesCallback);
                variableTreeItems.put(variable, item);
            }
            for (StructureObject structureClass : allClasses.values()) {
                ArrayList<Property<Boolean>> checkboxes = new ArrayList<Property<Boolean>>();
                item = new TreeItem();
                boolean allSelected = true;
                partialSelected = false;
                for (Variable variable : structureClass.getVariables()) {
                    TreeItem variableItem = (TreeItem)variableTreeItems.get(variable);
                    if (variableItem == null) continue;
                    checkboxes.add((Property<Boolean>)((SelectionItem)variableItem.getValue()).selected);
                    instanceSelected = ((SelectionItem)variableItem.getValue()).selected.get() != null && (Boolean)((SelectionItem)variableItem.getValue()).selected.get() != false;
                    allSelected &= instanceSelected;
                    partialSelected |= instanceSelected || ((SelectionItem)variableItem.getValue()).selected.get() == null;
                    item.getChildren().add((Object)variableItem);
                }
                if (item.getChildren().isEmpty()) continue;
                Collections.sort(item.getChildren(), (o1, o2) -> ((SelectionItem)o1.getValue()).element.compareTo((Object)((SelectionItem)o2.getValue()).element));
                selected = allSelected ? Boolean.TRUE : (partialSelected ? null : Boolean.FALSE);
                item.setValue((Object)new SelectionItem((UIModelElement)structureClass, selected));
                ExportDataProfileInstanceSelectionEditor.bindHierarchicalSelection(((SelectionItem)item.getValue()).selected, checkboxes, updateSelectedInstancesCallback);
                rootItem.getChildren().add((Object)item);
            }
        }
        finally {
            Transactions.close((Transaction)trx);
        }
        return rootItem;
    }

    private static void bindHierarchicalSelection(Property<Boolean> parent, Collection<Property<Boolean>> children, Runnable updateSelectedInstancesCallback) {
        HierachicalChangeListener hcListener = new HierachicalChangeListener(parent, children, updateSelectedInstancesCallback);
        parent.addListener((ChangeListener)hcListener);
        children.forEach(c -> c.addListener(hcListener));
    }

    private void refresh() {
        CallableTask<TreeItem<SelectionItem>> task = new CallableTask<TreeItem<SelectionItem>>(){

            public TreeItem<SelectionItem> call() throws Exception {
                return ExportDataProfileInstanceSelectionEditor.loadTree((Set)ExportDataProfileInstanceSelectionEditor.this.selectedVariableInstances.get(), () -> ExportDataProfileInstanceSelectionEditor.this.updateSelectedInstances());
            }
        };
        TaskUtils.executeUITask((ProgressIndicatorPane)this.progressIndicatorPane, (CallableTask)task).consumeResult(result -> Platform.runLater(() -> {
            this.treeTableView.setRoot(null);
            System.gc();
            this.treeTableView.setRoot(result);
        }));
    }

    private void updateSelectedInstances() {
        HashSet<VariableInstance> selectedInstances = new HashSet<VariableInstance>();
        for (TreeItem classItem : this.treeTableView.getRoot().getChildren()) {
            for (TreeItem variableItem : classItem.getChildren()) {
                for (TreeItem instanceItem : variableItem.getChildren()) {
                    SelectionItem si = (SelectionItem)instanceItem.getValue();
                    if (si.selected.get() == null || !((Boolean)si.selected.get()).booleanValue()) continue;
                    selectedInstances.add((VariableInstance)si.element);
                }
            }
        }
        this.selectedVariableInstances.set(selectedInstances);
    }

    private static class HierachicalChangeListener
    implements ChangeListener<Boolean> {
        private boolean pendingChange = false;
        private final Property<Boolean> parent;
        private final Set<Property<Boolean>> children = new HashSet<Property<Boolean>>();
        private final Runnable updateSelectedInstancesCallback;

        public HierachicalChangeListener(Property<Boolean> parent, Collection<Property<Boolean>> children, Runnable updateSelectedInstancesCallback) {
            this.parent = parent;
            this.children.addAll(children);
            this.updateSelectedInstancesCallback = updateSelectedInstancesCallback;
        }

        public void changed(ObservableValue<? extends Boolean> observable, Boolean oldValue, Boolean newValue) {
            if (this.pendingChange) {
                return;
            }
            try {
                this.pendingChange = true;
                if (observable == this.parent) {
                    if (newValue == null) {
                        return;
                    }
                    this.children.forEach(c -> c.setValue((Object)newValue));
                } else {
                    boolean allTrue = true;
                    boolean allFalse = true;
                    for (Property<Boolean> p : this.children) {
                        allTrue &= p.getValue() != null && (Boolean)p.getValue() != false;
                        allFalse &= p.getValue() != null && (Boolean)p.getValue() == false;
                    }
                    if (allTrue && allFalse || !allTrue && !allFalse) {
                        this.parent.setValue(null);
                    } else if (allTrue) {
                        this.parent.setValue((Object)true);
                    } else if (allFalse) {
                        this.parent.setValue((Object)false);
                    } else {
                        this.parent.setValue(null);
                    }
                }
                this.updateSelectedInstancesCallback.run();
            }
            finally {
                this.pendingChange = false;
            }
        }
    }

    private static class SelectionItem {
        private final ObjectProperty<Boolean> selected;
        private final UIModelElement element;
        private IntermediateCheckBox cb;
        private Node graphic;
        private HBox container;

        public SelectionItem(UIModelElement element, Boolean selected) {
            this.selected = new SimpleObjectProperty((Object)selected);
            this.element = element;
        }

        public Node getGraphic() {
            if (this.container == null) {
                this.cb = new IntermediateCheckBox();
                this.graphic = this.element.getGraphic();
                this.container = new HBox(5.0, new Node[]{this.cb, this.graphic});
                this.cb.compositeValueProperty().bindBidirectional(this.selected);
            }
            return this.container;
        }
    }

    private static class SelectionTTVItem
    extends TreeTableCell<SelectionItem, SelectionItem> {
        private final Font defaultFont = this.getFont();
        private final List<String> defaultStyleClasses = new LinkedList<String>((Collection<String>)this.getStyleClass());

        private SelectionTTVItem() {
        }

        protected void updateItem(SelectionItem item, boolean empty) {
            super.updateItem((Object)item, empty);
            if (empty || item == null) {
                this.setGraphic(null);
                this.textProperty().unbind();
                this.setText(null);
            } else {
                this.setGraphic(item.getGraphic());
                this.textProperty().bind(item.element.textProperty());
                this.setTextFill(item.element.getTextFill());
                this.setFont(this.getFont(item.element.getFontWeight()));
                this.setStyleClass(item.element.isEnabled() ? "enabled" : "disabled");
            }
        }

        public Font getFont(FontWeight fontWeight) {
            return Font.font((String)this.defaultFont.getFamily(), (FontWeight)fontWeight, (double)this.defaultFont.getSize());
        }

        private void setStyleClass(String ... classNames) {
            LinkedList<String> defaultClasses = new LinkedList<String>(this.defaultStyleClasses);
            if (classNames != null) {
                String[] stringArray = classNames;
                int n = classNames.length;
                int n2 = 0;
                while (n2 < n) {
                    String className = stringArray[n2];
                    defaultClasses.add(className);
                    ++n2;
                }
            }
            this.getStyleClass().setAll(defaultClasses);
        }
    }
}

