/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.engin.gui.navi.server.objects.controls;

import de.elpro.ewms.core.client.Transactions;
import de.elpro.ewms.core.client.structure.StructureClassDAO;
import de.elpro.ewms.core.client.structure.StructureObjectDAO;
import de.elpro.ewms.core.db.Transaction;
import de.elpro.ewms.core.structure.StructureClass;
import de.elpro.ewms.core.structure.StructureObject;
import de.elpro.ewms.core.structure.StructureObjectCopyOptions;
import de.elpro.ewms.engin.gui.tools.validators.ValidatorUtils;
import de.elpro.ui.fx.propertysheet.BooleanPropertyItem;
import de.elpro.ui.fx.propertysheet.LocaleStringPropertyItem;
import de.elpro.ui.fx.propertysheet.MultChoicesPropertyItem;
import de.elpro.ui.fx.propertysheet.PropertyItemsHelper;
import de.elpro.ui.fx.propertysheet.StringPropertyItem;
import de.elpro.ui.fx.validator.Validators;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javafx.beans.property.ReadOnlyProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.value.ObservableValue;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonType;
import javafx.scene.control.Dialog;
import javafx.stage.Window;
import jidefx.scene.control.validation.ValidationEvent;
import org.controlsfx.control.PropertySheet;

public class StructureObjectCreateCopyDialog
extends Dialog<ButtonType> {
    private final StructureObjectCopyOptions copyOptions = new StructureObjectCopyOptions();

    public StructureObjectCreateCopyDialog(Window owner, int srcObjectId) {
        List<StructureObject> allowedParents;
        StructureObject structureObject;
        this.initOwner(owner);
        this.setResizable(true);
        this.getDialogPane().setPrefSize(600.0, 400.0);
        Transaction trx = Transactions.begin();
        try {
            structureObject = StructureObjectDAO.get((Transaction)trx, (int)srcObjectId);
            structureObject.setStructureClass(StructureClassDAO.get((Transaction)trx, (int)structureObject.getStructureClass().getId()));
            allowedParents = this.getAllowedParents(trx, structureObject.getStructureClass());
            this.copyOptions.setKey(structureObject.getKey());
            this.copyOptions.setName(structureObject.getName());
            this.copyOptions.setPlcAliasMapText(structureObject.getPlcAliasMapText());
            this.copyOptions.getParents().addAll(structureObject.getParents());
        }
        finally {
            Transactions.close((Transaction)trx);
        }
        StringPropertyItem keyItem = new StringPropertyItem("Key Identifier", (ObservableValue)this.copyOptions.keyProperty());
        keyItem.setValidator(vo -> {
            if (structureObject.getKey() == null || structureObject.getKey().isEmpty()) {
                return new ValidationEvent(ValidationEvent.VALIDATION_INFO, 0, "You can provide unique key to reference this object directly in formulas.");
            }
            if (Character.isUpperCase(structureObject.getKey().charAt(0))) {
                return new ValidationEvent(ValidationEvent.VALIDATION_ERROR, 0, "Object key should not start with capital character.");
            }
            return (ValidationEvent)ValidatorUtils.VAR_NAME_TOKEN_VALIDATOR.call(vo);
        });
        LocaleStringPropertyItem displayNameItem = new LocaleStringPropertyItem("Display Name", (ObservableValue)this.copyOptions.nameProperty());
        displayNameItem.setValidator(Validators.createNotEmptyValidator((String)"Display Name cannot be empty"));
        MultChoicesPropertyItem parentObjectsItem = new MultChoicesPropertyItem("Parent Objects", (Collection)this.copyOptions.getParents(), allowedParents);
        StringPropertyItem plcAliasMap = new StringPropertyItem("Plc Alias Map", (ObservableValue)this.copyOptions.plcAliasMapTextProperty());
        plcAliasMap.setPromptText("Ex.: key_1=value1;key_2=value_2;key_3=value_3;");
        BooleanPropertyItem copyPLCPropertiesItem = new BooleanPropertyItem("Copy PLC Props.", (ReadOnlyProperty)this.copyOptions.copyPLCInstancePropertiesProperty());
        PropertySheet sheet = new PropertySheet();
        sheet.getItems().addAll((Object[])new PropertySheet.Item[]{keyItem, displayNameItem, parentObjectsItem, plcAliasMap, copyPLCPropertiesItem});
        SimpleBooleanProperty hasChanges = new SimpleBooleanProperty();
        SimpleBooleanProperty hasErrors = new SimpleBooleanProperty();
        hasChanges.bind((ObservableValue)PropertyItemsHelper.createHasChangesProperty((Collection)sheet.getItems()));
        hasErrors.bind((ObservableValue)PropertyItemsHelper.createHasErrorsProperty((Collection)sheet.getItems()));
        this.getDialogPane().setContent((Node)sheet);
        this.getDialogPane().getButtonTypes().setAll((Object[])new ButtonType[]{ButtonType.APPLY, ButtonType.CANCEL});
        Button applyButton = (Button)this.getDialogPane().lookupButton(ButtonType.APPLY);
        applyButton.disableProperty().bind((ObservableValue)hasErrors);
    }

    public StructureObjectCopyOptions getCopyOptions() {
        return this.copyOptions;
    }

    public List<StructureObject> getAllowedParents(Transaction trx, StructureClass structureClass) {
        return Arrays.asList(StructureClassDAO.getAllowedParentObjects((Transaction)trx, (int)structureClass.getId()));
    }
}

