/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.engin.gui.navi.server.objects.handlers;

import de.elpro.ewms.core.client.Transactions;
import de.elpro.ewms.core.client.structure.StructureObjectDAO;
import de.elpro.ewms.core.db.Transaction;
import de.elpro.ewms.core.structure.StructureObject;
import de.elpro.ewms.core.variable.VariableInstance;
import de.elpro.ewms.engin.gui.navi.model.INavigationTreeElement;
import de.elpro.ewms.engin.gui.navi.model.LazyNavigationContribution;
import de.elpro.ewms.engin.gui.navi.server.objects.handlers.StructureObjectEditHandler;
import de.elpro.ewms.gui.utils.e4.EOSPartUtils;
import de.elpro.ui.model.UIModelElement;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Function;
import javafx.scene.control.TreeItem;
import javax.inject.Inject;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.workbench.modeling.EModelService;

public class CreateObjectsTreeHandler
extends LazyNavigationContribution<UIModelElement> {
    private Function<TreeItem<UIModelElement>, List<TreeItem<UIModelElement>>> LIST_CREATOR = new Function<TreeItem<UIModelElement>, List<TreeItem<UIModelElement>>>(){

        @Override
        public List<TreeItem<UIModelElement>> apply(TreeItem<UIModelElement> item) {
            LinkedList<TreeItem<UIModelElement>> elements = new LinkedList<TreeItem<UIModelElement>>();
            Transaction trx = Transactions.begin();
            try {
                if (item.getValue() == null || item.getValue() instanceof INavigationTreeElement) {
                    elements.addAll(CreateObjectsTreeHandler.this.createLazyTreeItemCollection((UIModelElement[])StructureObjectDAO.getRoots((Transaction)trx)));
                } else if (item.getValue() instanceof StructureObject) {
                    StructureObject object = (StructureObject)item.getValue();
                    elements.addAll(CreateObjectsTreeHandler.this.createLazyTreeItemCollection((UIModelElement[])StructureObjectDAO.getChildren((Transaction)trx, (StructureObject)object)));
                }
            }
            finally {
                Transactions.close((Transaction)trx);
            }
            return elements;
        }
    };
    @Inject
    private MApplication app;
    @Inject
    private EModelService modelService;

    @Override
    public Function<TreeItem<UIModelElement>, List<TreeItem<UIModelElement>>> getChildrenCreator() {
        return this.LIST_CREATOR;
    }

    @Execute
    public void execute() {
    }

    public List<TreeItem<UIModelElement>> getChildren() {
        LinkedList<TreeItem<UIModelElement>> rootObjects = new LinkedList<TreeItem<UIModelElement>>();
        Transaction trx = Transactions.begin();
        try {
            StructureObject[] structureObjectArray = StructureObjectDAO.getRoots((Transaction)trx);
            int n = structureObjectArray.length;
            int n2 = 0;
            while (n2 < n) {
                StructureObject rootObject = structureObjectArray[n2];
                TreeItem item = new TreeItem((Object)rootObject);
                rootObjects.add((TreeItem<UIModelElement>)item);
                this.addRecursive(trx, (TreeItem<UIModelElement>)item);
                ++n2;
            }
        }
        finally {
            Transactions.close((Transaction)trx);
        }
        return rootObjects;
    }

    private void addRecursive(Transaction trx, TreeItem<UIModelElement> item) {
        if (item.getValue() instanceof StructureObject) {
            StructureObject object = (StructureObject)item.getValue();
            StructureObject[] structureObjectArray = StructureObjectDAO.getChildren((Transaction)trx, (StructureObject)object);
            int n = structureObjectArray.length;
            int n2 = 0;
            while (n2 < n) {
                StructureObject child = structureObjectArray[n2];
                TreeItem childItem = new TreeItem((Object)child);
                item.getChildren().add((Object)childItem);
                this.addRecursive(trx, (TreeItem<UIModelElement>)childItem);
                ++n2;
            }
        }
    }

    @Override
    public String getContextMenuId() {
        return "de.elpro.ewms.engin.gui.menu.navi.objects";
    }

    @Override
    public void onTreeItemClick(Object sender, TreeItem<UIModelElement> treeItem) {
        new StructureObjectEditHandler().execute(this.app, treeItem);
    }

    @Override
    public void onTreeItemDoubleClick(Object sender, TreeItem<UIModelElement> treeItem) {
        EOSPartUtils.pinSelectedMPart((EModelService)this.modelService, (MApplication)this.app, (String)"de.elpro.ewms.engin.gui.partstack.editors");
    }

    @Override
    public boolean canDragItem(UIModelElement item) {
        return item instanceof VariableInstance;
    }
}

