/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.engin.gui.navi.server.objects.handlers;

import de.elpro.ewms.core.client.Transactions;
import de.elpro.ewms.core.client.structure.StructureObjectDAO;
import de.elpro.ewms.core.db.Transaction;
import de.elpro.ewms.core.structure.StructureObject;
import de.elpro.ewms.core.structure.StructureObjectCopyOptions;
import de.elpro.ewms.engin.gui.navi.server.objects.controls.StructureObjectCreateCopyDialog;
import de.elpro.ui.model.UIModelElement;
import javafx.scene.Scene;
import javafx.scene.control.ButtonType;
import javafx.scene.control.TreeItem;
import javax.inject.Named;
import org.controlsfx.dialog.ExceptionDialog;
import org.eclipse.e4.core.di.annotations.CanExecute;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.core.di.annotations.Optional;

public class StructureObjectCreateCopyHandler {
    @Execute
    public void execute(Scene scene, @Optional @Named(value="org.eclipse.ui.selection") @Named(value="org.eclipse.ui.selection") TreeItem<? extends UIModelElement> item) {
        if (item == null || !(item.getValue() instanceof StructureObject)) {
            return;
        }
        StructureObject srcObject = (StructureObject)item.getValue();
        StructureObjectCreateCopyDialog dlg = new StructureObjectCreateCopyDialog(scene.getWindow(), srcObject.getId());
        dlg.showAndWait().ifPresent(btn -> {
            if (btn == ButtonType.APPLY) {
                Transaction trx = Transactions.begin();
                try {
                    try {
                        StructureObjectDAO.createCopy((Transaction)trx, (StructureObject)srcObject, (StructureObjectCopyOptions)dlg.getCopyOptions());
                        Transactions.commitSync((Transaction)trx);
                    }
                    catch (Exception exc) {
                        ExceptionDialog excDlg = new ExceptionDialog((Throwable)exc);
                        excDlg.initOwner(scene.getWindow());
                        excDlg.show();
                        Transactions.close((Transaction)trx);
                    }
                }
                finally {
                    Transactions.close((Transaction)trx);
                }
            }
        });
    }

    @CanExecute
    public boolean canExecute(@Optional @Named(value="org.eclipse.ui.selection") @Named(value="org.eclipse.ui.selection") TreeItem<?> item) {
        if (item == null) {
            return false;
        }
        return item.getValue() instanceof StructureObject;
    }
}

