/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.engin.gui.navi.server.objects.parts;

import de.elpro.ewms.core.client.Transactions;
import de.elpro.ewms.core.client.structure.PropertyDAO;
import de.elpro.ewms.core.client.structure.PropertyGroupDAO;
import de.elpro.ewms.core.client.structure.PropertyValueDAO;
import de.elpro.ewms.core.client.structure.StructureClassDAO;
import de.elpro.ewms.core.client.structure.StructureObjectDAO;
import de.elpro.ewms.core.db.Transaction;
import de.elpro.ewms.core.structure.IPropertyType;
import de.elpro.ewms.core.structure.Property;
import de.elpro.ewms.core.structure.PropertyGroup;
import de.elpro.ewms.core.structure.PropertyTypes;
import de.elpro.ewms.core.structure.PropertyValue;
import de.elpro.ewms.core.structure.StructureClass;
import de.elpro.ewms.core.structure.StructureObject;
import de.elpro.ewms.engin.gui.services.EnginPartUtils;
import de.elpro.ewms.engin.gui.tools.validators.ValidatorUtils;
import de.elpro.ewms.gui.dialogs.DialogFactory;
import de.elpro.ui.fx.binding.Bindings;
import de.elpro.ui.fx.propertysheet.ChoicePropertyItem;
import de.elpro.ui.fx.propertysheet.DynamicEditorPropertyItem;
import de.elpro.ui.fx.propertysheet.IntegerPropertyItem;
import de.elpro.ui.fx.propertysheet.LocalDateTimePropertyItem;
import de.elpro.ui.fx.propertysheet.LocaleStringPropertyItem;
import de.elpro.ui.fx.propertysheet.MultChoicesPropertyItem;
import de.elpro.ui.fx.propertysheet.NumberPropertyItem;
import de.elpro.ui.fx.propertysheet.PaintPropertyItem;
import de.elpro.ui.fx.propertysheet.PropertyItemsHelper;
import de.elpro.ui.fx.propertysheet.StringPropertyItem;
import de.elpro.ui.fx.validator.Validators;
import de.elpro.ui.utils.TextUtils;
import de.elpro.ui.utils.e4.PartUtils;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ReadOnlyBooleanWrapper;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.value.ObservableBooleanValue;
import javafx.beans.value.ObservableValue;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.Priority;
import javafx.stage.Window;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import jidefx.scene.control.validation.ValidationEvent;
import jidefx.scene.control.validation.Validator;
import org.controlsfx.control.PropertySheet;
import org.eclipse.e4.ui.di.Persist;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.workbench.modeling.EPartService;

public class StructureObjectEditPart {
    public static final String ID = "de.elpro.ewms.engin.gui.partdescriptor.objecteditpart";
    @Inject
    private StructureObject structureObject;
    @Inject
    private MPart part;
    @Inject
    private EPartService partService;
    private final PropertySheet sheet = new PropertySheet();
    private final SimpleBooleanProperty hasChanges = new SimpleBooleanProperty(false);
    private final SimpleBooleanProperty hasErrors = new SimpleBooleanProperty(false);
    private Map<Property, DynamicEditorPropertyItem<String>> dynamicProperties = null;
    private NumberPropertyItem<Integer> idItem;

    @PostConstruct
    public void postConstruct(BorderPane parent) {
        Transaction trx = Transactions.begin();
        LinkedList<StructureObject> parentObjects = new LinkedList<StructureObject>();
        LinkedList<StructureClass> allClasses = new LinkedList<StructureClass>();
        List<Object> allowedParents = new LinkedList();
        try {
            if (this.structureObject.getStructureClass() != null) {
                allowedParents = this.getAllowedParents(trx, this.structureObject.getStructureClass());
            }
            if (this.structureObject.getId() != null) {
                this.structureObject = StructureObjectDAO.get((Transaction)trx, (int)this.structureObject.getId());
                for (StructureObject parentObject : this.structureObject.getParents()) {
                    parentObjects.add(StructureObjectDAO.get((Transaction)trx, (int)parentObject.getId()));
                }
                this.structureObject.getParents().clear();
                this.structureObject.getParents().addAll(parentObjects);
            }
            StructureClass[] structureClassArray = StructureClassDAO.getAll((Transaction)trx);
            int n = structureClassArray.length;
            int n2 = 0;
            while (n2 < n) {
                StructureClass clazz = structureClassArray[n2];
                allClasses.add(clazz);
                ++n2;
            }
        }
        finally {
            Transactions.close((Transaction)trx);
        }
        this.idItem = new IntegerPropertyItem("Id", (ObservableValue)this.structureObject.idProperty());
        this.idItem.setReadOnly(true);
        StringPropertyItem keyItem = new StringPropertyItem("Key Identifier", (ObservableValue)this.structureObject.keyProperty());
        keyItem.setValidator(vo -> {
            if (this.structureObject.getKey() == null || this.structureObject.getKey().isEmpty()) {
                return new ValidationEvent(ValidationEvent.VALIDATION_INFO, 0, "You can provide unique key to reference this object directly in formulas.");
            }
            if (Character.isUpperCase(this.structureObject.getKey().charAt(0))) {
                return new ValidationEvent(ValidationEvent.VALIDATION_ERROR, 0, "Object key should not start with capital character.");
            }
            return (ValidationEvent)ValidatorUtils.VAR_NAME_TOKEN_VALIDATOR.call(vo);
        });
        LocaleStringPropertyItem displayNameItem = new LocaleStringPropertyItem("Display Name", (ObservableValue)this.structureObject.nameProperty());
        displayNameItem.setValidator(Validators.createNotEmptyValidator((String)"Display Name cannot be empty"));
        ChoicePropertyItem structureClassItem = new ChoicePropertyItem("Structure Class", (ObservableValue)this.structureObject.structureClassProperty(), allClasses);
        structureClassItem.setValidator(Validators.createNotEmptyValidator((String)"Structure Class must be not empty"));
        structureClassItem.setNullable(false);
        MultChoicesPropertyItem parentObjectsItem = new MultChoicesPropertyItem("Parent Objects", (Collection)this.structureObject.getParents(), allowedParents);
        parentObjectsItem.setTextCallback(p -> {
            if (p.getDescription() != null && !p.getDescription().isBlank()) {
                String descr = TextUtils.getFirstLine((String)p.getDescription(), (int)60);
                return String.format("%s [%s]", p.toString(), descr);
            }
            return p.toString();
        });
        LocalDateTimePropertyItem installedItem = new LocalDateTimePropertyItem(null, "Installed", "Object ist handeld by system beginning with installation timestamp if set.\r\nDo not affect allready available PLC, Supplement and Calculated values.", (ObservableValue)Bindings.mapBidirectionalToLocalDateTime((ObjectProperty)this.structureObject.installedProperty()));
        LocalDateTimePropertyItem removedItem = new LocalDateTimePropertyItem(null, "Removed", "Object ist handeld by system until remove timestamp if set.\r\nAfter removed it will do no comupation and update PLC values for the object.", (ObservableValue)Bindings.mapBidirectionalToLocalDateTime((ObjectProperty)this.structureObject.removedProperty()));
        Validator existsRangeValidator = Validators.createValidator((o, ov, nv) -> this.structureObject.getInstalled() == null || this.structureObject.getRemoved() == null || this.structureObject.getRemoved().isAfter(this.structureObject.getInstalled()), (String)"Exists From must be before Exists Until timestamp");
        installedItem.setValidator(existsRangeValidator);
        removedItem.setValidator(existsRangeValidator);
        installedItem.valueProperty().addListener(il -> removedItem.forceValidate());
        removedItem.valueProperty().addListener(il -> installedItem.forceValidate());
        PaintPropertyItem defaultColorItem = new PaintPropertyItem("Default UI Color", (ObservableValue)this.structureObject.defaultColorProperty());
        IntegerPropertyItem visualOrderPositionItem = new IntegerPropertyItem("Visual Order Position", (ObservableValue)this.structureObject.visualOrderPositionProperty());
        StringPropertyItem plcAliasMap = new StringPropertyItem("Plc Alias Map", (ObservableValue)this.structureObject.plcAliasMapTextProperty());
        plcAliasMap.setPromptText("Ex.: key_1=value1;key_2=value_2;key_3=value_3;");
        StringPropertyItem descriptionItem = new StringPropertyItem("Description", (ObservableValue)this.structureObject.descriptionProperty());
        descriptionItem.useAreaEditor(true);
        descriptionItem.setEditorVgrow(Priority.ALWAYS);
        this.sheet.getItems().addAll((Object[])new PropertySheet.Item[]{this.idItem, keyItem, displayNameItem, structureClassItem, parentObjectsItem, installedItem, removedItem, defaultColorItem, visualOrderPositionItem, plcAliasMap, descriptionItem});
        LinkedList coreItems = new LinkedList(this.sheet.getItems());
        if (this.structureObject.getStructureClass() != null) {
            this.dynamicProperties = this.createPropertyItems();
            this.sheet.getItems().addAll(this.dynamicProperties.values());
        }
        this.hasChanges.bind((ObservableValue)PropertyItemsHelper.createHasChangesProperty((Collection)this.sheet.getItems()));
        this.hasErrors.bind((ObservableValue)PropertyItemsHelper.createHasErrorsProperty((Collection)this.sheet.getItems()));
        this.sheet.setMode(PropertySheet.Mode.CATEGORY);
        parent.setCenter((Node)this.sheet);
        if (this.hasChanges.get()) {
            this.part.setDirty(true);
        }
        this.hasChanges.addListener((o, ov, nv) -> this.part.setDirty(nv.booleanValue()));
        structureClassItem.valueProperty().addListener((o, ov, nv) -> {
            if (nv == null) {
                parentObjectsItem.setChoises(new LinkedList());
                return;
            }
            Transaction rtrx = Transactions.begin();
            try {
                parentObjectsItem.setChoises(this.getAllowedParents(rtrx, (StructureClass)nv));
            }
            finally {
                Transactions.close((Transaction)rtrx);
            }
            LinkedList<DynamicEditorPropertyItem<String>> newItems = new LinkedList<DynamicEditorPropertyItem<String>>(coreItems);
            this.dynamicProperties = this.createPropertyItems();
            newItems.addAll(this.dynamicProperties.values());
            this.sheet.getItems().setAll(newItems);
            this.hasChanges.bind((ObservableValue)PropertyItemsHelper.createHasChangesProperty((Collection)this.sheet.getItems()));
            this.hasErrors.bind((ObservableValue)PropertyItemsHelper.createHasErrorsProperty((Collection)this.sheet.getItems()));
        });
        this.part.setLabel(String.format("Object: %s", this.structureObject.toString()));
    }

    private Map<Property, DynamicEditorPropertyItem<String>> createPropertyItems() {
        LinkedHashMap<Property, DynamicEditorPropertyItem<String>> items = new LinkedHashMap<Property, DynamicEditorPropertyItem<String>>();
        Transaction trx = Transactions.begin();
        try {
            PropertyGroup[] propertyGroupArray = PropertyGroupDAO.getAllByStructureClass((Transaction)trx, (StructureClass)this.structureObject.getStructureClass());
            int n = propertyGroupArray.length;
            int n2 = 0;
            while (n2 < n) {
                PropertyGroup pg = propertyGroupArray[n2];
                Property[] propertyArray = PropertyDAO.get((Transaction)trx, (PropertyGroup)pg);
                int n3 = propertyArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    Property p = propertyArray[n4];
                    p.setGroup(pg);
                    IPropertyType type = PropertyTypes.getPropertyType((String)p.getTypeId());
                    if (type != null) {
                        PropertyValue propertyValue = this.structureObject.getPropertyValue(p);
                        if (propertyValue == null) {
                            propertyValue = new PropertyValue(this.structureObject, p);
                            this.structureObject.getPropertyValues().add(propertyValue);
                        }
                        DynamicEditorPropertyItem dynamicEditorItem = new DynamicEditorPropertyItem(pg.getLocalName(), p.getLocalName(), (ObservableValue)propertyValue.valueProperty());
                        Node editor = this.createValueEditor(type, (javafx.beans.property.Property<String>)propertyValue.valueProperty(), p.getParameter());
                        dynamicEditorItem.setEditor(editor);
                        items.put(p, (DynamicEditorPropertyItem<String>)dynamicEditorItem);
                    }
                    ++n4;
                }
                ++n2;
            }
            LinkedHashMap<Property, DynamicEditorPropertyItem<String>> linkedHashMap = items;
            return linkedHashMap;
        }
        finally {
            Transactions.close((Transaction)trx);
        }
    }

    private <V, P> Node createValueEditor(IPropertyType<V, P> type, javafx.beans.property.Property<String> valuesStrProperty, String paramStr) {
        javafx.beans.property.Property valueProperty = type.createValueProperty(valuesStrProperty);
        Object parameter = type.getParameterConverter() != null ? type.getParameterConverter().fromString(paramStr) : null;
        Node editor = type.createValueEditor(valueProperty, parameter, (ObservableBooleanValue)new ReadOnlyBooleanWrapper(true));
        return editor;
    }

    private List<StructureObject> getAllowedParents(Transaction trx, StructureClass structureClass) {
        return Arrays.asList(StructureClassDAO.getAllowedParentObjects((Transaction)trx, (int)structureClass.getId()));
    }

    @Persist
    public void save() {
        if (!this.hasChanges.get()) {
            return;
        }
        if (this.hasErrors.get()) {
            Alert alert = new Alert(Alert.AlertType.WARNING);
            alert.setContentText(String.format("Cannot save %s. Fix errors first.", this.structureObject.toString()));
            alert.showAndWait();
            return;
        }
        Transaction trx = Transactions.begin();
        try {
            try {
                this.idItem.setValue((Object)StructureObjectDAO.saveOrUpdate((Transaction)trx, (StructureObject)this.structureObject));
                LinkedList<PropertyValue> changedValues = new LinkedList<PropertyValue>();
                for (Map.Entry<Property, DynamicEditorPropertyItem<String>> entry : this.dynamicProperties.entrySet()) {
                    if (!entry.getValue().hasChangesProperty().get()) continue;
                    PropertyValue pv = new PropertyValue(this.structureObject, entry.getKey(), (String)entry.getValue().valueProperty().getValue());
                    changedValues.add(pv);
                }
                PropertyValueDAO.saveOrUpdate((Transaction)trx, changedValues);
                Transactions.commitSync((Transaction)trx);
                PropertyItemsHelper.resetHasChangesProperties((Collection)this.sheet.getItems());
                this.part.setDirty(false);
                this.part.setLabel(this.structureObject.toString());
                EnginPartUtils.refreshItems(this.structureObject, this.part);
            }
            catch (Exception exc) {
                Transactions.rollback((Transaction)trx);
                DialogFactory.showExceptionDialog((String)"Save structure object", (Exception)exc, (Window)this.sheet.getScene().getWindow());
                Transactions.close((Transaction)trx);
                return;
            }
        }
        finally {
            Transactions.close((Transaction)trx);
        }
        PartUtils.refreshParts((EPartService)this.partService, StructureObject.class);
        this.part.setLabel(String.format("Object: %s", this.structureObject.toString()));
    }

    @PreDestroy
    protected void close() {
        this.part.setDirty(false);
    }
}

