/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.engin.gui.navi.server.resources.parts;

import de.elpro.ewms.core.client.Transactions;
import de.elpro.ewms.core.client.resources.ResourceDirectoryDAO;
import de.elpro.ewms.core.db.Transaction;
import de.elpro.ewms.core.resources.ResourceDirectory;
import de.elpro.ewms.core.resources.ResourceDirectoryType;
import de.elpro.ewms.core.structure.StructureClass;
import de.elpro.ewms.engin.gui.services.EnginPartUtils;
import de.elpro.ewms.gui.dialogs.DialogFactory;
import de.elpro.ui.fx.propertysheet.EnumPropertyItem;
import de.elpro.ui.fx.propertysheet.IntegerPropertyItem;
import de.elpro.ui.fx.propertysheet.LocaleStringPropertyItem;
import de.elpro.ui.fx.propertysheet.NumberPropertyItem;
import de.elpro.ui.fx.propertysheet.PasswordPropertyItem;
import de.elpro.ui.fx.propertysheet.PropertyItemsHelper;
import de.elpro.ui.fx.propertysheet.StringPropertyItem;
import de.elpro.ui.fx.validator.Validators;
import de.elpro.ui.utils.e4.PartUtils;
import java.util.Collection;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.value.ObservableValue;
import javafx.scene.Node;
import javafx.scene.Scene;
import javafx.scene.control.Alert;
import javafx.scene.layout.BorderPane;
import javafx.stage.Window;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import org.controlsfx.control.PropertySheet;
import org.eclipse.e4.ui.di.Persist;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.workbench.modeling.EPartService;

public class EditResourceDirectoryPart {
    public static final String ID = "de.elpro.ewms.engin.gui.partdescriptor.editresourcedirectory";
    @Inject
    private ResourceDirectory rd;
    @Inject
    private MPart part;
    @Inject
    private EPartService partService;
    @Inject
    private Scene scene;
    private final PropertySheet sheet = new PropertySheet();
    private final SimpleBooleanProperty hasChanges = new SimpleBooleanProperty(false);
    private final SimpleBooleanProperty hasErrors = new SimpleBooleanProperty(false);
    private NumberPropertyItem<Integer> idItem;

    @PostConstruct
    public void postConstruct(BorderPane parent) {
        Transaction trx = Transactions.begin();
        try {
            if (this.rd.getId() != null) {
                this.rd = ResourceDirectoryDAO.get((Transaction)trx, (int)this.rd.getId());
            }
        }
        finally {
            Transactions.close((Transaction)trx);
        }
        this.idItem = new IntegerPropertyItem("Id", (ObservableValue)this.rd.idProperty());
        this.idItem.setReadOnly(true);
        EnumPropertyItem typeItem = new EnumPropertyItem("Type", ResourceDirectoryType.class, (ObservableValue)this.rd.typeProperty());
        typeItem.setNullable(false);
        typeItem.setValidator(Validators.createNotEmptyValidator());
        LocaleStringPropertyItem nameItem = new LocaleStringPropertyItem("Name", (ObservableValue)this.rd.nameProperty());
        typeItem.setValidator(Validators.createNotEmptyValidator());
        StringPropertyItem remoteAddrItem = new StringPropertyItem("Remote Address", (ObservableValue)this.rd.remoteAddrProperty());
        StringPropertyItem remoteConnectionDataItem = new StringPropertyItem("Remote Connection Data", (ObservableValue)this.rd.remoteConnectionDataProperty());
        StringPropertyItem initialDirectoryItem = new StringPropertyItem("Initial Directory", (ObservableValue)this.rd.initialDirectoryProperty());
        StringPropertyItem loginItem = new StringPropertyItem("Login", (ObservableValue)this.rd.loginProperty());
        PasswordPropertyItem passwordItem = new PasswordPropertyItem("Password", (ObservableValue)this.rd.passwordProperty());
        this.sheet.getItems().addAll((Object[])new PropertySheet.Item[]{this.idItem, typeItem, nameItem, remoteAddrItem, remoteConnectionDataItem, initialDirectoryItem, loginItem, passwordItem});
        this.hasChanges.bind((ObservableValue)PropertyItemsHelper.createHasChangesProperty((Collection)this.sheet.getItems()));
        this.hasErrors.bind((ObservableValue)PropertyItemsHelper.createHasErrorsProperty((Collection)this.sheet.getItems()));
        parent.setCenter((Node)this.sheet);
        this.hasChanges.addListener((o, ov, nv) -> this.part.setDirty(nv.booleanValue()));
    }

    @Persist
    public void save() {
        if (!this.hasChanges.get()) {
            return;
        }
        if (this.hasErrors.get()) {
            Alert alert = new Alert(Alert.AlertType.WARNING);
            alert.initOwner(this.scene.getWindow());
            alert.setContentText(String.format("Cannot save %s. Fix errors first.", this.rd.toString()));
            alert.showAndWait();
            return;
        }
        Transaction trx = Transactions.begin();
        try {
            try {
                this.idItem.setValue((Object)ResourceDirectoryDAO.saveOrUpdate((Transaction)trx, (ResourceDirectory)this.rd));
                Transactions.commitSync((Transaction)trx);
                PropertyItemsHelper.resetHasChangesProperties((Collection)this.sheet.getItems());
                this.part.setDirty(false);
                this.part.setLabel(this.rd.toString());
                EnginPartUtils.refreshItems(this.rd, this.part);
            }
            catch (Exception exc) {
                Transactions.rollback((Transaction)trx);
                DialogFactory.showExceptionDialog((String)"Save resource directory", (Exception)exc, (Window)this.sheet.getScene().getWindow());
                Transactions.close((Transaction)trx);
                return;
            }
        }
        finally {
            Transactions.close((Transaction)trx);
        }
        PartUtils.refreshParts((EPartService)this.partService, StructureClass.class);
        this.part.setLabel(String.format("Resource Directory: %s", this.rd.toString()));
    }

    @PreDestroy
    protected void close() {
        this.part.setDirty(false);
    }
}

