/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.engin.gui.navi.server.schedules;

import de.elpro.ewms.core.client.Transactions;
import de.elpro.ewms.core.client.schedules.ScheduleDAO;
import de.elpro.ewms.core.db.Transaction;
import de.elpro.ewms.core.schedules.Schedule;
import de.elpro.ewms.engin.gui.navi.model.INavigationTreeElement;
import de.elpro.ewms.engin.gui.navi.model.LazyNavigationContribution;
import de.elpro.ewms.engin.gui.navi.server.schedules.handlers.ScheduleEditHandler;
import de.elpro.ewms.gui.utils.e4.EOSPartUtils;
import de.elpro.ui.model.UIModelElement;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Function;
import javafx.scene.control.TreeItem;
import javax.inject.Inject;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.workbench.modeling.EModelService;

public class CreateSchedulesNaviTreeHandler
extends LazyNavigationContribution<UIModelElement> {
    private Function<TreeItem<UIModelElement>, List<TreeItem<UIModelElement>>> LIST_CREATOR = new Function<TreeItem<UIModelElement>, List<TreeItem<UIModelElement>>>(){

        @Override
        public List<TreeItem<UIModelElement>> apply(TreeItem<UIModelElement> item) {
            LinkedList<TreeItem<UIModelElement>> elements = new LinkedList<TreeItem<UIModelElement>>();
            Transaction trx = Transactions.begin();
            try {
                if (item.getValue() == null || item.getValue() instanceof INavigationTreeElement) {
                    elements.addAll(CreateSchedulesNaviTreeHandler.this.createTreeItemCollection((UIModelElement[])ScheduleDAO.getAll((Transaction)trx)));
                }
            }
            finally {
                Transactions.close((Transaction)trx);
            }
            return elements;
        }
    };
    @Inject
    private MApplication app;
    @Inject
    private EModelService modelService;

    @Override
    public Function<TreeItem<UIModelElement>, List<TreeItem<UIModelElement>>> getChildrenCreator() {
        return this.LIST_CREATOR;
    }

    @Execute
    public void execute() {
    }

    @Override
    public String getContextMenuId() {
        return "de.elpro.ewms.engin.gui.menu.navi.schedules";
    }

    @Override
    public void onTreeItemClick(Object sender, TreeItem<UIModelElement> treeItem) {
        if (treeItem != null && treeItem.getValue() instanceof Schedule) {
            new ScheduleEditHandler().execute(this.app, treeItem);
        }
    }

    @Override
    public void onTreeItemDoubleClick(Object sender, TreeItem<UIModelElement> treeItem) {
        EOSPartUtils.pinSelectedMPart((EModelService)this.modelService, (MApplication)this.app, (String)"de.elpro.ewms.engin.gui.partstack.editors");
    }
}

