/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.engin.gui.navi.server.schedules.handlers;

import de.elpro.ewms.core.client.Transactions;
import de.elpro.ewms.core.client.schedules.ScheduleDAO;
import de.elpro.ewms.core.db.Transaction;
import de.elpro.ewms.core.schedules.Schedule;
import de.elpro.ui.concurrent.CallableTask;
import de.elpro.ui.fx.utils.TaskUtils;
import javafx.application.Platform;
import javafx.concurrent.Worker;
import javafx.scene.Scene;
import javafx.scene.control.Alert;
import javafx.scene.control.ButtonType;
import javafx.scene.control.TreeItem;
import javax.inject.Named;
import org.eclipse.e4.core.di.annotations.CanExecute;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.core.di.annotations.Optional;

public class ScheduleExecuteNowHandler {
    @Execute
    public void execute(@Optional @Named(value="org.eclipse.ui.selection") @Named(value="org.eclipse.ui.selection") TreeItem<?> item, Scene scene) {
        Alert alert = new Alert(Alert.AlertType.CONFIRMATION, "Execute", new ButtonType[]{ButtonType.OK, ButtonType.CANCEL});
        alert.initOwner(scene.getWindow());
        alert.setContentText(String.format("Execute '%s' now?", item.getValue().toString()));
        alert.showAndWait().ifPresent(buttonType -> {
            if (buttonType == ButtonType.OK) {
                Transaction trx = Transactions.begin();
                try {
                    final Schedule schedule = ScheduleDAO.get((Transaction)trx, (int)((Schedule)item.getValue()).getId());
                    CallableTask<Void> task = new CallableTask<Void>(){
                        {
                            this.updateTitle(String.format("Executing schedule job for '%s'", schedule2.toString()));
                        }

                        public Void call() throws Exception {
                            ScheduleDAO.executeSync((Schedule)schedule);
                            return null;
                        }
                    };
                    TaskUtils.executeUITask((CallableTask)task).consumeResult((arg_0, arg_1) -> ScheduleExecuteNowHandler.lambda$1(scene, (CallableTask)task, arg_0, arg_1));
                }
                finally {
                    Transactions.close((Transaction)trx);
                }
            }
        });
    }

    @CanExecute
    public boolean canExecute(@Optional @Named(value="org.eclipse.ui.selection") @Named(value="org.eclipse.ui.selection") TreeItem<?> item) {
        return item != null && item.getValue() instanceof Schedule;
    }

    private static /* synthetic */ void lambda$1(Scene scene, CallableTask callableTask, Worker.State status, Void result) {
        Platform.runLater(() -> {
            Alert info = new Alert(status == Worker.State.SUCCEEDED ? Alert.AlertType.INFORMATION : Alert.AlertType.ERROR);
            info.initOwner(scene.getWindow());
            info.setContentText(status == Worker.State.SUCCEEDED ? "OK" : "Error");
            info.show();
            TaskUtils.removeTaskFromView((CallableTask)callableTask);
        });
    }
}

