/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.engin.gui.navi.server.schedules.part;

import de.elpro.ewms.core.client.Transactions;
import de.elpro.ewms.core.client.schedules.ScheduleDAO;
import de.elpro.ewms.core.db.DAOOperationException;
import de.elpro.ewms.core.db.Transaction;
import de.elpro.ewms.core.schedules.JobDescriptor;
import de.elpro.ewms.core.schedules.Schedule;
import de.elpro.ewms.core.time.Timeline;
import de.elpro.ewms.core.virtualtime.ComplexRaster;
import de.elpro.ewms.engin.gui.services.EnginPartUtils;
import de.elpro.ui.fx.propertysheet.BooleanPropertyItem;
import de.elpro.ui.fx.propertysheet.ChoicePropertyItem;
import de.elpro.ui.fx.propertysheet.IntegerPropertyItem;
import de.elpro.ui.fx.propertysheet.LocalDateTimePropertyItem;
import de.elpro.ui.fx.propertysheet.NumberPropertyItem;
import de.elpro.ui.fx.propertysheet.PropertyItemsHelper;
import de.elpro.ui.fx.propertysheet.StringPropertyItem;
import de.elpro.ui.fx.validator.Validators;
import de.elpro.ui.utils.e4.PartUtils;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import javafx.beans.property.ReadOnlyProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableValue;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.layout.BorderPane;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import org.controlsfx.control.PropertySheet;
import org.controlsfx.dialog.ExceptionDialog;
import org.eclipse.e4.ui.di.Persist;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.workbench.modeling.EPartService;

public class ScheduleEditPart {
    public static final String ID = "de.elpro.ewms.engin.gui.partdescriptor.schedules";
    @Inject
    private Schedule schedule;
    @Inject
    private MPart part;
    @Inject
    private EPartService partService;
    private final PropertySheet sheet = new PropertySheet();
    private final SimpleBooleanProperty hasChanges = new SimpleBooleanProperty(false);
    private final SimpleBooleanProperty hasErrors = new SimpleBooleanProperty(false);
    private NumberPropertyItem<Integer> idItem;

    @PostConstruct
    public void postConstruct(BorderPane parent) {
        SimpleObjectProperty descriptorProperty = new SimpleObjectProperty();
        LinkedList<JobDescriptor> descriptors = new LinkedList<JobDescriptor>();
        Transaction trx = Transactions.begin();
        try {
            if (this.schedule.getId() != null) {
                this.schedule = ScheduleDAO.get((Transaction)trx, (int)this.schedule.getId());
            }
            JobDescriptor[] jobDescriptorArray = ScheduleDAO.getJobDescriptors();
            int n = jobDescriptorArray.length;
            int n2 = 0;
            while (n2 < n) {
                JobDescriptor descriptor = jobDescriptorArray[n2];
                if (descriptor.getJobId().equals(this.schedule.getJobId())) {
                    descriptorProperty.set((Object)descriptor);
                }
                descriptors.add(descriptor);
                ++n2;
            }
        }
        finally {
            Transactions.close((Transaction)trx);
        }
        this.idItem = new IntegerPropertyItem("Id", (ObservableValue)this.schedule.idProperty());
        this.idItem.setReadOnly(true);
        BooleanPropertyItem activeItem = new BooleanPropertyItem("Active", (ReadOnlyProperty)this.schedule.activeProperty());
        StringPropertyItem nameItem = new StringPropertyItem("Name", (ObservableValue)this.schedule.nameProperty());
        nameItem.setValidator(Validators.createNotEmptyValidator((String)"Name must be not empty"));
        ChoicePropertyItem descriptorItem = new ChoicePropertyItem("Job", (ObservableValue)descriptorProperty, descriptors);
        descriptorItem.setNullable(false);
        descriptorItem.setValidator(Validators.createNotEmptyValidator((String)"Job must be selected"));
        descriptorProperty.addListener((o, ov, nv) -> this.schedule.setJobId(nv != null ? nv.getJobId() : null));
        LocalDateTimePropertyItem jobBeginItem = new LocalDateTimePropertyItem("Begin", (ObservableValue)this.schedule.jobBeginProperty());
        jobBeginItem.setValidator(Validators.createNotEmptyValidator((String)"Begin Time for Job execution must be selected"));
        LocalDateTimePropertyItem jobEndItem = new LocalDateTimePropertyItem("End", (ObservableValue)this.schedule.jobEndProperty());
        ChoicePropertyItem intervalItem = new ChoicePropertyItem("Execution Interval", (ObservableValue)this.schedule.executionIntervalProperty(), Arrays.asList(ComplexRaster.values()));
        intervalItem.setValidator(Validators.createNotEmptyValidator((String)"Select execution interval"));
        StringPropertyItem optionsItem = new StringPropertyItem("Options", (ObservableValue)this.schedule.optionsProperty());
        optionsItem.useAreaEditor(true);
        IntegerPropertyItem visualOrderPosition = new IntegerPropertyItem("Visual Order Position", (ObservableValue)this.schedule.visualOrderPositionProperty());
        StringPropertyItem descriptionItem = new StringPropertyItem("Description", (ObservableValue)this.schedule.descriptionProperty());
        descriptionItem.useAreaEditor(true);
        if (descriptorProperty.get() != null) {
            optionsItem.setPromptText(((JobDescriptor)descriptorProperty.get()).getDefaultOptions());
        }
        descriptorItem.valueProperty().addListener((o, ov, nv) -> {
            if (nv != null) {
                optionsItem.setPromptText(nv.getDefaultOptions());
                if (optionsItem.getValue() == null || optionsItem.getValue().isBlank()) {
                    optionsItem.setValue((Object)nv.getDefaultOptions());
                }
            }
        });
        this.sheet.getItems().addAll((Object[])new PropertySheet.Item[]{this.idItem, activeItem, nameItem, descriptorItem, jobBeginItem, jobEndItem, intervalItem, optionsItem, visualOrderPosition, descriptionItem});
        this.hasChanges.bind((ObservableValue)PropertyItemsHelper.createHasChangesProperty((Collection)this.sheet.getItems()));
        this.hasErrors.bind((ObservableValue)PropertyItemsHelper.createHasErrorsProperty((Collection)this.sheet.getItems()));
        parent.setCenter((Node)this.sheet);
        this.hasChanges.addListener((o, ov, nv) -> this.part.setDirty(nv.booleanValue()));
        parent.setCenter((Node)this.sheet);
    }

    @Persist
    public void save() {
        if (!this.hasChanges.get()) {
            return;
        }
        if (this.hasErrors.get()) {
            Alert alert = new Alert(Alert.AlertType.WARNING);
            alert.setContentText(String.format("Cannot save %s. Fix errors first.", this.schedule.toString()));
            alert.showAndWait();
            return;
        }
        Transaction trx = Transactions.begin();
        try {
            try {
                this.idItem.setValue((Object)ScheduleDAO.saveOrUpdate((Transaction)trx, (Schedule)this.schedule));
                Transactions.commitSync((Transaction)trx);
                PropertyItemsHelper.resetHasChangesProperties((Collection)this.sheet.getItems());
                this.part.setDirty(false);
                this.part.setLabel(this.schedule.toString());
                EnginPartUtils.refreshItems(this.schedule, this.part);
            }
            catch (DAOOperationException exc) {
                Transactions.rollback((Transaction)trx);
                ExceptionDialog dlg = new ExceptionDialog((Throwable)exc);
                dlg.setContentText("Error saving Schedule");
                dlg.show();
                Transactions.close((Transaction)trx);
                return;
            }
        }
        finally {
            Transactions.close((Transaction)trx);
        }
        PartUtils.refreshParts((EPartService)this.partService, Timeline.class);
    }

    @PreDestroy
    protected void close() {
        this.part.setDirty(false);
    }
}

