/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.engin.gui.navi.server.timeline.parts;

import de.elpro.ewms.core.client.Transactions;
import de.elpro.ewms.core.client.time.PhaseTypeDAO;
import de.elpro.ewms.core.client.time.TimelineDAO;
import de.elpro.ewms.core.client.time.TimelinePhaseDAO;
import de.elpro.ewms.core.db.DAOOperationException;
import de.elpro.ewms.core.db.Transaction;
import de.elpro.ewms.core.time.PhaseType;
import de.elpro.ewms.core.time.Timeline;
import de.elpro.ewms.core.time.TimelinePhase;
import de.elpro.resources.Icons;
import de.elpro.ui.fx.cells.LocalDateTableCell;
import de.elpro.ui.fx.cells.uimodel.UIModelTableCell;
import de.elpro.ui.fx.propertysheet.ChoicePropertyItem;
import de.elpro.ui.fx.propertysheet.LocalDatePropertyItem;
import de.elpro.ui.fx.propertysheet.LocaleStringPropertyItem;
import de.elpro.ui.fx.propertysheet.PropertyItemsHelper;
import de.elpro.ui.fx.utils.FXUtils;
import de.elpro.ui.fx.validator.Validators;
import java.time.LocalDate;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import javafx.beans.binding.Bindings;
import javafx.beans.property.ReadOnlyObjectWrapper;
import javafx.beans.value.ObservableBooleanValue;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.scene.Node;
import javafx.scene.Scene;
import javafx.scene.control.ButtonType;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.Dialog;
import javafx.scene.control.MenuItem;
import javafx.scene.control.SelectionMode;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.image.ImageView;
import javafx.scene.layout.BorderPane;
import javafx.stage.Modality;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import org.controlsfx.control.PropertySheet;
import org.controlsfx.dialog.ExceptionDialog;
import org.eclipse.e4.ui.di.Persist;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;

public class PhaseEditPart {
    public static final String ID = "de.elpro.ewms.engin.gui.partdescriptor.timeline.phase";
    @Inject
    private Timeline timeline;
    @Inject
    private MPart part;
    @Inject
    private Scene scene;
    private ObservableList<TimelinePhase> phases = FXCollections.observableArrayList();
    TableColumn<TimelinePhase, TimelinePhase> nameColumn = new TableColumn("Label");
    TableColumn<TimelinePhase, PhaseType> typeColumn = new TableColumn("Type");
    TableColumn<TimelinePhase, LocalDate> fromColumn = new TableColumn("From");
    private final List<TimelinePhase> deletedPhases = new LinkedList<TimelinePhase>();
    private final List<TimelinePhase> changedPhases = new LinkedList<TimelinePhase>();

    @PostConstruct
    public void postConstruct(BorderPane parent) {
        Transaction trx = Transactions.begin();
        try {
            this.timeline = TimelineDAO.get((Transaction)trx, (int)this.timeline.getId());
            TimelinePhase[] timelinePhaseArray = TimelinePhaseDAO.getAll((Transaction)trx, (Timeline)this.timeline);
            int n = timelinePhaseArray.length;
            int n2 = 0;
            while (n2 < n) {
                TimelinePhase tp = timelinePhaseArray[n2];
                tp.setType(PhaseTypeDAO.get((Transaction)trx, (int)tp.getType().getId()));
                this.phases.add((Object)tp);
                ++n2;
            }
        }
        finally {
            Transactions.close((Transaction)trx);
        }
        TableView tableView = new TableView(this.phases);
        this.nameColumn.setCellValueFactory(cf -> new ReadOnlyObjectWrapper((Object)((TimelinePhase)cf.getValue())));
        this.nameColumn.setCellFactory(cf -> new UIModelTableCell());
        this.typeColumn.setCellValueFactory(cf -> ((TimelinePhase)cf.getValue()).typeProperty());
        this.fromColumn.setCellValueFactory(cf -> ((TimelinePhase)cf.getValue()).fromProperty());
        this.fromColumn.setCellFactory(cf -> new LocalDateTableCell());
        tableView.getColumns().addAll((Object[])new TableColumn[]{this.nameColumn, this.typeColumn, this.fromColumn});
        tableView.getSelectionModel().setSelectionMode(SelectionMode.MULTIPLE);
        FXUtils.addOnMouseDoubleClickListener((TableView)tableView, TimelinePhase.class, phase -> {
            TimelinePhase copy = new TimelinePhase(phase.getTimeline(), phase.getFrom());
            copy.setType(phase.getType());
            copy.setLabel(phase.getLabel());
            EditPhaseDialog editDialog = new EditPhaseDialog(copy);
            editDialog.showAndWait().ifPresent(b -> {
                if (b == ButtonType.OK) {
                    phase.setType(copy.getType());
                    phase.setLabel(copy.getLabel());
                    phase.setFrom(copy.getFrom());
                    Collections.sort(this.phases);
                    this.changedPhases.add((TimelinePhase)phase);
                    this.part.setDirty(true);
                }
            });
        });
        MenuItem addItem = new MenuItem("Add", (Node)new ImageView(Icons.ADD_ITEM_URL.toString()));
        addItem.setOnAction(e -> {
            TimelinePhase newElement = new TimelinePhase(this.timeline, null);
            EditPhaseDialog editDialog = new EditPhaseDialog(newElement);
            editDialog.showAndWait().ifPresent(b -> {
                if (b == ButtonType.OK) {
                    this.phases.add((Object)newElement);
                    Collections.sort(this.phases);
                    this.changedPhases.add(newElement);
                    this.part.setDirty(true);
                }
            });
        });
        MenuItem deleteItem = new MenuItem("Delete", (Node)new ImageView(Icons.DELETE_ITEM_URL.toString()));
        deleteItem.setOnAction(e -> {
            LinkedList toRemove = new LinkedList(tableView.getSelectionModel().getSelectedItems());
            tableView.getSelectionModel().clearSelection();
            this.phases.removeAll(toRemove);
            this.deletedPhases.addAll(toRemove);
            this.part.setDirty(true);
        });
        tableView.setContextMenu(new ContextMenu(new MenuItem[]{addItem, deleteItem}));
        parent.setCenter((Node)tableView);
    }

    @Persist
    public void save() {
        if (this.deletedPhases.isEmpty() && this.changedPhases.isEmpty()) {
            return;
        }
        this.changedPhases.removeAll(this.deletedPhases);
        Transaction trx = Transactions.begin();
        try {
            try {
                for (TimelinePhase deletedPhase : this.deletedPhases) {
                    if (deletedPhase.getId() == null) continue;
                    TimelinePhaseDAO.delete((Transaction)trx, (int)deletedPhase.getId());
                }
                for (TimelinePhase changedPhase : this.changedPhases) {
                    int id = TimelinePhaseDAO.saveOrUpdate((Transaction)trx, (TimelinePhase)changedPhase);
                    if (changedPhase.getId() != null) continue;
                    changedPhase.setId(id);
                }
                Transactions.commitSync((Transaction)trx);
                this.part.setDirty(false);
                this.deletedPhases.clear();
                this.changedPhases.clear();
            }
            catch (DAOOperationException exc) {
                Transactions.rollback((Transaction)trx);
                ExceptionDialog dlg = new ExceptionDialog((Throwable)exc);
                dlg.setContentText("Error saving Timeline");
                dlg.show();
                Transactions.close((Transaction)trx);
            }
        }
        finally {
            Transactions.close((Transaction)trx);
        }
    }

    @PreDestroy
    protected void close() {
        this.part.setDirty(false);
    }

    private class EditPhaseDialog
    extends Dialog<ButtonType> {
        public EditPhaseDialog(TimelinePhase timelinePhase) {
            this.initModality(Modality.WINDOW_MODAL);
            this.initOwner(PhaseEditPart.this.scene.getWindow());
            Transaction trx = Transactions.begin();
            List<PhaseType> types = null;
            try {
                types = Arrays.asList(PhaseTypeDAO.getAll((Transaction)trx, (Timeline)PhaseEditPart.this.timeline));
            }
            finally {
                Transactions.close((Transaction)trx);
            }
            PropertySheet sheet = new PropertySheet();
            sheet.setPrefWidth(500.0);
            sheet.setPrefHeight(200.0);
            ChoicePropertyItem phaseTypeItem = new ChoicePropertyItem(null, "Type", (ObservableValue)timelinePhase.typeProperty(), types);
            phaseTypeItem.setNullable(false);
            phaseTypeItem.setValidator(Validators.createNotEmptyValidator((String)"Phase type must be not empty"));
            LocaleStringPropertyItem nameItem = new LocaleStringPropertyItem(null, "Name", (ObservableValue)timelinePhase.labelProperty());
            nameItem.setValidator(Validators.createNotEmptyValidator((String)"Name must be not empty"));
            LocalDatePropertyItem fromItem = new LocalDatePropertyItem(null, "From", (ObservableValue)timelinePhase.fromProperty());
            fromItem.setValidator(Validators.createNotEmptyValidator((String)"From Date must be not empty"));
            sheet.getItems().addAll((Object[])new PropertySheet.Item[]{phaseTypeItem, nameItem, fromItem});
            ObservableBooleanValue hasChanges = PropertyItemsHelper.createHasChangesProperty((Collection)sheet.getItems());
            ObservableBooleanValue hasErrors = PropertyItemsHelper.createHasErrorsProperty((Collection)sheet.getItems());
            this.getDialogPane().setContent((Node)sheet);
            this.getDialogPane().getButtonTypes().addAll((Object[])new ButtonType[]{ButtonType.CANCEL, ButtonType.OK});
            this.getDialogPane().lookupButton(ButtonType.OK).disableProperty().bind((ObservableValue)Bindings.or((ObservableBooleanValue)hasErrors, (ObservableBooleanValue)Bindings.not((ObservableBooleanValue)hasChanges)));
        }
    }
}

