/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.engin.gui.navi.server.timeline.parts;

import de.elpro.ewms.core.charts.ShapeType;
import de.elpro.ewms.core.client.Transactions;
import de.elpro.ewms.core.client.time.PhaseTypeDAO;
import de.elpro.ewms.core.client.time.TimelineDAO;
import de.elpro.ewms.core.db.DAOOperationException;
import de.elpro.ewms.core.db.Transaction;
import de.elpro.ewms.core.time.PhaseType;
import de.elpro.ewms.core.time.Timeline;
import de.elpro.ewms.engin.gui.services.EnginPartUtils;
import de.elpro.ui.fx.propertysheet.ChoicePropertyItem;
import de.elpro.ui.fx.propertysheet.EnumPropertyItem;
import de.elpro.ui.fx.propertysheet.IntegerPropertyItem;
import de.elpro.ui.fx.propertysheet.LocaleStringPropertyItem;
import de.elpro.ui.fx.propertysheet.NumberPropertyItem;
import de.elpro.ui.fx.propertysheet.PaintPropertyItem;
import de.elpro.ui.fx.propertysheet.PropertyItemsHelper;
import de.elpro.ui.fx.propertysheet.StringPropertyItem;
import de.elpro.ui.fx.validator.Validators;
import de.elpro.ui.model.UIModelElement;
import de.elpro.ui.utils.e4.PartUtils;
import java.util.Collection;
import java.util.LinkedList;
import javafx.beans.property.ReadOnlyObjectWrapper;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.value.ObservableValue;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.TreeItem;
import javafx.scene.layout.BorderPane;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import javax.inject.Named;
import jidefx.scene.control.validation.Validator;
import org.controlsfx.control.PropertySheet;
import org.controlsfx.dialog.ExceptionDialog;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.ui.di.Persist;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.workbench.modeling.EPartService;

public class PhaseTypeEditPart {
    public static final String ID = "de.elpro.ewms.engin.gui.partdescriptor.timeline.phasetype";
    @Inject
    private PhaseType phaseType;
    @Inject
    private MPart part;
    @Inject
    private EPartService partService;
    private final PropertySheet sheet = new PropertySheet();
    private final SimpleBooleanProperty hasChanges = new SimpleBooleanProperty(false);
    private final SimpleBooleanProperty hasErrors = new SimpleBooleanProperty(false);
    private StringPropertyItem keyItem;
    private NumberPropertyItem<Integer> idItem;
    private boolean isNew = false;

    @PostConstruct
    public void postConstruct(BorderPane parent, @Optional @Named(value="org.eclipse.ui.selection") @Named(value="org.eclipse.ui.selection") TreeItem<UIModelElement> item) {
        Transaction trx = Transactions.begin();
        LinkedList<String> unavailableKeys = new LinkedList<String>();
        this.isNew = this.phaseType.getKey() == null;
        Timeline timeline = null;
        try {
            int timelineId = this.phaseType.getTimeline().getId();
            if (this.phaseType.getId() != null) {
                this.phaseType = PhaseTypeDAO.get((Transaction)trx, (int)this.phaseType.getId());
            }
            timeline = TimelineDAO.get((Transaction)trx, (int)timelineId);
            PhaseType[] phaseTypeArray = PhaseTypeDAO.getAll((Transaction)trx);
            int n = phaseTypeArray.length;
            int n2 = 0;
            while (n2 < n) {
                PhaseType pt = phaseTypeArray[n2];
                if (!pt.getKey().equals(this.phaseType.getKey())) {
                    unavailableKeys.add(pt.getKey());
                }
                ++n2;
            }
        }
        finally {
            Transactions.close((Transaction)trx);
        }
        this.idItem = new IntegerPropertyItem("Id", (ObservableValue)this.phaseType.idProperty());
        this.idItem.setReadOnly(true);
        ChoicePropertyItem timelineItem = new ChoicePropertyItem("Timeline", (ObservableValue)new ReadOnlyObjectWrapper((Object)timeline));
        this.keyItem = new StringPropertyItem("Key", (ObservableValue)this.phaseType.keyProperty());
        this.keyItem.setReadOnly(!this.isNew);
        this.keyItem.setValidator(Validators.combine((Validator[])new Validator[]{Validators.createNotEmptyValidator((String)"Key must be not empty"), Validators.createValidator((o, ov, nv) -> !unavailableKeys.contains(nv), (String)"This key is allready ocupied")}));
        LocaleStringPropertyItem nameItem = new LocaleStringPropertyItem("Name", (ObservableValue)this.phaseType.nameProperty());
        nameItem.setValidator(Validators.createNotEmptyValidator((String)"Name must be not empty"));
        PaintPropertyItem chartColorItem = new PaintPropertyItem(null, "Def. Color", "Default color for visualisation (Charts)", (ObservableValue)this.phaseType.chartColorProperty());
        EnumPropertyItem chartShapeItem = new EnumPropertyItem(null, "Def. Shape Type", "Default shape type for visualisation (Charts)", ShapeType.class, (ObservableValue)this.phaseType.chartShapeTypeProperty());
        StringPropertyItem descriptionItem = new StringPropertyItem("Description", (ObservableValue)this.phaseType.descriptionProperty());
        descriptionItem.useAreaEditor(true);
        this.sheet.getItems().addAll((Object[])new PropertySheet.Item[]{this.idItem, timelineItem, this.keyItem, nameItem, chartColorItem, chartShapeItem, descriptionItem});
        this.hasChanges.bind((ObservableValue)PropertyItemsHelper.createHasChangesProperty((Collection)this.sheet.getItems()));
        this.hasErrors.bind((ObservableValue)PropertyItemsHelper.createHasErrorsProperty((Collection)this.sheet.getItems()));
        this.sheet.setMode(PropertySheet.Mode.CATEGORY);
        parent.setCenter((Node)this.sheet);
        this.hasChanges.addListener((o, ov, nv) -> this.part.setDirty(nv.booleanValue()));
        parent.setCenter((Node)this.sheet);
    }

    @Persist
    public void save() {
        if (!this.hasChanges.get()) {
            return;
        }
        if (this.hasErrors.get()) {
            Alert alert = new Alert(Alert.AlertType.WARNING);
            alert.setContentText(String.format("Cannot save %s. Fix errors first.", this.phaseType.toString()));
            alert.showAndWait();
            return;
        }
        Transaction trx = Transactions.begin();
        try {
            try {
                this.idItem.setValue((Object)PhaseTypeDAO.saveOrUpdate((Transaction)trx, (PhaseType)this.phaseType));
                Transactions.commitSync((Transaction)trx);
                if (this.isNew) {
                    this.keyItem.setReadOnly(true);
                    this.isNew = false;
                }
                PropertyItemsHelper.resetHasChangesProperties((Collection)this.sheet.getItems());
                this.part.setDirty(false);
                this.part.setLabel(this.phaseType.toString());
                EnginPartUtils.refreshItems(this.phaseType, this.part);
            }
            catch (DAOOperationException exc) {
                Transactions.rollback((Transaction)trx);
                ExceptionDialog dlg = new ExceptionDialog((Throwable)exc);
                dlg.setContentText("Error saving Timeline");
                dlg.show();
                Transactions.close((Transaction)trx);
                return;
            }
        }
        finally {
            Transactions.close((Transaction)trx);
        }
        PartUtils.refreshParts((EPartService)this.partService, Timeline.class);
    }

    @PreDestroy
    protected void close() {
        this.part.setDirty(false);
    }
}

