/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.engin.gui.navi.server.timeline.parts;

import de.elpro.ewms.core.client.Transactions;
import de.elpro.ewms.core.client.time.TimelineDAO;
import de.elpro.ewms.core.db.DAOOperationException;
import de.elpro.ewms.core.db.Transaction;
import de.elpro.ewms.core.time.Timeline;
import de.elpro.ewms.core.time.TimelineZone;
import de.elpro.ewms.engin.gui.services.EnginPartUtils;
import de.elpro.ui.fx.propertysheet.EnumPropertyItem;
import de.elpro.ui.fx.propertysheet.IntegerPropertyItem;
import de.elpro.ui.fx.propertysheet.LocaleStringPropertyItem;
import de.elpro.ui.fx.propertysheet.NumberPropertyItem;
import de.elpro.ui.fx.propertysheet.PropertyItemsHelper;
import de.elpro.ui.fx.propertysheet.StringPropertyItem;
import de.elpro.ui.fx.validator.Validators;
import de.elpro.ui.utils.e4.PartUtils;
import java.util.Collection;
import java.util.LinkedList;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.value.ObservableValue;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.layout.BorderPane;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import jidefx.scene.control.validation.Validator;
import org.controlsfx.control.PropertySheet;
import org.controlsfx.dialog.ExceptionDialog;
import org.eclipse.e4.ui.di.Persist;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.workbench.modeling.EPartService;

public class TimelineEditPart {
    public static final String ID = "de.elpro.ewms.engin.gui.partdescriptor.timeline";
    @Inject
    private Timeline timeline;
    @Inject
    private MPart part;
    @Inject
    private EPartService partService;
    private final PropertySheet sheet = new PropertySheet();
    private final SimpleBooleanProperty hasChanges = new SimpleBooleanProperty(false);
    private final SimpleBooleanProperty hasErrors = new SimpleBooleanProperty(false);
    private NumberPropertyItem<Integer> idItem;
    private StringPropertyItem keyItem;
    private boolean isNew = false;

    @PostConstruct
    public void postConstruct(BorderPane parent) {
        Transaction trx = Transactions.begin();
        LinkedList<String> unavailableKeys = new LinkedList<String>();
        this.isNew = this.timeline.getKey() == null;
        try {
            if (this.timeline.getKey() != null) {
                this.timeline = TimelineDAO.get((Transaction)trx, (int)this.timeline.getId());
            }
            Timeline[] timelineArray = TimelineDAO.getAll((Transaction)trx);
            int n = timelineArray.length;
            int n2 = 0;
            while (n2 < n) {
                Timeline timeline = timelineArray[n2];
                if (!timeline.getKey().equals(timeline.getKey())) {
                    unavailableKeys.add(timeline.getKey());
                }
                ++n2;
            }
        }
        finally {
            Transactions.close((Transaction)trx);
        }
        this.idItem = new IntegerPropertyItem("Id", (ObservableValue)this.timeline.idProperty());
        this.idItem.setReadOnly(true);
        this.keyItem = new StringPropertyItem("Key", (ObservableValue)this.timeline.keyProperty());
        this.keyItem.setReadOnly(!this.isNew);
        this.keyItem.setValidator(Validators.combine((Validator[])new Validator[]{Validators.createNotEmptyValidator((String)"Key must be not empty"), Validators.createValidator((o, ov, nv) -> !unavailableKeys.contains(nv), (String)"This key is allready ocupied")}));
        LocaleStringPropertyItem nameItem = new LocaleStringPropertyItem("Name", (ObservableValue)this.timeline.nameProperty());
        nameItem.setValidator(Validators.createNotEmptyValidator((String)"Name must be not empty"));
        EnumPropertyItem zoneItem = new EnumPropertyItem("Reference Zone", null, TimelineZone.class, (ObservableValue)this.timeline.zoneProperty());
        zoneItem.setNullable(false);
        IntegerPropertyItem visualOrderPosition = new IntegerPropertyItem("Visual Order Position", (ObservableValue)this.timeline.visualOrderPositionProperty());
        StringPropertyItem descriptionItem = new StringPropertyItem("Description", (ObservableValue)this.timeline.descriptionProperty());
        descriptionItem.useAreaEditor(true);
        this.sheet.getItems().addAll((Object[])new PropertySheet.Item[]{this.idItem, this.keyItem, nameItem, zoneItem, visualOrderPosition, descriptionItem});
        this.hasChanges.bind((ObservableValue)PropertyItemsHelper.createHasChangesProperty((Collection)this.sheet.getItems()));
        this.hasErrors.bind((ObservableValue)PropertyItemsHelper.createHasErrorsProperty((Collection)this.sheet.getItems()));
        parent.setCenter((Node)this.sheet);
        this.hasChanges.addListener((o, ov, nv) -> this.part.setDirty(nv.booleanValue()));
        parent.setCenter((Node)this.sheet);
    }

    @Persist
    public void save() {
        if (!this.hasChanges.get()) {
            return;
        }
        if (this.hasErrors.get()) {
            Alert alert = new Alert(Alert.AlertType.WARNING);
            alert.setContentText(String.format("Cannot save %s. Fix errors first.", this.timeline.toString()));
            alert.showAndWait();
            return;
        }
        Transaction trx = Transactions.begin();
        try {
            try {
                this.idItem.setValue((Object)TimelineDAO.saveOrUpdate((Transaction)trx, (Timeline)this.timeline));
                Transactions.commitSync((Transaction)trx);
                if (this.isNew) {
                    this.keyItem.setReadOnly(true);
                    this.isNew = false;
                }
                PropertyItemsHelper.resetHasChangesProperties((Collection)this.sheet.getItems());
                this.part.setDirty(false);
                this.part.setLabel(this.timeline.toString());
                EnginPartUtils.refreshItems(this.timeline, this.part);
            }
            catch (DAOOperationException exc) {
                Transactions.rollback((Transaction)trx);
                ExceptionDialog dlg = new ExceptionDialog((Throwable)exc);
                dlg.setContentText("Error saving Timeline");
                dlg.show();
                Transactions.close((Transaction)trx);
                return;
            }
        }
        finally {
            Transactions.close((Transaction)trx);
        }
        PartUtils.refreshParts((EPartService)this.partService, Timeline.class);
    }

    @PreDestroy
    protected void close() {
        this.part.setDirty(false);
    }
}

