/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.engin.gui.navi.server.units.handlers;

import de.elpro.ewms.core.client.Transactions;
import de.elpro.ewms.core.client.units.MeasuringUnitDAO;
import de.elpro.ewms.core.client.units.PhysicalUnitDAO;
import de.elpro.ewms.core.db.Transaction;
import de.elpro.ewms.core.units.MeasuringUnitDefinition;
import de.elpro.ewms.core.units.PhysicalUnitDefinition;
import de.elpro.ewms.engin.gui.navi.model.INavigationTreeElement;
import de.elpro.ewms.engin.gui.navi.model.LazyNavigationContribution;
import de.elpro.ewms.engin.gui.navi.server.units.handlers.PredefinedMeasuringUnitView;
import de.elpro.ewms.engin.gui.navi.server.units.handlers.PredefinedPhysicalUnitView;
import de.elpro.ewms.engin.gui.navi.server.units.handlers.UnitsEditHandler;
import de.elpro.ewms.gui.utils.e4.EOSPartUtils;
import de.elpro.ui.model.UIModelElement;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Function;
import javafx.scene.control.TreeItem;
import javax.inject.Inject;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.workbench.modeling.EModelService;

public class CreateUnitsTreeHandler
extends LazyNavigationContribution<UIModelElement> {
    private Function<TreeItem<UIModelElement>, List<TreeItem<UIModelElement>>> LIST_CREATOR = new Function<TreeItem<UIModelElement>, List<TreeItem<UIModelElement>>>(){

        @Override
        public List<TreeItem<UIModelElement>> apply(TreeItem<UIModelElement> item) {
            LinkedList<TreeItem<UIModelElement>> elements = new LinkedList<TreeItem<UIModelElement>>();
            Transaction trx = Transactions.begin();
            try {
                if (item.getValue() == null || item.getValue() instanceof INavigationTreeElement) {
                    PhysicalUnitDefinition[] physicalUnitDefinitionArray = PhysicalUnitDAO.getAllPredefined();
                    int n = physicalUnitDefinitionArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        PhysicalUnitDefinition pud = physicalUnitDefinitionArray[n2];
                        elements.add((TreeItem<UIModelElement>)CreateUnitsTreeHandler.this.createLazyTreeItem(new PredefinedPhysicalUnitView(pud)));
                        ++n2;
                    }
                    elements.addAll(CreateUnitsTreeHandler.this.createLazyTreeItemCollection((UIModelElement[])PhysicalUnitDAO.getAllDynamic((Transaction)trx)));
                } else if (item.getValue() instanceof PhysicalUnitDefinition || item.getValue() instanceof PredefinedPhysicalUnitView) {
                    String pudKey = item.getValue() instanceof PhysicalUnitDefinition ? ((PhysicalUnitDefinition)item.getValue()).getKey() : ((PredefinedPhysicalUnitView)item.getValue()).getDefinition().getKey();
                    MeasuringUnitDefinition[] measuringUnitDefinitionArray = MeasuringUnitDAO.getAllPredefined((String)pudKey);
                    int n = measuringUnitDefinitionArray.length;
                    int n3 = 0;
                    while (n3 < n) {
                        MeasuringUnitDefinition mud = measuringUnitDefinitionArray[n3];
                        elements.add((TreeItem<UIModelElement>)new TreeItem((Object)new PredefinedMeasuringUnitView(mud)));
                        ++n3;
                    }
                    elements.addAll(CreateUnitsTreeHandler.this.createTreeItemCollection((UIModelElement[])MeasuringUnitDAO.getAllDynamic((Transaction)trx, (String)pudKey)));
                }
            }
            finally {
                Transactions.close((Transaction)trx);
            }
            return elements;
        }
    };
    @Inject
    private MApplication app;
    @Inject
    private EModelService modelService;

    @Execute
    public void execute() {
    }

    @Override
    public Function<TreeItem<UIModelElement>, List<TreeItem<UIModelElement>>> getChildrenCreator() {
        return this.LIST_CREATOR;
    }

    @Override
    public String getContextMenuId() {
        return "de.elpro.ewms.engin.gui.menu.navi.units";
    }

    @Override
    public void onTreeItemClick(Object sender, TreeItem<UIModelElement> treeItem) {
        UnitsEditHandler editHandler = new UnitsEditHandler();
        if (treeItem != null && editHandler.canExecute(treeItem)) {
            editHandler.execute(this.app, treeItem);
        }
    }

    @Override
    public void onTreeItemDoubleClick(Object sender, TreeItem<UIModelElement> treeItem) {
        EOSPartUtils.pinSelectedMPart((EModelService)this.modelService, (MApplication)this.app, (String)"de.elpro.ewms.engin.gui.partstack.editors");
    }
}

