/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.engin.gui.navi.server.units.handlers;

import de.elpro.ewms.core.client.Transactions;
import de.elpro.ewms.core.client.units.MeasuringUnitDAO;
import de.elpro.ewms.core.client.units.PhysicalUnitDAO;
import de.elpro.ewms.core.db.DAOOperationException;
import de.elpro.ewms.core.db.Transaction;
import de.elpro.ewms.core.units.MeasuringUnitDefinition;
import de.elpro.ewms.core.units.PhysicalUnitDefinition;
import javafx.scene.Scene;
import javafx.scene.control.Alert;
import javafx.scene.control.ButtonType;
import javafx.scene.control.TreeItem;
import javax.inject.Named;
import org.controlsfx.dialog.ExceptionDialog;
import org.eclipse.e4.core.di.annotations.CanExecute;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.core.di.annotations.Optional;

public class DeletePhysicalUnitHandler {
    @Execute
    public void execute(@Optional @Named(value="org.eclipse.ui.selection") @Named(value="org.eclipse.ui.selection") TreeItem<?> item, Scene scene) {
        Alert alert = new Alert(Alert.AlertType.WARNING, "Test", new ButtonType[]{ButtonType.OK, ButtonType.CANCEL});
        alert.initOwner(scene.getWindow());
        alert.setContentText(String.format("Do you really want do delete '%s'?", item.getValue().toString()));
        alert.showAndWait().ifPresent(buttonType -> {
            if (buttonType == ButtonType.OK) {
                Transaction trx = Transactions.begin();
                try {
                    try {
                        if (item.getValue() instanceof PhysicalUnitDefinition) {
                            PhysicalUnitDAO.delete((Transaction)trx, (int)((PhysicalUnitDefinition)item.getValue()).getId());
                        } else if (item.getValue() instanceof MeasuringUnitDefinition) {
                            MeasuringUnitDAO.delete((Transaction)trx, (int)((MeasuringUnitDefinition)item.getValue()).getId());
                        }
                        Transactions.commitSync((Transaction)trx);
                        item.getParent().getChildren().remove((Object)item);
                    }
                    catch (DAOOperationException exc) {
                        Transactions.rollback((Transaction)trx);
                        ExceptionDialog exceptionDialog = new ExceptionDialog((Throwable)exc);
                        exceptionDialog.setContentText(String.format("Error ocured during deleting of '%s'", item.getValue()));
                        exceptionDialog.show();
                        Transactions.close((Transaction)trx);
                    }
                }
                finally {
                    Transactions.close((Transaction)trx);
                }
            }
        });
    }

    @CanExecute
    public boolean canExecute(@Optional @Named(value="org.eclipse.ui.selection") @Named(value="org.eclipse.ui.selection") TreeItem<?> item) {
        return item != null && (item.getValue() instanceof PhysicalUnitDefinition || item.getValue() instanceof MeasuringUnitDefinition);
    }
}

