/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.engin.gui.navi.server.units.parts;

import de.elpro.ewms.core.client.Transactions;
import de.elpro.ewms.core.client.units.MeasuringUnitDAO;
import de.elpro.ewms.core.db.DAOOperationException;
import de.elpro.ewms.core.db.Transaction;
import de.elpro.ewms.core.tables.Column;
import de.elpro.ewms.core.units.MeasuringUnitDefinition;
import de.elpro.ewms.engin.gui.services.EnginPartUtils;
import de.elpro.ewms.engin.gui.tools.validators.ValidatorUtils;
import de.elpro.ui.fx.propertysheet.DoublePropertyItem;
import de.elpro.ui.fx.propertysheet.IntegerPropertyItem;
import de.elpro.ui.fx.propertysheet.NumberPropertyItem;
import de.elpro.ui.fx.propertysheet.PropertyItemsHelper;
import de.elpro.ui.fx.propertysheet.StringPropertyItem;
import de.elpro.ui.fx.validator.Validators;
import de.elpro.ui.utils.e4.PartUtils;
import java.util.Arrays;
import java.util.Collection;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.value.ObservableValue;
import javafx.scene.Node;
import javafx.scene.Scene;
import javafx.scene.control.Alert;
import javafx.scene.layout.BorderPane;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import org.controlsfx.control.PropertySheet;
import org.controlsfx.dialog.ExceptionDialog;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.ui.di.Persist;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.workbench.modeling.EPartService;

public class MeasuringUnitEditPart {
    public static final String ID = "de.elpro.ewms.engin.gui.partdescriptor.units.measuringunit";
    @Inject
    private IEclipseContext context;
    @Inject
    private MeasuringUnitDefinition muDefinition;
    @Inject
    private MPart part;
    @Inject
    private EPartService partService;
    @Inject
    private Scene scene;
    private final PropertySheet sheet = new PropertySheet();
    private final SimpleBooleanProperty hasChanges = new SimpleBooleanProperty(false);
    private final SimpleBooleanProperty hasErrors = new SimpleBooleanProperty(false);
    private NumberPropertyItem<Integer> idItem;

    @PostConstruct
    public void postConstruct(BorderPane parent) {
        Transaction trx = Transactions.begin();
        try {
            if (this.muDefinition.getId() != null) {
                this.muDefinition = MeasuringUnitDAO.get((Transaction)trx, (int)this.muDefinition.getId());
            }
        }
        finally {
            Transactions.close((Transaction)trx);
        }
        boolean readOnly = this.muDefinition.getKey() != null && Arrays.stream(MeasuringUnitDAO.getAllPredefined((String)this.muDefinition.getPhysicalUnitKey())).anyMatch(pud -> pud.getKey().equals(this.muDefinition.getKey()));
        this.idItem = new IntegerPropertyItem("Id", (ObservableValue)this.muDefinition.idProperty());
        this.idItem.setReadOnly(true);
        StringPropertyItem puKeyItem = new StringPropertyItem("Physical Unit Key", (ObservableValue)this.muDefinition.physicalUnitKeyProperty());
        puKeyItem.setReadOnly(true);
        StringPropertyItem keyItem = new StringPropertyItem("Key", (ObservableValue)this.muDefinition.keyProperty());
        keyItem.setValidator(ValidatorUtils.UNIT_KEY_VALIDATOR);
        StringPropertyItem commonCodeItem = new StringPropertyItem("Common Code", (ObservableValue)this.muDefinition.commonCodeProperty());
        DoublePropertyItem factorItem = new DoublePropertyItem("Factor", (ObservableValue)this.muDefinition.factorProperty());
        factorItem.setValidator(Validators.createNotEmptyValidator((String)"Factor cannot be empty"));
        DoublePropertyItem divisorItem = new DoublePropertyItem("Divisor", (ObservableValue)this.muDefinition.divisorProperty());
        factorItem.setValidator(Validators.createNotEmptyValidator((String)"Factor cannot be empty"));
        DoublePropertyItem addendItem = new DoublePropertyItem("Addend", (ObservableValue)this.muDefinition.addendProperty());
        factorItem.setValidator(Validators.createNotEmptyValidator((String)"Addend cannot be empty"));
        StringPropertyItem sduItem = new StringPropertyItem("Simple Display Unit", (ObservableValue)this.muDefinition.simpleDisplayUnitProperty());
        this.sheet.getItems().addAll((Object[])new PropertySheet.Item[]{this.idItem, puKeyItem, keyItem, commonCodeItem, factorItem, divisorItem, addendItem, sduItem});
        this.hasChanges.bind((ObservableValue)PropertyItemsHelper.createHasChangesProperty((Collection)this.sheet.getItems()));
        this.hasErrors.bind((ObservableValue)PropertyItemsHelper.createHasErrorsProperty((Collection)this.sheet.getItems()));
        parent.setCenter((Node)this.sheet);
        if (readOnly) {
            PropertyItemsHelper.setReadOnly((Collection)this.sheet.getItems());
        }
        this.hasChanges.addListener((o, ov, nv) -> this.part.setDirty(nv != false || this.muDefinition.getId() == null));
    }

    @Persist
    public void save() {
        if (!this.hasChanges.get() && this.idItem.getValue() != null) {
            return;
        }
        if (this.hasErrors.get()) {
            Alert alert = new Alert(Alert.AlertType.WARNING);
            alert.setContentText(String.format("Cannot save %s. Fix errors first.", this.muDefinition.toString()));
            alert.showAndWait();
            return;
        }
        Transaction trx = Transactions.begin();
        try {
            try {
                this.idItem.setValue((Object)MeasuringUnitDAO.saveOrUpdate((Transaction)trx, (MeasuringUnitDefinition)this.muDefinition));
                Transactions.commitSync((Transaction)trx);
                PropertyItemsHelper.resetHasChangesProperties((Collection)this.sheet.getItems());
                this.part.setDirty(false);
                this.part.setLabel(this.muDefinition.toString());
                EnginPartUtils.refreshItems(this.muDefinition, this.part);
            }
            catch (DAOOperationException exc) {
                Transactions.rollback((Transaction)trx);
                ExceptionDialog dlg = new ExceptionDialog((Throwable)exc);
                dlg.initOwner(this.scene.getWindow());
                dlg.setContentText("Error saving measuring unit");
                dlg.show();
                Transactions.close((Transaction)trx);
                return;
            }
        }
        finally {
            Transactions.close((Transaction)trx);
        }
        PartUtils.refreshParts((EPartService)this.partService, Column.class);
        Alert alert = new Alert(Alert.AlertType.INFORMATION);
        alert.initOwner(this.scene.getWindow());
        alert.setContentText("Measuring Units are cached on client side.\r\nAll clients needs to be restartet to apply changes!");
        alert.show();
    }

    @PreDestroy
    protected void close() {
        this.part.setDirty(false);
    }
}

