/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.engin.gui.navi.server.units.parts;

import de.elpro.ewms.core.client.Transactions;
import de.elpro.ewms.core.client.units.PhysicalUnitDAO;
import de.elpro.ewms.core.db.DAOOperationException;
import de.elpro.ewms.core.db.Transaction;
import de.elpro.ewms.core.tables.Column;
import de.elpro.ewms.core.units.Aggregation;
import de.elpro.ewms.core.units.PhysicalUnitDefinition;
import de.elpro.ewms.engin.gui.services.EnginPartUtils;
import de.elpro.ewms.engin.gui.tools.validators.ValidatorUtils;
import de.elpro.ui.fx.propertysheet.EnumPropertyItem;
import de.elpro.ui.fx.propertysheet.IntegerPropertyItem;
import de.elpro.ui.fx.propertysheet.NumberPropertyItem;
import de.elpro.ui.fx.propertysheet.PropertyItemsHelper;
import de.elpro.ui.fx.propertysheet.StringPropertyItem;
import de.elpro.ui.fx.validator.Validators;
import de.elpro.ui.utils.e4.PartUtils;
import java.util.Arrays;
import java.util.Collection;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.value.ObservableValue;
import javafx.scene.Node;
import javafx.scene.Scene;
import javafx.scene.control.Alert;
import javafx.scene.layout.BorderPane;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import jidefx.scene.control.validation.Validator;
import org.controlsfx.control.PropertySheet;
import org.controlsfx.dialog.ExceptionDialog;
import org.eclipse.e4.ui.di.Persist;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.workbench.modeling.EPartService;

public class PhysicalUnitEditPart {
    public static final String ID = "de.elpro.ewms.engin.gui.partdescriptor.units.physicalunit";
    @Inject
    private PhysicalUnitDefinition puDefinition;
    @Inject
    private MPart part;
    @Inject
    private EPartService partService;
    @Inject
    private Scene scene;
    private final PropertySheet sheet = new PropertySheet();
    private final SimpleBooleanProperty hasChanges = new SimpleBooleanProperty(false);
    private final SimpleBooleanProperty hasErrors = new SimpleBooleanProperty(false);
    private NumberPropertyItem<Integer> idItem;

    @PostConstruct
    public void postConstruct(BorderPane parent) {
        Transaction trx = Transactions.begin();
        try {
            if (this.puDefinition.getId() != null) {
                this.puDefinition = PhysicalUnitDAO.get((Transaction)trx, (int)this.puDefinition.getId());
            }
        }
        finally {
            Transactions.close((Transaction)trx);
        }
        boolean readOnly = this.puDefinition.getKey() != null && Arrays.stream(PhysicalUnitDAO.getAllPredefined()).anyMatch(pud -> pud.getKey().equals(this.puDefinition.getKey()));
        this.idItem = new IntegerPropertyItem("Id", (ObservableValue)this.puDefinition.idProperty());
        this.idItem.setReadOnly(true);
        StringPropertyItem keyItem = new StringPropertyItem("Key", (ObservableValue)this.puDefinition.keyProperty());
        keyItem.setValidator(ValidatorUtils.UNIT_KEY_VALIDATOR);
        StringPropertyItem nameItem = new StringPropertyItem("Name (Token)", (ObservableValue)this.puDefinition.nameProperty());
        nameItem.setValidator(Validators.combine((Validator[])new Validator[]{Validators.createNotEmptyValidator((String)"Token must be not empty"), Validators.createNoBlankCharacterValidator((String)"Token should not contain any blank characters")}));
        EnumPropertyItem aggregationItem = new EnumPropertyItem("Aggregation", Aggregation.class, (ObservableValue)this.puDefinition.aggregationProperty());
        aggregationItem.setNullable(false);
        aggregationItem.setValidator(Validators.createNotEmptyValidator((String)"Aggregation must be not empty"));
        this.sheet.getItems().addAll((Object[])new PropertySheet.Item[]{this.idItem, keyItem, nameItem, aggregationItem});
        this.hasChanges.bind((ObservableValue)PropertyItemsHelper.createHasChangesProperty((Collection)this.sheet.getItems()));
        this.hasErrors.bind((ObservableValue)PropertyItemsHelper.createHasErrorsProperty((Collection)this.sheet.getItems()));
        parent.setCenter((Node)this.sheet);
        if (readOnly) {
            PropertyItemsHelper.setReadOnly((Collection)this.sheet.getItems());
        }
        this.hasChanges.addListener((o, ov, nv) -> this.part.setDirty(nv != false || this.puDefinition.getId() == null));
    }

    @Persist
    public void save() {
        if (!this.hasChanges.get() && this.idItem.getValue() != null) {
            return;
        }
        if (this.hasErrors.get()) {
            Alert alert = new Alert(Alert.AlertType.WARNING);
            alert.setContentText(String.format("Cannot save %s. Fix errors first.", this.puDefinition.toString()));
            alert.showAndWait();
            return;
        }
        Transaction trx = Transactions.begin();
        try {
            try {
                this.idItem.setValue((Object)PhysicalUnitDAO.saveOrUpdate((Transaction)trx, (PhysicalUnitDefinition)this.puDefinition));
                Transactions.commitSync((Transaction)trx);
                PropertyItemsHelper.resetHasChangesProperties((Collection)this.sheet.getItems());
                this.part.setDirty(false);
                this.part.setLabel(this.puDefinition.toString());
                EnginPartUtils.refreshItems(this.puDefinition, this.part);
            }
            catch (DAOOperationException exc) {
                Transactions.rollback((Transaction)trx);
                ExceptionDialog dlg = new ExceptionDialog((Throwable)exc);
                dlg.initOwner(this.scene.getWindow());
                dlg.setContentText("Error saving physical unit");
                dlg.show();
                Transactions.close((Transaction)trx);
                return;
            }
        }
        finally {
            Transactions.close((Transaction)trx);
        }
        PartUtils.refreshParts((EPartService)this.partService, Column.class);
        Alert alert = new Alert(Alert.AlertType.INFORMATION);
        alert.initOwner(this.scene.getWindow());
        alert.setContentText("Physical Units are cached on client side.\r\nAll clients needs to be restartet to apply changes!");
        alert.show();
    }

    @PreDestroy
    protected void close() {
        this.part.setDirty(false);
    }
}

